<?php

use Phinx\Migration\AbstractMigration;
use Rah\Danpu\Dump;
use Rah\Danpu\Import;

class AddMysteryDatabase extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {

        $dbName = DB_WARPIT_MAIN . "_Mystery";
        $sql = "SHOW DATABASES LIKE '$dbName'";

        $databseData = $this->query($sql)->fetchAll();

        if(count($databseData) === 0){
            $tableName = DB_WARPIT_MAIN . "._WarpitConfig";
            $sql = "INSERT INTO $tableName (prefix, cName, cValue) VALUES ('database','table_warpit_mystery','$dbName')";
            $this->execute($sql);

            //We imoprt database
            $dbDumpPath = PATH_TO_ROOT .'db/database/Warpit_Mystery.sql';
            $this->mcreateDatabase($dbName);
            $this->mimportDatabase($dbDumpPath, MYSQL_USER, MYSQL_PASS, $dbName, WARPIT_HOST);
        }
        else {
            echo "===========>>    Mystery database already exists!    <<===========";
        }
    }

    protected function mcreateDatabase($name)
    {
        $create_sql = "CREATE DATABASE IF NOT EXISTS `" . $name . "` /*!40100 COLLATE 'utf8_general_ci' */";
        $this->execute($create_sql);

        return true;
    }

    protected function mimportDatabase($fileName, $dbUser, $dbPassword, $dbName, $host)
    {
          $dump = new Dump;
          $dump
              ->file($fileName)
              ->dsn('mysql:dbname=' . $dbName . ';host='.$host)
              ->user($dbUser)
              ->pass($dbPassword)
          ;

          new Import($dump);
    }
}
