<?php

use Phinx\Migration\AbstractMigration;

class AddSmsStatisticsTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * http://docs.phinx.org/en/latest/migrations.html#the-abstractmigration-class
     *
     * The following commands can be used in this method and Phinx will
     * automatically reverse them when rolling back:
     *
     *    createTable
     *    renameTable
     *    addColumn
     *    renameColumn
     *    addIndex
     *    addForeignKey
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change()
    {
        $tableName = DB_WARPIT_USERSPOOL . ".`_smsStatistics`";
        $sql = "CREATE TABLE IF NOT EXISTS $tableName (
        	`id` INT(11) NOT NULL AUTO_INCREMENT,
        	`telephone` VARCHAR(15) NULL DEFAULT NULL,
        	`id_project` INT(11) NOT NULL DEFAULT '0',
        	`id_user` INT(11) NOT NULL DEFAULT '0',
        	`send_date` DATETIME NULL DEFAULT NULL,
        	`status` INT(11) NOT NULL DEFAULT '0',
        	PRIMARY KEY (`id`),
        	INDEX `id_user` (`id_user`)
        )
        COLLATE='utf8_general_ci'
        ENGINE=InnoDB
        AUTO_INCREMENT=1";

        $this->execute($sql);
    }
}
