--
-- Table structure for table `_Emails`
--

DROP TABLE IF EXISTS `_Emails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_Emails` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `id_account` int(11) NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mail_from` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mail_from_label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_Emails`
--

LOCK TABLES `_Emails` WRITE;
/*!40000 ALTER TABLE `_Emails` DISABLE KEYS */;
/*!40000 ALTER TABLE `_Emails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_FieldUser`
--

DROP TABLE IF EXISTS `_FieldUser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_FieldUser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_field` int(11) NOT NULL DEFAULT '0',
  `orderBy` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_field_id_user` (`id_user`,`id_field`),
  KEY `id_user` (`id_user`),
  KEY `id_field` (`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_FieldUser`
--

LOCK TABLES `_FieldUser` WRITE;
/*!40000 ALTER TABLE `_FieldUser` DISABLE KEYS */;
/*!40000 ALTER TABLE `_FieldUser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_IncentiveCoupons`
--

DROP TABLE IF EXISTS `_IncentiveCoupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_IncentiveCoupons` (
  `id` int(7) unsigned NOT NULL AUTO_INCREMENT,
  `incentive_code` varchar(255) CHARACTER SET cp1250 NOT NULL,
  `incentive_points` int(11) NOT NULL,
  `value_of_coupon` int(11) NOT NULL DEFAULT '0',
  `startTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `incentive_status` int(11) NOT NULL,
  `client_incentive_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `id_incentive_group` int(10) unsigned NOT NULL DEFAULT '0',
  `id_user` int(5) NOT NULL,
  UNIQUE KEY `wwwlink` (`incentive_code`,`id_incentive_group`),
  KEY `id` (`id`),
  KEY `id_user` (`id_user`),
  KEY `id_project` (`id_incentive_group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_IncentiveCoupons`
--

LOCK TABLES `_IncentiveCoupons` WRITE;
/*!40000 ALTER TABLE `_IncentiveCoupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `_IncentiveCoupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_IncentiveGroups`
--

DROP TABLE IF EXISTS `_IncentiveGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_IncentiveGroups` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `orderBy` int(5) NOT NULL,
  `idLab` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_IncentiveGroups`
--

LOCK TABLES `_IncentiveGroups` WRITE;
/*!40000 ALTER TABLE `_IncentiveGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `_IncentiveGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_IncentiveProperties`
--

DROP TABLE IF EXISTS `_IncentiveProperties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_IncentiveProperties` (
  `id` int(5) NOT NULL COMMENT 'Equeals id_project !!!',
  `allow_download` tinyint(1) NOT NULL DEFAULT '0',
  `delete_after_download` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `download_link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `end_link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `project_label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_IncentiveProperties`
--

LOCK TABLES `_IncentiveProperties` WRITE;
/*!40000 ALTER TABLE `_IncentiveProperties` DISABLE KEYS */;
/*!40000 ALTER TABLE `_IncentiveProperties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_IncentiveStatus`
--

DROP TABLE IF EXISTS `_IncentiveStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_IncentiveStatus` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `id_project` int(4) NOT NULL,
  `id_status` tinyint(3) unsigned NOT NULL,
  `link` varchar(255) CHARACTER SET cp1250 NOT NULL,
  `statusComment` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `webPoints` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_IncentiveStatus`
--

LOCK TABLES `_IncentiveStatus` WRITE;
/*!40000 ALTER TABLE `_IncentiveStatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `_IncentiveStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_Interviewer`
--

DROP TABLE IF EXISTS `_Interviewer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_Interviewer` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Email_unique` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_Interviewer`
--

LOCK TABLES `_Interviewer` WRITE;
/*!40000 ALTER TABLE `_Interviewer` DISABLE KEYS */;
/*!40000 ALTER TABLE `_Interviewer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_InterviewerFieldOrder`
--

DROP TABLE IF EXISTS `_InterviewerFieldOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_InterviewerFieldOrder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `orderBy` int(11) NOT NULL,
  `is_hidden` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_InterviewerFieldOrder`
--

LOCK TABLES `_InterviewerFieldOrder` WRITE;
/*!40000 ALTER TABLE `_InterviewerFieldOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `_InterviewerFieldOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_InterviewerStatistics`
--

DROP TABLE IF EXISTS `_InterviewerStatistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_InterviewerStatistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_project` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_template` int(11) NOT NULL DEFAULT '0',
  `send_date` int(11) DEFAULT '0',
  `email_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1 invitation, 2 reminder, 3 email appointment',
  PRIMARY KEY (`id`),
  KEY `id_project` (`id_project`),
  KEY `id_user` (`id_user`),
  KEY `id_template` (`id_template`),
  KEY `email_type` (`email_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_InterviewerStatistics`
--

LOCK TABLES `_InterviewerStatistics` WRITE;
/*!40000 ALTER TABLE `_InterviewerStatistics` DISABLE KEYS */;
/*!40000 ALTER TABLE `_InterviewerStatistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_InterviewerStatuses`
--

DROP TABLE IF EXISTS `_InterviewerStatuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_InterviewerStatuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `interviewer_id` int(11) NOT NULL,
  `definedStatus` tinyint(3) unsigned NOT NULL,
  `definedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `interviewer_id` (`interviewer_id`,`definedStatus`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='removal request - 9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_InterviewerStatuses`
--

LOCK TABLES `_InterviewerStatuses` WRITE;
/*!40000 ALTER TABLE `_InterviewerStatuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `_InterviewerStatuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_InterviewerStructure`
--

DROP TABLE IF EXISTS `_InterviewerStructure`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_InterviewerStructure` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `field_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_text` varchar(150) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_type` tinyint(2) NOT NULL DEFAULT '0',
  `data_type` tinyint(4) NOT NULL,
  `field_options` text COLLATE utf8_unicode_ci NOT NULL,
  `field_size` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `orderBy` int(5) NOT NULL,
  `field_order` smallint(4) NOT NULL DEFAULT '900',
  `field_hidden` tinyint(1) NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  `field_opt1` int(11) NOT NULL,
  `field_defaultValue` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_cb_checked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_InterviewerStructure`
--

LOCK TABLES `_InterviewerStructure` WRITE;
/*!40000 ALTER TABLE `_InterviewerStructure` DISABLE KEYS */;
/*!40000 ALTER TABLE `_InterviewerStructure` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_MailAttachments`
--

DROP TABLE IF EXISTS `_MailAttachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_MailAttachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` smallint(11) unsigned NOT NULL,
  `filePath` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `fileSize` int(11) NOT NULL,
  `embeded` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_id` (`template_id`,`filePath`,`fileName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_MailAttachments`
--

LOCK TABLES `_MailAttachments` WRITE;
/*!40000 ALTER TABLE `_MailAttachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `_MailAttachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_MailCatcher`
--

DROP TABLE IF EXISTS `_MailCatcher`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_MailCatcher` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mail_id` varchar(100) NOT NULL,
  `is_report` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(8) NOT NULL,
  `checked_user` tinyint(1) NOT NULL,
  `send_mail_id` varchar(100) NOT NULL,
  `mail_address` varchar(100) NOT NULL,
  `send_subject` varchar(200) NOT NULL,
  `arrival_date` datetime NOT NULL,
  `send_date` datetime NOT NULL,
  `mail_date` datetime NOT NULL,
  `sendStatistic_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1250;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_MailCatcher`
--

LOCK TABLES `_MailCatcher` WRITE;
/*!40000 ALTER TABLE `_MailCatcher` DISABLE KEYS */;
/*!40000 ALTER TABLE `_MailCatcher` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_MailStatistic`
--

DROP TABLE IF EXISTS `_MailStatistic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_MailStatistic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mail_set` int(11) NOT NULL,
  `interviewer_id` int(11) NOT NULL DEFAULT '0',
  `mail_address` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `date_sent` datetime NOT NULL,
  `mail_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mail_set` (`mail_set`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_MailStatistic`
--

LOCK TABLES `_MailStatistic` WRITE;
/*!40000 ALTER TABLE `_MailStatistic` DISABLE KEYS */;
/*!40000 ALTER TABLE `_MailStatistic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_MailTemplates`
--

DROP TABLE IF EXISTS `_MailTemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_MailTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `mail_from` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_MailTemplates`
--

LOCK TABLES `_MailTemplates` WRITE;
/*!40000 ALTER TABLE `_MailTemplates` DISABLE KEYS */;
/*!40000 ALTER TABLE `_MailTemplates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_PortalStaticPage`
--

DROP TABLE IF EXISTS `_PortalStaticPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_PortalStaticPage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` varchar(50) NOT NULL,
  `si` longtext NOT NULL,
  `hr` text NOT NULL,
  `sr` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `area` (`area`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_PortalStaticPage`
--

LOCK TABLES `_PortalStaticPage` WRITE;
/*!40000 ALTER TABLE `_PortalStaticPage` DISABLE KEYS */;
INSERT INTO `_PortalStaticPage` VALUES (1,'faq','<h1>Frequently asked questions</h1>','',''),(2,'pravila','<h1>Web panel rules</h1>','','');
/*!40000 ALTER TABLE `_PortalStaticPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_PortalTranslationTabel`
--

DROP TABLE IF EXISTS `_PortalTranslationTabel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_PortalTranslationTabel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` varchar(50) NOT NULL,
  `langKey` varchar(50) NOT NULL,
  `si` text NOT NULL,
  `hr` text NOT NULL,
  `sr` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `area` (`area`,`langKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_PortalTranslationTabel`
--

LOCK TABLES `_PortalTranslationTabel` WRITE;
/*!40000 ALTER TABLE `_PortalTranslationTabel` DISABLE KEYS */;
/*!40000 ALTER TABLE `_PortalTranslationTabel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_ProgramMenu`
--

DROP TABLE IF EXISTS `_ProgramMenu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_ProgramMenu` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_ProgramMenu`
--

LOCK TABLES `_ProgramMenu` WRITE;
/*!40000 ALTER TABLE `_ProgramMenu` DISABLE KEYS */;
INSERT INTO `_ProgramMenu` VALUES (5,0,3,'SQL','webuserspool/_icons/sql.gif'),(7,0,5,'Mail','webuserspool/_icons/mail.gif'),(8,0,7,'Cati Tools',''),(9,4,1,'fake',''),(10,5,1,'Add/Edit',''),(11,7,1,'Accounts',''),(12,7,2,'Send',''),(13,7,3,'Statistics',''),(14,8,1,'WEBpoints project statistics',''),(4,0,2,'Fields','webuserspool/_icons/fields.gif'),(19,0,8,'Sampling','RMicon_make_sample'),(18,0,6,'Redirection Manager','RMicon_redirect'),(20,0,10,'Portal Manager',''),(21,20,1,'Language Pack',''),(22,20,2,'Static pages',''),(23,22,1,'Faq',''),(24,22,1,'Pravila',''),(25,0,9,'Recode','RMicon_make_sample'),(27,20,1,'FriendPoints',''),(28,0,6,'Incentive system','RMicon_incentive'),(29,30,1,'Active panelists',''),(30,0,6,'Panelist overview',''),(31,30,2,'Inactive panelists','');
/*!40000 ALTER TABLE `_ProgramMenu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_QueryMachineConstruction`
--

DROP TABLE IF EXISTS `_QueryMachineConstruction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_QueryMachineConstruction` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_template` int(5) NOT NULL,
  `orderBy` int(5) NOT NULL,
  `conditionField` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `field_id` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `operation` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `valueField` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `openBracket` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `closeBracket` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_QueryMachineConstruction`
--

LOCK TABLES `_QueryMachineConstruction` WRITE;
/*!40000 ALTER TABLE `_QueryMachineConstruction` DISABLE KEYS */;
/*!40000 ALTER TABLE `_QueryMachineConstruction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_QueryMachineFields`
--

DROP TABLE IF EXISTS `_QueryMachineFields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_QueryMachineFields` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `orderBy` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_QueryMachineFields`
--

LOCK TABLES `_QueryMachineFields` WRITE;
/*!40000 ALTER TABLE `_QueryMachineFields` DISABLE KEYS */;
INSERT INTO `_QueryMachineFields` VALUES (1,0,'Groups & Projects',1),(2,0,'PERSONAL INFORMATION',3),(3,1,'Groups',1),(4,1,'Interviewer',3),(5,1,'Projects',2),(6,1,'email',4),(7,0,'Web Points',2),(8,7,'Gained',1),(9,7,'Used',2),(10,7,'Total',3),(11,1,'User ID',5);
/*!40000 ALTER TABLE `_QueryMachineFields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_QueryMachineTemplates`
--

DROP TABLE IF EXISTS `_QueryMachineTemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_QueryMachineTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_sup` int(11) NOT NULL,
  `idLab` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `orderBy` int(11) NOT NULL,
  `is_leaf` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_QueryMachineTemplates`
--

LOCK TABLES `_QueryMachineTemplates` WRITE;
/*!40000 ALTER TABLE `_QueryMachineTemplates` DISABLE KEYS */;
/*!40000 ALTER TABLE `_QueryMachineTemplates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_Recoder`
--

DROP TABLE IF EXISTS `_Recoder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_Recoder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visible` tinyint(4) NOT NULL,
  `recode_condition` varchar(255) NOT NULL,
  `recode_variable` varchar(50) NOT NULL,
  `recode_value` varchar(20) NOT NULL,
  `orderBy` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_Recoder`
--

LOCK TABLES `_Recoder` WRITE;
/*!40000 ALTER TABLE `_Recoder` DISABLE KEYS */;
/*!40000 ALTER TABLE `_Recoder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_RedirectEndLink`
--

DROP TABLE IF EXISTS `_RedirectEndLink`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_RedirectEndLink` (
  `endLinkId` int(8) NOT NULL AUTO_INCREMENT,
  `id_project` int(4) NOT NULL DEFAULT '0',
  `id_user` int(4) NOT NULL DEFAULT '0',
  `int_finish` tinyint(1) NOT NULL DEFAULT '0',
  `startTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ProviderUrl` varchar(255) NOT NULL DEFAULT '',
  `returnSID` varchar(80) NOT NULL,
  PRIMARY KEY (`endLinkId`),
  KEY `id_project` (`id_project`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1250;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_RedirectEndLink`
--

LOCK TABLES `_RedirectEndLink` WRITE;
/*!40000 ALTER TABLE `_RedirectEndLink` DISABLE KEYS */;
/*!40000 ALTER TABLE `_RedirectEndLink` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_RedirectLinks`
--

DROP TABLE IF EXISTS `_RedirectLinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_RedirectLinks` (
  `id` int(7) unsigned NOT NULL AUTO_INCREMENT,
  `wwwlink` varchar(255) CHARACTER SET cp1250 NOT NULL,
  `id_project` int(4) unsigned NOT NULL,
  `id_user` int(5) NOT NULL,
  UNIQUE KEY `wwwlink` (`wwwlink`,`id_project`),
  KEY `id` (`id`),
  KEY `id_user` (`id_user`),
  KEY `id_project` (`id_project`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_RedirectLinks`
--

LOCK TABLES `_RedirectLinks` WRITE;
/*!40000 ALTER TABLE `_RedirectLinks` DISABLE KEYS */;
/*!40000 ALTER TABLE `_RedirectLinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_RedirectProjects`
--

DROP TABLE IF EXISTS `_RedirectProjects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_RedirectProjects` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `orderBy` int(5) NOT NULL,
  `idLab` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_RedirectProjects`
--

LOCK TABLES `_RedirectProjects` WRITE;
/*!40000 ALTER TABLE `_RedirectProjects` DISABLE KEYS */;
/*!40000 ALTER TABLE `_RedirectProjects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_RedirectProperties`
--

DROP TABLE IF EXISTS `_RedirectProperties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_RedirectProperties` (
  `id` int(5) NOT NULL COMMENT 'Equeals id_project !!!',
  `survey_project_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `survey_close` tinyint(1) NOT NULL,
  `survey_close_link` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `survey_param_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'returnSID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_RedirectProperties`
--

LOCK TABLES `_RedirectProperties` WRITE;
/*!40000 ALTER TABLE `_RedirectProperties` DISABLE KEYS */;
/*!40000 ALTER TABLE `_RedirectProperties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_RedirectStatus`
--

DROP TABLE IF EXISTS `_RedirectStatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_RedirectStatus` (
  `id` smallint(3) NOT NULL AUTO_INCREMENT,
  `id_project` int(4) NOT NULL,
  `id_status` tinyint(3) unsigned NOT NULL,
  `link` varchar(255) CHARACTER SET cp1250 NOT NULL,
  `statusComment` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `webPoints` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_RedirectStatus`
--

LOCK TABLES `_RedirectStatus` WRITE;
/*!40000 ALTER TABLE `_RedirectStatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `_RedirectStatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_SMTP_accounts`
--

DROP TABLE IF EXISTS `_SMTP_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_SMTP_accounts` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `local` tinyint(1) NOT NULL,
  `host` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(6) NOT NULL,
  `helo_message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `askPassword` tinyint(4) NOT NULL DEFAULT '0',
  `mail_from` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `mail_from_label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_SMTP_accounts`
--

LOCK TABLES `_SMTP_accounts` WRITE;
/*!40000 ALTER TABLE `_SMTP_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `_SMTP_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_SamplingTemplates`
--

DROP TABLE IF EXISTS `_SamplingTemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_SamplingTemplates` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `orderBy` int(5) NOT NULL,
  `idLab` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_group` varchar(100) NOT NULL,
  `id_fields` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_SamplingTemplates`
--

LOCK TABLES `_SamplingTemplates` WRITE;
/*!40000 ALTER TABLE `_SamplingTemplates` DISABLE KEYS */;
/*!40000 ALTER TABLE `_SamplingTemplates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_SendMailSet`
--

DROP TABLE IF EXISTS `_SendMailSet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_SendMailSet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_queue` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_schedule` datetime NOT NULL,
  `id_project` int(11) NOT NULL,
  `project_type` int(11) NOT NULL,
  `id_template` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `numSend` int(11) NOT NULL,
  `specialHeaders` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `important` tinyint(1) NOT NULL DEFAULT '0',
  `sendingTimeout` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_project` (`id_project`,`project_type`),
  KEY `id_template` (`id_template`),
  KEY `id_group` (`id_group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_SendMailSet`
--

LOCK TABLES `_SendMailSet` WRITE;
/*!40000 ALTER TABLE `_SendMailSet` DISABLE KEYS */;
/*!40000 ALTER TABLE `_SendMailSet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_TestMails`
--

DROP TABLE IF EXISTS `_TestMails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_TestMails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interViewerId` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_TestMails`
--

LOCK TABLES `_TestMails` WRITE;
/*!40000 ALTER TABLE `_TestMails` DISABLE KEYS */;
/*!40000 ALTER TABLE `_TestMails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_UserProjectFieldOrder`
--

DROP TABLE IF EXISTS `_UserProjectFieldOrder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_UserProjectFieldOrder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_project` int(11) NOT NULL,
  `field_type` int(11) NOT NULL,
  `id_field` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `orderBy` int(11) NOT NULL,
  `is_hidden` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_UserProjectFieldOrder`
--

LOCK TABLES `_UserProjectFieldOrder` WRITE;
/*!40000 ALTER TABLE `_UserProjectFieldOrder` DISABLE KEYS */;
/*!40000 ALTER TABLE `_UserProjectFieldOrder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_group_link`
--

DROP TABLE IF EXISTS `_group_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_group_link` (
  `id_group` int(5) NOT NULL DEFAULT '0',
  `id` int(8) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_group` (`id_group`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_group_link`
--

LOCK TABLES `_group_link` WRITE;
/*!40000 ALTER TABLE `_group_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `_group_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_groups`
--

DROP TABLE IF EXISTS `_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_groups` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `id_sup` int(5) NOT NULL,
  `orderBy` tinyint(3) NOT NULL,
  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `is_leaf` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_groups`
--

LOCK TABLES `_groups` WRITE;
/*!40000 ALTER TABLE `_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_portalSessionTracker`
--

DROP TABLE IF EXISTS `_portalSessionTracker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_portalSessionTracker` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `sessid` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `login_date` datetime NOT NULL,
  `last_impression` datetime NOT NULL,
  `logout_date` datetime NOT NULL,
  `user_id` int(4) NOT NULL,
  `login_status` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sessid` (`sessid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_portalSessionTracker`
--

LOCK TABLES `_portalSessionTracker` WRITE;
/*!40000 ALTER TABLE `_portalSessionTracker` DISABLE KEYS */;
/*!40000 ALTER TABLE `_portalSessionTracker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_input_labels`
--

DROP TABLE IF EXISTS `user_input_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_input_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` tinyint(2) NOT NULL DEFAULT '0',
  `lab_field` int(50) NOT NULL DEFAULT '0',
  `lab_code` int(5) NOT NULL,
  `lab_label` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lab_position` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQUE_KEY` (`language`,`lab_field`,`lab_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_input_labels`
--

LOCK TABLES `user_input_labels` WRITE;
/*!40000 ALTER TABLE `user_input_labels` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_input_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `web_cati_structure`
--

DROP TABLE IF EXISTS `web_cati_structure`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `web_cati_structure` (
  `counter` int(3) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_text` varchar(150) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_type` tinyint(2) NOT NULL DEFAULT '0',
  `field_options` text COLLATE utf8_unicode_ci NOT NULL,
  `field_size` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field_order` smallint(4) NOT NULL DEFAULT '900',
  `field_hidden` tinyint(1) NOT NULL,
  PRIMARY KEY (`counter`),
  KEY `counter` (`counter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `web_cati_structure`
--

LOCK TABLES `web_cati_structure` WRITE;
/*!40000 ALTER TABLE `web_cati_structure` DISABLE KEYS */;
/*!40000 ALTER TABLE `web_cati_structure` ENABLE KEYS */;
UNLOCK TABLES;
