--
-- Table structure for table `_LiveUpdateClientVersion`
--

DROP TABLE IF EXISTS `_LiveUpdateClientVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateClientVersion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `current_version` int(11) NOT NULL DEFAULT '0',
  `sql_count` int(11) NOT NULL DEFAULT '0' COMMENT 'Number of the sqlexecuted before error',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateClientVersion`
--

LOCK TABLES `_LiveUpdateClientVersion` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateClientVersion` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateClientVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateClients`
--

DROP TABLE IF EXISTS `_LiveUpdateClients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateClients` (
  `id_client` int(11) NOT NULL AUTO_INCREMENT,
  `clientID` varchar(50) NOT NULL,
  `user_id` int(11) NOT NULL COMMENT 'user_id of the last user that initiated Live Updae on this machine',
  `client_active` tinyint(4) NOT NULL,
  `date_registration` datetime NOT NULL,
  `date_last_update` datetime NOT NULL,
  `allow_download` tinyint(1) NOT NULL,
  `allow_upload` tinyint(1) NOT NULL,
  PRIMARY KEY (`id_client`),
  UNIQUE KEY `clientID` (`clientID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateClients`
--

LOCK TABLES `_LiveUpdateClients` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateClients` DISABLE KEYS */;
INSERT INTO `_LiveUpdateClients` VALUES (1,'SOLVEX1',0,1,'2015-12-16 12:41:28','2015-12-16 13:11:21',1,0);
/*!40000 ALTER TABLE `_LiveUpdateClients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateFiles`
--

DROP TABLE IF EXISTS `_LiveUpdateFiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateFiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_type` tinyint(4) NOT NULL,
  `relative_path` text COLLATE utf8_unicode_ci NOT NULL,
  `file_name` text COLLATE utf8_unicode_ci NOT NULL,
  `version` int(11) NOT NULL DEFAULT '20000',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateFiles`
--

LOCK TABLES `_LiveUpdateFiles` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateFiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateFiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateLog`
--

DROP TABLE IF EXISTS `_LiveUpdateLog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateLog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dateDone` datetime NOT NULL,
  `project_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `clientID` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `browser` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `version_start` int(11) NOT NULL,
  `version_stop` int(11) NOT NULL,
  `tableCheckType` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `tableCheckText` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `uploadNumberRecords` int(11) NOT NULL,
  `capi_ok_records` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateLog`
--

LOCK TABLES `_LiveUpdateLog` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateLog` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateLog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateLogRaw`
--

DROP TABLE IF EXISTS `_LiveUpdateLogRaw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateLogRaw` (
  `id` int(11) NOT NULL,
  `fileData` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateLogRaw`
--

LOCK TABLES `_LiveUpdateLogRaw` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateLogRaw` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateLogRaw` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateScripts`
--

DROP TABLE IF EXISTS `_LiveUpdateScripts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateScripts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_file` int(11) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `script_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `paramsJSON` text COLLATE utf8_unicode_ci COMMENT 'parameters for script in JSON format',
  `executed_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateScripts`
--

LOCK TABLES `_LiveUpdateScripts` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateScripts` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateScripts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateSql`
--

DROP TABLE IF EXISTS `_LiveUpdateSql`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateSql` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `version` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `project_id` int(11) NOT NULL,
  `statement_id` int(11) NOT NULL,
  `sql_database` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `sql_statments` longtext COLLATE utf8_unicode_ci NOT NULL,
  `liveupdate_comment` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `insertTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `users_id` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liveupdate_version` (`version`,`project_id`,`statement_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateSql`
--

LOCK TABLES `_LiveUpdateSql` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateSql` DISABLE KEYS */;
INSERT INTO `_LiveUpdateSql` VALUES (1,'',2,11,'table_warpit_webcati_base','\r\n<stat>REPLACE INTO _Projects SET id = \'2\',key_proj = \'2-aa3yqr9eix\',proj_name = \'firstProject\',language = \'46\',naziv_proj = \'test tole\',old = \'N\',created = \'16.12.2015 - 11:20\',creat_name = \'Administrator \',modify = \'16.12.2015 - 11:20\',modi_name = \'Administrator \',active = \'1\',start_date = \'2015-12-16 00:00:00\',end_date = \'2016-12-16 00:00:00\',print_filter = \'1\',print_jump = \'1\',print_condition = \'1\',print_answfilter = \'1\',stat_show_var = \'0\',stat_show_val = \'0\',lock_app_to_user = \'1\',rotation = \'N\',regionopt = \'\',hide_back_button = \'0\',id_telname = \'\',tel_reserve = \'0\',id_capiTable = \'0\',capi_reserve = \'0\',qt_useregtel = \'0\',qt_useactel = \'0\',reg_strictlock = \'0\',stat_show_scaleborder = \'0\',busy_call_delay = \'20\',noanswer_call_delay = \'120\',callback_call_delay = \'5\',num_max_call = \'3\',num_max_call_app = \'99\',back_delete = \'1\',set_use_autodial = \'0\',quota_vars = \'\',telselect = \'0\',proj_backup = \'\',strictlock_manual = \'0\',ml_showopt_www = \'1\',ml_position_www = \'2\',ml_html_www = \'\',forward_button_link = \'\',back_button_link = \'\',exit_button_link = \'\',help_button_link = \'\',quest_distance_buttons = \'\',submit_where = \'0\',submit_auto = \'0\',question_over = \'0\',user_status_bar = \'\',radio_button_enable = \'\',radio_button_disable = \'\',chk_button_enable = \'\',chk_button_disable = \'\',use_img_radio = \'0\',submit_delay_press = \'1\',exit_alert_msg = \'Are you sure?\',forward_button_disable_link = \'\',back_button_disable_link = \'\',error_img_scale = \'\',start_quest_button_link = \'\',quest_start_alert_msg = \'Are you sure?\',intstat_opt = \'\',webcapi_clear_all = \'0\',webcapi_clear_finished = \'0\',webcapi_finished = \'0\',use_special_sampling = \'0\',wh_special_sampling = \'\',disablebasic = \'0\',call_time_length = \'25\',use_predictive = \'0\',predictive_work = \'0\',predictive_numbers_tofind = \'0\',predictive_overcall = \'0\',isTemplate = \'0\',id_select_layer = \'0\',redirectActive = \'0\',redirectConditions = \'\',interview_show_variable = \'1\',interview_show_ans_value = \'1\',has_user_quotas = \'0\',respondent_searched_fields = \'\',telnum_select_type = \'1\',use_lowest = \'0\',use_lowest_layer = \'\',is_nfield = \'0\',id_nfield_project = \'\',name_nfield_project = \'\',stat_show_filter_in = \'0\',stat_show_filter_out = \'0\',stat_show_goto = \'0\',stat_show_answer_filter = \'0\',stat_show_question_type = \'0\',stat_show_open_end_type = \'0\',limit_interviews = \'0\',number_of_interviews = \'0\',check_for_quota = \'1\';\r\n<stat>REPLACE INTO _ProjectsTree SET id = \'2\',id_sup = \'0\',id_project = \'2\',orderBy = \'1\',idLab = \'firstProject\',node_img = \'\',is_leaf = \'1\',merged = \'0\';\r\n<stat>DELETE FROM  _LanguageProjects WHERE id_project = 2;\r\n<stat>DELETE FROM  _LanguageUserInterface WHERE id_project IN (0, 2);\r\n<stat>DELETE FROM  _QuestionRotation WHERE id_project = 2;\r\n<stat>DELETE FROM  _ProjectExtraVariables  WHERE id_project = 2;\r\n<stat>INSERT INTO _LanguageProjects  SET id_language = \'46\',id_project = \'2\';','UPDATE _Projects table for: firstProject','2015-12-16 11:49:47',''),(2,'',2,12,'table_warpit_webcati','\r\n<stat>DROP TABLE IF EXISTS firstProject; \r\n<stat>DROP TABLE IF EXISTS firstProject_language; \r\n<stat>DROP TABLE IF EXISTS firstProject_script; \r\n<stat>DROP TABLE IF EXISTS firstProject_tree; \r\n<stat>CREATE TABLE `firstProject` (\n  `id` int(5) NOT NULL AUTO_INCREMENT,\n  `q_pos` int(5) NOT NULL,\n  `q_name` char(20) COLLATE utf8_unicode_ci NOT NULL,\n  `tip_sql` int(2) DEFAULT NULL,\n  `drg_sql` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `les_sql` int(2) DEFAULT NULL,\n  `goto_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `fil_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `con_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `open_sql` int(2) DEFAULT NULL,\n  `anno_sql` int(2) DEFAULT NULL,\n  `attachAnswers` int(11) DEFAULT NULL,\n  `attachFalse` tinyint(1) DEFAULT NULL,\n  `rot_sql` text COLLATE utf8_unicode_ci,\n  `srot_sql` int(1) DEFAULT NULL,\n  `erot_sql` int(1) DEFAULT NULL,\n  `srotLegend` int(1) DEFAULT NULL,\n  `erotLegend` int(1) DEFAULT NULL,\n  `srotAttributes` int(1) DEFAULT NULL,\n  `erotAttributes` int(1) DEFAULT NULL,\n  `qrot_sql` char(9) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `id_style` int(8) DEFAULT NULL,\n  `id_mask` int(8) DEFAULT NULL,\n  `must_answer` tinyint(1) NOT NULL DEFAULT \'1\',\n  `disable_question` tinyint(1) NOT NULL DEFAULT \'0\',\n  `answers_filter` tinyint(1) NOT NULL DEFAULT \'0\',\n  `variableTypeBase` tinyint(1) NOT NULL DEFAULT \'4\',\n  `variableTypeOpen` tinyint(1) NOT NULL DEFAULT \'0\',\n  `open_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `open_legend` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `open_attributes` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multi_nogo_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multi_nogo_legends` char(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multilanguage_all` text COLLATE utf8_unicode_ci,\n  `qleave_js_alert` tinyint(1) NOT NULL DEFAULT \'0\',\n  `filter_answer` text COLLATE utf8_unicode_ci,\n  `filter_legend` text COLLATE utf8_unicode_ci,\n  `filter_attributes` text COLLATE utf8_unicode_ci,\n  `hasStructure` tinyint(4) DEFAULT \'0\',\n  `use_for_quotas` tinyint(1) DEFAULT \'0\',\n  `isFinal` tinyint(1) DEFAULT \'0\',\n  `id_showTogether` int(11) NOT NULL DEFAULT \'0\',\n  `answerGroups` text COLLATE utf8_unicode_ci,\n  `legendGroups` text COLLATE utf8_unicode_ci,\n  `id_plugin` int(11) DEFAULT NULL,\n  `id_incentive` int(11) DEFAULT NULL,\n  `incentive_possibilites` tinyint(1) NOT NULL DEFAULT \'0\',\n  `allow_listening` tinyint(1) NOT NULL DEFAULT \'0\',\n  `old_id` int(11) NOT NULL,\n  `up_down_rotchk` int(11) NOT NULL,\n  `up_down_rotvar` int(11) NOT NULL,\n  `repeat_legend` int(11) NOT NULL,\n  `autoSubmit` tinyint(1) NOT NULL DEFAULT \'0\',\n  `missing_values` char(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `q_name` (`q_name`),\n  KEY `q_pos` (`q_pos`),\n  KEY `tip_sql` (`tip_sql`)\n) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_language` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `id_language` int(11) NOT NULL,\n  `id_question` int(11) NOT NULL,\n  `id_text_type` int(11) NOT NULL,\n  `lngText` text COLLATE utf8_unicode_ci NOT NULL,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `qlt_index` (`id_language`,`id_question`,`id_text_type`),\n  KEY `id_question` (`id_question`)\n) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_script` (\n  `id_question` int(11) NOT NULL,\n  `id_event` int(11) NOT NULL,\n  `script` text COLLATE utf8_unicode_ci NOT NULL,\n  PRIMARY KEY (`id_question`,`id_event`)\n) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_tree` (\n  `id` int(3) NOT NULL AUTO_INCREMENT,\n  `id_sup` int(5) NOT NULL,\n  `id_question` int(5) NOT NULL,\n  `orderBy` smallint(6) NOT NULL,\n  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,\n  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,\n  `is_leaf` tinyint(1) NOT NULL,\n  `showTogether` tinyint(1) NOT NULL,\n  PRIMARY KEY (`id`),\n  KEY `id_sup` (`id_sup`),\n  KEY `id_question` (`id_question`),\n  KEY `orderBy` (`orderBy`)\n) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\r\n<stat>INSERT INTO firstProject SET id = \'1\',q_pos = \'-6\',q_name = \'_Start\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'true#1\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'2\',q_pos = \'-5\',q_name = \'_End\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'3\',q_pos = \'-15\',q_name = \'_notAllow\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'4\',q_pos = \'-16\',q_name = \'_notActive\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'5\',q_pos = \'1\',q_name = \'q1\',tip_sql = \'1\',drg_sql = \'\',les_sql = \'1\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'1\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'0\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject_language SET id = \'1\',id_language = \'46\',id_question = \'4\',id_text_type = \'2\',lngText = \'This survey is not active!\';\r\n<stat>INSERT INTO firstProject_language SET id = \'2\',id_language = \'46\',id_question = \'3\',id_text_type = \'2\',lngText = \'Thank you for participating in this survey!\';\r\n<stat>INSERT INTO firstProject_language SET id = \'3\',id_language = \'46\',id_question = \'2\',id_text_type = \'2\',lngText = \'Questionnaire finished\';\r\n<stat>INSERT INTO firstProject_language SET id = \'4\',id_language = \'46\',id_question = \'1\',id_text_type = \'2\',lngText = \'Welcome text\';\r\n<stat>INSERT INTO firstProject_language SET id = \'5\',id_language = \'46\',id_question = \'5\',id_text_type = \'2\',lngText = \'tole testiram\';\r\n<stat>INSERT INTO firstProject_language SET id = \'6\',id_language = \'46\',id_question = \'5\',id_text_type = \'3\',lngText = \'1 test1/2 test2\';\r\n<stat>INSERT INTO firstProject_tree SET id = \'5\',id_sup = \'0\',id_question = \'5\',orderBy = \'1\',idLab = \'q1\',node_img = \'\',is_leaf = \'1\',showTogether = \'0\';','CREATE questionnaire: firstProject','2015-12-16 11:49:47',''),(3,'',2,3,'table_warpit_webcati_base','\r\n<stat>#BACKUP firstProject_structure ;\r\n<stat>DROP TABLE IF EXISTS firstProject_structure;\r\n<stat>DROP TABLE IF EXISTS firstProject___EngineLog;\r\n<stat>DELETE FROM  _www_interviewer_statistics WHERE id_project = 2;\r\n<stat>CREATE TABLE `firstProject_structure` (\n  `id` int(7) NOT NULL AUTO_INCREMENT,\n  `id_clien` int(5) DEFAULT NULL,\n  `flag_cli` int(1) DEFAULT NULL,\n  `user_id` int(5) DEFAULT NULL,\n  `user_type` tinyint(4) DEFAULT NULL,\n  `id_loginSID` int(11) DEFAULT NULL,\n  `id_device` tinyint(4) DEFAULT NULL,\n  `id_language` tinyint(3) unsigned DEFAULT NULL,\n  `smpl_var` int(1) DEFAULT NULL,\n  `sp_adult` int(1) DEFAULT NULL,\n  `sp_man` int(1) DEFAULT NULL,\n  `id_site` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `status` int(8) DEFAULT NULL,\n  `status_rec` int(8) DEFAULT NULL,\n  `flag_bad` int(3) NOT NULL DEFAULT \'99\',\n  `t_status` int(11) unsigned DEFAULT NULL,\n  `t_start` int(11) unsigned DEFAULT NULL,\n  `t_stop` int(11) unsigned DEFAULT NULL,\n  `d_status` datetime DEFAULT NULL,\n  `d_start` datetime DEFAULT NULL,\n  `d_stop` datetime DEFAULT NULL,\n  `t_pause` int(11) NOT NULL DEFAULT \'0\',\n  `t_diffs` int(10) NOT NULL DEFAULT \'0\',\n  `QT_user_id` int(5) DEFAULT NULL,\n  `q1` int(10) DEFAULT NULL,\n  PRIMARY KEY (`id`),\n  KEY `user_id_type` (`user_id`,`user_type`),\n  KEY `status` (`status`,`status_rec`),\n  KEY `id_device` (`id_device`),\n  KEY `id_language` (`id_language`),\n  KEY `flag_bad` (`flag_bad`),\n  KEY `id_site` (`id_site`(5)),\n  KEY `id_loginSID` (`id_loginSID`),\n  KEY `sp_man` (`sp_man`)\n) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\r\n<stat>CREATE TABLE `firstProject___EngineLog` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `id_structure` int(11) NOT NULL,\n  `id_question` smallint(6) NOT NULL,\n  `id_user` int(11) NOT NULL,\n  `user_type` tinyint(4) NOT NULL,\n  `id_language` smallint(6) DEFAULT NULL,\n  `q_name` varchar(25) COLLATE utf8_unicode_ci NOT NULL,\n  `currentRotationString` text COLLATE utf8_unicode_ci NOT NULL,\n  `questionnairePath` text COLLATE utf8_unicode_ci NOT NULL,\n  `engineTime` int(11) NOT NULL,\n  `questStart` int(11) DEFAULT NULL,\n  `questEnd` int(11) DEFAULT NULL,\n  `arriveStatus` tinyint(4) DEFAULT NULL,\n  `eventLogger` text COLLATE utf8_unicode_ci,\n  PRIMARY KEY (`id`),\n  KEY `id_structure` (`id_structure`)\n) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;','CREATE structure table: firstProject','2015-12-16 11:49:47',''),(4,'',2,5,'table_warpit_webcati_base','\r\n<stat>INSERT IGNORE INTO `_www_ids` (`id`, `id_user`, `user_type`, `id_project`, `id_site`, `loginSID`, `idGenStruc`) VALUES (null, 0, 3, -2, 0, \'7e432d983351982\', 0);\r\n<stat>DELETE FROM _www_ids WHERE id_user>0 AND user_type=0 AND id_project=2 AND id_site=0 AND id_user NOT IN (SELECT * FROM (SELECT id_user FROM `_www_ids` WHERE id_user>0 AND user_type=0 AND id_site=0 AND id_project=-2) AS p );\r\n<stat>UPDATE IGNORE `_www_ids` SET `id_project`=ABS(`id_project`), `loginSID` = CONCAT(`loginSID`,\'-\',`id`) WHERE `id_project`<0;\r\n<stat>DELETE FROM `_www_ids` WHERE `id_project`<0;','UPDATE Questionnaire aprooved users: firstProject','2015-12-16 11:49:47',''),(6,'',2,7,'table_warpit_webcati_base','\r\n<stat>TRUNCATE TABLE _DesignerTemplates;\r\n<stat>TRUNCATE TABLE _DesignerCss;\r\n<stat>TRUNCATE TABLE _DesignerClsPropLink;\r\n<stat>DELETE FROM _DesignerManager WHERE id_project = 2;\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'1\',id_sup = \'0\',name = \'Default\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"100\\\" position=\\\"relative\\\"><DIV id=\\\"101\\\" type=\\\"2\\\" width=\\\"30\\\" height=\\\"20\\\" position=\\\"relative\\\"><VARIABLE id=\\\"115\\\" type=\\\"7\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\"/><DIV id=\\\"116\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"2\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"9\\\"><TEMPLATE id=\\\"105\\\" type=\\\"47\\\" width=\\\"20\\\" height=\\\"161\\\" position=\\\"auto\\\" id_template=\\\"2\\\" question_num_1=\\\"1\\\"/><DIV id=\\\"106\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"107\\\" type=\\\"19\\\" width=\\\"75\\\" height=\\\"20\\\" position=\\\"absolute\\\"/><DIV id=\\\"108\\\" type=\\\"11\\\" width=\\\"80\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><SUBMIT id=\\\"109\\\" type=\\\"10\\\" width=\\\"100\\\" height=\\\"20\\\" position=\\\"absolute\\\" text=\\\"Submit &gt;&gt;\\\"/><DIV id=\\\"110\\\" type=\\\"19\\\" width=\\\"75\\\" height=\\\"20\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"111\\\" type=\\\"25\\\" width=\\\"99.73\\\" height=\\\"6.78\\\" position=\\\"relative\\\" text=\\\"Break interview\\\" catiOnly=\\\"true\\\"/><DIV id=\\\"114\\\" type=\\\"41\\\" width=\\\"99.71\\\" height=\\\"7.13\\\" position=\\\"relative\\\" text=\\\"Go to IDLE\\\" catiOnly=\\\"true\\\"/></DIV><DIV id=\\\"103\\\" type=\\\"2\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"2,3\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'1\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'13\',id_sup = \'0\',name = \'end-template\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"100\\\" position=\\\"relative\\\"><DIV id=\\\"101\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/><DIV id=\\\"102\\\" type=\\\"2\\\" width=\\\"900\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"9\\\"><IMAGE id=\\\"104\\\" type=\\\"8\\\" width=\\\"99.78\\\" height=\\\"150\\\" position=\\\"absolute\\\" src=\\\"http://capi.rmplus.si/WEB_projects/ipsos/logo.gif\\\" RMclass=\\\"9\\\"/><TEMPLATE id=\\\"105\\\" type=\\\"47\\\" width=\\\"20\\\" height=\\\"161\\\" position=\\\"auto\\\" id_template=\\\"2\\\" question_num_1=\\\"1\\\"/></DIV><DIV id=\\\"103\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'2\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'2\',id_sup = \'0\',name = \'defaultBase\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"60\\\" position=\\\"absolute\\\"><INSTRUCTION id=\\\"101\\\" type=\\\"4\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"1\\\" width=\\\"953\\\" height=\\\"63\\\" position=\\\"auto\\\" RMclass=\\\"2\\\"><VARIABLE id=\\\"103\\\" type=\\\"19\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"absolute\\\" question_num=\\\"1\\\" RMclass=\\\"1\\\"/><QUESTION id=\\\"104\\\" type=\\\"3\\\" width=\\\"325\\\" height=\\\"42\\\" position=\\\"auto\\\" question_num=\\\"1\\\" RMclass=\\\"3\\\"/></DIV><DIV id=\\\"105\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"164\\\" position=\\\"auto\\\" RMclass=\\\"6\\\"><ANSWER id=\\\"106\\\" type=\\\"6\\\" width=\\\"191\\\" height=\\\"20\\\" position=\\\"auto\\\" question_num=\\\"1\\\"/></DIV><DIV id=\\\"108\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"170\\\" position=\\\"auto\\\"><DIV id=\\\"109\\\" type=\\\"2\\\" width=\\\"75\\\" height=\\\"99.33\\\" position=\\\"absolute\\\"/><DIV id=\\\"110\\\" type=\\\"40\\\" width=\\\"243\\\" height=\\\"20\\\" position=\\\"auto\\\" text=\\\"Cannot leave the question\\\" question_num=\\\"1\\\" RMclass=\\\"11\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'3\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'3\',id_sup = \'0\',name = \'Answers\',template_xml = \'\',type = \'0\',orderBy = \'5\',is_leaf = \'0\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'10\',id_sup = \'3\',name = \'Basic\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><ANSWER id=\\\"14\\\" type=\\\"6\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"19\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"22\\\" type=\\\"22\\\" width=\\\"30\\\" position=\\\"absolute\\\" height=\\\"22\\\" RMclass=\\\"5\\\"/><DIV id=\\\"35\\\" type=\\\"21\\\" width=\\\"190\\\" height=\\\"20\\\" position=\\\"auto\\\" RMclass=\\\"5\\\"/></DIV><DIV id=\\\"23\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"30\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/><DIV id=\\\"36\\\" type=\\\"21\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/></DIV></ANSWER></DIV>\n\',type = \'0\',orderBy = \'1\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'11\',id_sup = \'3\',name = \'Scale\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><ANSWER id=\\\"30\\\" type=\\\"6\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"31\\\" type=\\\"1\\\" position=\\\"relative\\\" name=\\\"Legend row\\\" height=\\\"33.33\\\" subType=\\\"1\\\"><DIV id=\\\"33\\\" type=\\\"21\\\" width=\\\"485\\\" position=\\\"auto\\\"/><DIV id=\\\"34\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"relative\\\" RMclass=\\\"9\\\"/></DIV><DIV id=\\\"35\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"37\\\" type=\\\"21\\\" width=\\\"33.33\\\" position=\\\"relative\\\" RMclass=\\\"5\\\"/><DIV id=\\\"38\\\" type=\\\"22\\\" width=\\\"404\\\" position=\\\"auto\\\" RMclass=\\\"5,9\\\"/></DIV><DIV id=\\\"39\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"41\\\" type=\\\"21\\\" width=\\\"33.33\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/><DIV id=\\\"42\\\" type=\\\"22\\\" width=\\\"404\\\" position=\\\"auto\\\" RMclass=\\\"7,9\\\"/></DIV></ANSWER></DIV>\n\',type = \'0\',orderBy = \'2\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'4\',id_sup = \'0\',name = \'predictive dailer\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"2\\\" type=\\\"35\\\" width=\\\"99.79\\\" height=\\\"50\\\" position=\\\"absolute\\\"/><DIV id=\\\"4\\\" type=\\\"30\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/><DIV id=\\\"5\\\" type=\\\"39\\\" width=\\\"99.79\\\" height=\\\"7.08\\\" position=\\\"relative\\\"/><DIV id=\\\"6\\\" type=\\\"38\\\" width=\\\"99.79\\\" height=\\\"6.68\\\" position=\\\"relative\\\"/><DIV id=\\\"7\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV>\n\',type = \'1\',orderBy = \'6\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'5\',id_sup = \'0\',name = \'Status\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><QUESTION id=\\\"18\\\" type=\\\"3\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"17\\\"/><DIV id=\\\"3\\\" type=\\\"28\\\" width=\\\"99.84\\\" height=\\\"20\\\" position=\\\"absolute\\\"/><DIV id=\\\"4\\\" type=\\\"29\\\" width=\\\"99.84\\\" height=\\\"60\\\" position=\\\"absolute\\\"/><DIV id=\\\"5\\\" type=\\\"38\\\" width=\\\"1214\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"8,4,13\\\"/><DIV id=\\\"6\\\" type=\\\"39\\\" width=\\\"99.84\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"7\\\"/><DIV id=\\\"7\\\" type=\\\"30\\\" width=\\\"99.79\\\" height=\\\"101\\\" position=\\\"auto\\\" RMclass=\\\"8\\\"/><DIV id=\\\"8\\\" type=\\\"31\\\" width=\\\"99.84\\\" height=\\\"86\\\" position=\\\"auto\\\" text=\\\"Status of the telephone number\\\" displayAs=\\\"radio buttons\\\"/><DIV id=\\\"10\\\" type=\\\"1\\\" width=\\\"99.84\\\" height=\\\"9.35\\\" position=\\\"relative\\\"><SUBMIT id=\\\"14\\\" type=\\\"10\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Potrdi &gt;&gt;\\\" RMclass=\\\"8\\\"/><DIV id=\\\"17\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV><DIV id=\\\"20\\\" type=\\\"27\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Quota unsuccessful!\\\" RMclass=\\\"12\\\"/></DIV>\n\',type = \'1\',orderBy = \'8\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'6\',id_sup = \'0\',name = \'Appointment\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"1\\\" type=\\\"19\\\" width=\\\"99.79\\\" height=\\\"89\\\" position=\\\"auto\\\" text=\\\"Make appointment\\\"/><DIV id=\\\"2\\\" type=\\\"33\\\" width=\\\"99.79\\\" height=\\\"329\\\" position=\\\"auto\\\"/><SUBMIT id=\\\"3\\\" type=\\\"10\\\" width=\\\"99.79\\\" height=\\\"9.01\\\" position=\\\"relative\\\" text=\\\"Submit &gt;&gt;\\\"/><DIV id=\\\"4\\\" type=\\\"11\\\" width=\\\"99.84\\\" height=\\\"9.61\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><DIV id=\\\"5\\\" type=\\\"41\\\" width=\\\"99.84\\\" height=\\\"10.52\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV>\n\',type = \'0\',orderBy = \'7\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'9\',id_sup = \'0\',name = \'QuotaFull\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><INSTRUCTION id=\\\"1\\\" type=\\\"4\\\" width=\\\"20\\\" height=\\\"154\\\" position=\\\"absolute\\\"/><QUESTION id=\\\"2\\\" type=\\\"3\\\" width=\\\"20\\\" height=\\\"154\\\" position=\\\"absolute\\\"/><DIV id=\\\"5\\\" type=\\\"1\\\" width=\\\"99.79\\\" height=\\\"23.77\\\" position=\\\"relative\\\"><DIV id=\\\"9\\\" type=\\\"2\\\" width=\\\"50\\\" height=\\\"99.37\\\" position=\\\"relative\\\"><DIV id=\\\"13\\\" type=\\\"11\\\" width=\\\"99.58\\\" height=\\\"40\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><DIV id=\\\"14\\\" type=\\\"45\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Continue with other\\\"/></DIV><DIV id=\\\"10\\\" type=\\\"2\\\" width=\\\"54.47\\\" height=\\\"99.37\\\" position=\\\"relative\\\"><DIV id=\\\"15\\\" type=\\\"25\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Break interview and start new\\\" catiOnly=\\\"true\\\"/><DIV id=\\\"16\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Go to IDLE\\\" catiOnly=\\\"true\\\"/></DIV></DIV></DIV>\n\',type = \'0\',orderBy = \'9\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'8\',id_sup = \'0\',name = \'EndConfirm\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"14\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"80\\\" position=\\\"absolute\\\"><DIV id=\\\"66\\\" type=\\\"40\\\" width=\\\"37.07\\\" height=\\\"98.33\\\" position=\\\"relative\\\" text=\\\"cannot leave\\\"/><DIV id=\\\"67\\\" type=\\\"19\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"whatever you want\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"15\\\" type=\\\"1\\\" width=\\\"1214\\\" height=\\\"400\\\" position=\\\"auto\\\"><DIV id=\\\"17\\\" type=\\\"2\\\" width=\\\"100\\\" height=\\\"379\\\" position=\\\"absolute\\\"/><DIV id=\\\"18\\\" type=\\\"2\\\" width=\\\"82.70\\\" height=\\\"99.83\\\" position=\\\"relative\\\"><VARIABLE id=\\\"19\\\" type=\\\"7\\\" width=\\\"99.80\\\" height=\\\"12.27\\\" position=\\\"relative\\\"/><QUESTION id=\\\"20\\\" type=\\\"3\\\" width=\\\"99.80\\\" height=\\\"13.00\\\" position=\\\"relative\\\" RMclass=\\\"4,3\\\"/><ANSWER id=\\\"35\\\" type=\\\"6\\\" width=\\\"99.80\\\" height=\\\"248\\\" position=\\\"auto\\\"><DIV id=\\\"36\\\" type=\\\"1\\\" position=\\\"relative\\\" name=\\\"Legend row\\\" height=\\\"33.33\\\" subType=\\\"1\\\"><DIV id=\\\"37\\\" type=\\\"20\\\" width=\\\"33.40\\\" position=\\\"relative\\\" height=\\\"98.21\\\"/><DIV id=\\\"38\\\" type=\\\"21\\\" width=\\\"21.30\\\" position=\\\"relative\\\" height=\\\"98.21\\\"/><DIV id=\\\"39\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"40\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"41\\\" type=\\\"20\\\" width=\\\"33.33\\\" position=\\\"relative\\\"/><DIV id=\\\"48\\\" type=\\\"21\\\" width=\\\"173\\\" height=\\\"55\\\" position=\\\"absolute\\\" RMclass=\\\"4\\\"/><DIV id=\\\"49\\\" type=\\\"22\\\" width=\\\"315\\\" height=\\\"55\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"44\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"45\\\" type=\\\"20\\\" width=\\\"33.33\\\" position=\\\"relative\\\"/><DIV id=\\\"46\\\" type=\\\"21\\\" width=\\\"180\\\" position=\\\"absolute\\\" height=\\\"55\\\"/><DIV id=\\\"47\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"absolute\\\" RMclass=\\\"7,3\\\"/></DIV></ANSWER></DIV><DIV id=\\\"50\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV><DIV id=\\\"16\\\" type=\\\"1\\\" width=\\\"99.84\\\" height=\\\"10.00\\\" position=\\\"relative\\\"><DIV id=\\\"72\\\" type=\\\"43\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Start new\\\"/><DIV id=\\\"73\\\" type=\\\"44\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Go to idle\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'10\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'18\',id_sup = \'3\',name = \'TextBox\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\" RMclass=\\\"4\\\"><DIV id=\\\"44\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV>\n\',type = \'0\',orderBy = \'3\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'19\',id_sup = \'3\',name = \'TextArea\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"1\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"15\\\"/></DIV>\n\',type = \'0\',orderBy = \'4\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'20\',id_sup = \'0\',name = \'defaultPlugin\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"60\\\" position=\\\"absolute\\\"><INSTRUCTION id=\\\"101\\\" type=\\\"4\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"1\\\" width=\\\"953\\\" height=\\\"63\\\" position=\\\"auto\\\" RMclass=\\\"2,8\\\"><VARIABLE id=\\\"103\\\" type=\\\"19\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"absolute\\\" question_num=\\\"1\\\" RMclass=\\\"1\\\"/><QUESTION id=\\\"104\\\" type=\\\"3\\\" width=\\\"325\\\" height=\\\"42\\\" position=\\\"auto\\\" question_num=\\\"1\\\" RMclass=\\\"3\\\"/></DIV><DIV id=\\\"105\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"164\\\" position=\\\"auto\\\" RMclass=\\\"6,8\\\"><DIV id=\\\"111\\\" type=\\\"56\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\"/></DIV><DIV id=\\\"108\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"170\\\" position=\\\"auto\\\" RMclass=\\\"8\\\"><DIV id=\\\"109\\\" type=\\\"2\\\" width=\\\"75\\\" height=\\\"99.33\\\" position=\\\"absolute\\\"/><DIV id=\\\"110\\\" type=\\\"40\\\" width=\\\"243\\\" height=\\\"20\\\" position=\\\"auto\\\" text=\\\"Cannot leave the question\\\" question_num=\\\"1\\\" RMclass=\\\"11\\\"/><DIV id=\\\"112\\\" type=\\\"11\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\" text=\\\"&lt;&lt; Back\\\"/><SUBMIT id=\\\"113\\\" type=\\\"10\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\" text=\\\"Submit &gt;&gt;\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'4\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'1\',id_sup = \'0\',idLab = \'varname\',css = \'\',is_leaf = \'1\',orderBy = \'8\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'2\',id_sup = \'0\',idLab = \'headerTitel\',css = \'\',is_leaf = \'1\',orderBy = \'7\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'3\',id_sup = \'0\',idLab = \'question\',css = \'\',is_leaf = \'1\',orderBy = \'6\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'4\',id_sup = \'0\',idLab = \'instructionText\',css = \'\',is_leaf = \'1\',orderBy = \'5\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'5\',id_sup = \'0\',idLab = \'oddRow\',css = \'\',is_leaf = \'1\',orderBy = \'3\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'6\',id_sup = \'0\',idLab = \'answerContainer\',css = \'\',is_leaf = \'1\',orderBy = \'2\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'7\',id_sup = \'0\',idLab = \'evenRow\',css = \'\',is_leaf = \'1\',orderBy = \'4\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'8\',id_sup = \'0\',idLab = \'controlButtons\',css = \'\',is_leaf = \'1\',orderBy = \'1\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'9\',id_sup = \'0\',idLab = \'align-middle\',css = \'\',is_leaf = \'1\',orderBy = \'9\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'10\',id_sup = \'0\',idLab = \'align-center\',css = \'\',is_leaf = \'1\',orderBy = \'10\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'11\',id_sup = \'0\',idLab = \'leave-text\',css = \'\',is_leaf = \'1\',orderBy = \'11\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'14\',id_sup = \'0\',idLab = \'textBoxControl\',css = \'\',is_leaf = \'1\',orderBy = \'14\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'15\',id_sup = \'0\',idLab = \'textAreaControl\',css = \'\',is_leaf = \'1\',orderBy = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'1\',id_class = \'1\',id_property = \'84\',prop_value = \'white\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'17\',id_class = \'3\',id_property = \'82\',prop_value = \'15px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'3\',id_class = \'1\',id_property = \'10\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'4\',id_class = \'1\',id_property = \'88\',prop_value = \'center\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'5\',id_class = \'2\',id_property = \'51\',prop_value = \'30px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'6\',id_class = \'2\',id_property = \'84\',prop_value = \'black\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'18\',id_class = \'3\',id_property = \'1\',prop_value = \'24\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'8\',id_class = \'2\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'9\',id_class = \'2\',id_property = \'1\',prop_value = \'16px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'10\',id_class = \'2\',id_property = \'63\',prop_value = \'bold\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'11\',id_class = \'2\',id_property = \'26\',prop_value = \'solid\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'12\',id_class = \'2\',id_property = \'25\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'13\',id_class = \'2\',id_property = \'27\',prop_value = \'medium\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'16\',id_class = \'1\',id_property = \'86\',prop_value = \'2\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'15\',id_class = \'2\',id_property = \'79\',prop_value = \'20px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'19\',id_class = \'1\',id_property = \'63\',prop_value = \'bolder\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'20\',id_class = \'4\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'21\',id_class = \'4\',id_property = \'1\',prop_value = \'20\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'22\',id_class = \'4\',id_property = \'10\',prop_value = \'#eaeaea\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'23\',id_class = \'4\',id_property = \'83\',prop_value = \'5\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'24\',id_class = \'5\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'28\',id_class = \'5\',id_property = \'1\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'27\',id_class = \'1\',id_property = \'54\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'26\',id_class = \'6\',id_property = \'82\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'29\',id_class = \'7\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'30\',id_class = \'7\',id_property = \'1\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'32\',id_class = \'8\',id_property = \'79\',prop_value = \'20\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'33\',id_class = \'8\',id_property = \'19\',prop_value = \'thin\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'34\',id_class = \'8\',id_property = \'17\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'35\',id_class = \'8\',id_property = \'18\',prop_value = \'solid\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'37\',id_class = \'6\',id_property = \'81\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'38\',id_class = \'6\',id_property = \'79\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'39\',id_class = \'4\',id_property = \'49\',prop_value = \'middle\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'40\',id_class = \'5\',id_property = \'10\',prop_value = \'#eaeaea\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'41\',id_class = \'6\',id_property = \'80\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'42\',id_class = \'9\',id_property = \'88\',prop_value = \'center\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'43\',id_class = \'11\',id_property = \'63\',prop_value = \'bold\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'44\',id_class = \'11\',id_property = \'84\',prop_value = \'red\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'45\',id_class = \'3\',id_property = \'88\',prop_value = \'left\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'52\',id_class = \'14\',id_property = \'54\',prop_value = \'300\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'54\',id_class = \'15\',id_property = \'51\',prop_value = \'80\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'55\',id_class = \'15\',id_property = \'54\',prop_value = \'250\';','UPDATE WEB questionnaire styles: firstProject','2015-12-16 11:49:47',''),(7,'1',2,11,'table_warpit_webcati_base','\r\n<stat>REPLACE INTO _Projects SET id = \'2\',key_proj = \'2-aa3yqr9eix\',proj_name = \'firstProject\',language = \'46\',naziv_proj = \'test tole\',old = \'N\',created = \'16.12.2015 - 11:20\',creat_name = \'Administrator \',modify = \'16.12.2015 - 11:20\',modi_name = \'Administrator \',active = \'1\',start_date = \'2015-12-16 00:00:00\',end_date = \'2016-12-16 00:00:00\',print_filter = \'1\',print_jump = \'1\',print_condition = \'1\',print_answfilter = \'1\',stat_show_var = \'0\',stat_show_val = \'0\',lock_app_to_user = \'1\',rotation = \'N\',regionopt = \'\',hide_back_button = \'0\',id_telname = \'\',tel_reserve = \'0\',id_capiTable = \'0\',capi_reserve = \'0\',qt_useregtel = \'0\',qt_useactel = \'0\',reg_strictlock = \'0\',stat_show_scaleborder = \'0\',busy_call_delay = \'20\',noanswer_call_delay = \'120\',callback_call_delay = \'5\',num_max_call = \'3\',num_max_call_app = \'99\',back_delete = \'1\',set_use_autodial = \'0\',quota_vars = \'\',telselect = \'0\',proj_backup = \'\',strictlock_manual = \'0\',ml_showopt_www = \'1\',ml_position_www = \'2\',ml_html_www = \'\',forward_button_link = \'\',back_button_link = \'\',exit_button_link = \'\',help_button_link = \'\',quest_distance_buttons = \'\',submit_where = \'0\',submit_auto = \'0\',question_over = \'0\',user_status_bar = \'\',radio_button_enable = \'\',radio_button_disable = \'\',chk_button_enable = \'\',chk_button_disable = \'\',use_img_radio = \'0\',submit_delay_press = \'1\',exit_alert_msg = \'Are you sure?\',forward_button_disable_link = \'\',back_button_disable_link = \'\',error_img_scale = \'\',start_quest_button_link = \'\',quest_start_alert_msg = \'Are you sure?\',intstat_opt = \'\',webcapi_clear_all = \'0\',webcapi_clear_finished = \'0\',webcapi_finished = \'0\',use_special_sampling = \'0\',wh_special_sampling = \'\',disablebasic = \'0\',call_time_length = \'25\',use_predictive = \'0\',predictive_work = \'0\',predictive_numbers_tofind = \'0\',predictive_overcall = \'0\',isTemplate = \'0\',id_select_layer = \'0\',redirectActive = \'0\',redirectConditions = \'\',interview_show_variable = \'1\',interview_show_ans_value = \'1\',has_user_quotas = \'0\',respondent_searched_fields = \'\',telnum_select_type = \'1\',use_lowest = \'0\',use_lowest_layer = \'\',is_nfield = \'0\',id_nfield_project = \'\',name_nfield_project = \'\',stat_show_filter_in = \'0\',stat_show_filter_out = \'0\',stat_show_goto = \'0\',stat_show_answer_filter = \'0\',stat_show_question_type = \'0\',stat_show_open_end_type = \'0\',limit_interviews = \'0\',number_of_interviews = \'0\',check_for_quota = \'1\';\r\n<stat>REPLACE INTO _ProjectsTree SET id = \'2\',id_sup = \'0\',id_project = \'2\',orderBy = \'1\',idLab = \'firstProject\',node_img = \'\',is_leaf = \'1\',merged = \'0\';\r\n<stat>DELETE FROM  _LanguageProjects WHERE id_project = 2;\r\n<stat>DELETE FROM  _LanguageUserInterface WHERE id_project IN (0, 2);\r\n<stat>DELETE FROM  _QuestionRotation WHERE id_project = 2;\r\n<stat>DELETE FROM  _ProjectExtraVariables  WHERE id_project = 2;\r\n<stat>INSERT INTO _LanguageProjects  SET id_language = \'46\',id_project = \'2\';','UPDATE _Projects table for: firstProject','2015-12-16 11:50:01',''),(8,'1',2,12,'table_warpit_webcati','\r\n<stat>DROP TABLE IF EXISTS firstProject; \r\n<stat>DROP TABLE IF EXISTS firstProject_language; \r\n<stat>DROP TABLE IF EXISTS firstProject_script; \r\n<stat>DROP TABLE IF EXISTS firstProject_tree; \r\n<stat>CREATE TABLE `firstProject` (\n  `id` int(5) NOT NULL AUTO_INCREMENT,\n  `q_pos` int(5) NOT NULL,\n  `q_name` char(20) COLLATE utf8_unicode_ci NOT NULL,\n  `tip_sql` int(2) DEFAULT NULL,\n  `drg_sql` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `les_sql` int(2) DEFAULT NULL,\n  `goto_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `fil_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `con_sql` text COLLATE utf8_unicode_ci NOT NULL,\n  `open_sql` int(2) DEFAULT NULL,\n  `anno_sql` int(2) DEFAULT NULL,\n  `attachAnswers` int(11) DEFAULT NULL,\n  `attachFalse` tinyint(1) DEFAULT NULL,\n  `rot_sql` text COLLATE utf8_unicode_ci,\n  `srot_sql` int(1) DEFAULT NULL,\n  `erot_sql` int(1) DEFAULT NULL,\n  `srotLegend` int(1) DEFAULT NULL,\n  `erotLegend` int(1) DEFAULT NULL,\n  `srotAttributes` int(1) DEFAULT NULL,\n  `erotAttributes` int(1) DEFAULT NULL,\n  `qrot_sql` char(9) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `id_style` int(8) DEFAULT NULL,\n  `id_mask` int(8) DEFAULT NULL,\n  `must_answer` tinyint(1) NOT NULL DEFAULT \'1\',\n  `disable_question` tinyint(1) NOT NULL DEFAULT \'0\',\n  `answers_filter` tinyint(1) NOT NULL DEFAULT \'0\',\n  `variableTypeBase` tinyint(1) NOT NULL DEFAULT \'4\',\n  `variableTypeOpen` tinyint(1) NOT NULL DEFAULT \'0\',\n  `open_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `open_legend` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `open_attributes` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multi_nogo_answers` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multi_nogo_legends` char(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `multilanguage_all` text COLLATE utf8_unicode_ci,\n  `qleave_js_alert` tinyint(1) NOT NULL DEFAULT \'0\',\n  `filter_answer` text COLLATE utf8_unicode_ci,\n  `filter_legend` text COLLATE utf8_unicode_ci,\n  `filter_attributes` text COLLATE utf8_unicode_ci,\n  `hasStructure` tinyint(4) DEFAULT \'0\',\n  `use_for_quotas` tinyint(1) DEFAULT \'0\',\n  `isFinal` tinyint(1) DEFAULT \'0\',\n  `id_showTogether` int(11) NOT NULL DEFAULT \'0\',\n  `answerGroups` text COLLATE utf8_unicode_ci,\n  `legendGroups` text COLLATE utf8_unicode_ci,\n  `id_plugin` int(11) DEFAULT NULL,\n  `id_incentive` int(11) DEFAULT NULL,\n  `incentive_possibilites` tinyint(1) NOT NULL DEFAULT \'0\',\n  `allow_listening` tinyint(1) NOT NULL DEFAULT \'0\',\n  `old_id` int(11) NOT NULL,\n  `up_down_rotchk` int(11) NOT NULL,\n  `up_down_rotvar` int(11) NOT NULL,\n  `repeat_legend` int(11) NOT NULL,\n  `autoSubmit` tinyint(1) NOT NULL DEFAULT \'0\',\n  `missing_values` char(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `q_name` (`q_name`),\n  KEY `q_pos` (`q_pos`),\n  KEY `tip_sql` (`tip_sql`)\n) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_language` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `id_language` int(11) NOT NULL,\n  `id_question` int(11) NOT NULL,\n  `id_text_type` int(11) NOT NULL,\n  `lngText` text COLLATE utf8_unicode_ci NOT NULL,\n  PRIMARY KEY (`id`),\n  UNIQUE KEY `qlt_index` (`id_language`,`id_question`,`id_text_type`),\n  KEY `id_question` (`id_question`)\n) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_script` (\n  `id_question` int(11) NOT NULL,\n  `id_event` int(11) NOT NULL,\n  `script` text COLLATE utf8_unicode_ci NOT NULL,\n  PRIMARY KEY (`id_question`,`id_event`)\n) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; \r\n<stat>CREATE TABLE `firstProject_tree` (\n  `id` int(3) NOT NULL AUTO_INCREMENT,\n  `id_sup` int(5) NOT NULL,\n  `id_question` int(5) NOT NULL,\n  `orderBy` smallint(6) NOT NULL,\n  `idLab` varchar(100) COLLATE utf8_unicode_ci NOT NULL,\n  `node_img` varchar(100) COLLATE utf8_unicode_ci NOT NULL,\n  `is_leaf` tinyint(1) NOT NULL,\n  `showTogether` tinyint(1) NOT NULL,\n  PRIMARY KEY (`id`),\n  KEY `id_sup` (`id_sup`),\n  KEY `id_question` (`id_question`),\n  KEY `orderBy` (`orderBy`)\n) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\r\n<stat>INSERT INTO firstProject SET id = \'1\',q_pos = \'-6\',q_name = \'_Start\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'true#1\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'2\',q_pos = \'-5\',q_name = \'_End\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'3\',q_pos = \'-15\',q_name = \'_notAllow\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'4\',q_pos = \'-16\',q_name = \'_notActive\',tip_sql = \'5\',drg_sql = \'\',les_sql = \'\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'1\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject SET id = \'5\',q_pos = \'1\',q_name = \'q1\',tip_sql = \'1\',drg_sql = \'\',les_sql = \'1\',goto_sql = \'\',fil_sql = \'\',con_sql = \'\',open_sql = \'1\',anno_sql = \'\',attachAnswers = \'\',attachFalse = \'\',rot_sql = \'\',srot_sql = \'\',erot_sql = \'\',srotLegend = \'\',erotLegend = \'\',srotAttributes = \'\',erotAttributes = \'\',qrot_sql = \'\',id_style = \'\',id_mask = \'\',must_answer = \'1\',disable_question = \'0\',answers_filter = \'0\',variableTypeBase = \'4\',variableTypeOpen = \'0\',open_answers = \'\',open_legend = \'\',open_attributes = \'\',multi_nogo_answers = \'\',multi_nogo_legends = \'\',multilanguage_all = \'\',qleave_js_alert = \'0\',filter_answer = \'\',filter_legend = \'\',filter_attributes = \'\',hasStructure = \'0\',use_for_quotas = \'0\',isFinal = \'0\',id_showTogether = \'0\',answerGroups = \'\',legendGroups = \'\',id_plugin = \'\',id_incentive = \'\',incentive_possibilites = \'0\',allow_listening = \'0\',old_id = \'0\',up_down_rotchk = \'0\',up_down_rotvar = \'0\',repeat_legend = \'0\',autoSubmit = \'0\',missing_values = \'\';\r\n<stat>INSERT INTO firstProject_language SET id = \'1\',id_language = \'46\',id_question = \'4\',id_text_type = \'2\',lngText = \'This survey is not active!\';\r\n<stat>INSERT INTO firstProject_language SET id = \'2\',id_language = \'46\',id_question = \'3\',id_text_type = \'2\',lngText = \'Thank you for participating in this survey!\';\r\n<stat>INSERT INTO firstProject_language SET id = \'3\',id_language = \'46\',id_question = \'2\',id_text_type = \'2\',lngText = \'Questionnaire finished\';\r\n<stat>INSERT INTO firstProject_language SET id = \'4\',id_language = \'46\',id_question = \'1\',id_text_type = \'2\',lngText = \'Welcome text\';\r\n<stat>INSERT INTO firstProject_language SET id = \'5\',id_language = \'46\',id_question = \'5\',id_text_type = \'2\',lngText = \'tole testiram\';\r\n<stat>INSERT INTO firstProject_language SET id = \'6\',id_language = \'46\',id_question = \'5\',id_text_type = \'3\',lngText = \'1 test1/2 test2\';\r\n<stat>INSERT INTO firstProject_tree SET id = \'5\',id_sup = \'0\',id_question = \'5\',orderBy = \'1\',idLab = \'q1\',node_img = \'\',is_leaf = \'1\',showTogether = \'0\';','CREATE questionnaire: firstProject','2015-12-16 11:50:01',''),(9,'1',2,3,'table_warpit_webcati_base','\r\n<stat>#BACKUP firstProject_structure ;\r\n<stat>DROP TABLE IF EXISTS firstProject_structure;\r\n<stat>DROP TABLE IF EXISTS firstProject___EngineLog;\r\n<stat>DELETE FROM  _www_interviewer_statistics WHERE id_project = 2;\r\n<stat>CREATE TABLE `firstProject_structure` (\n  `id` int(7) NOT NULL AUTO_INCREMENT,\n  `id_clien` int(5) DEFAULT NULL,\n  `flag_cli` int(1) DEFAULT NULL,\n  `user_id` int(5) DEFAULT NULL,\n  `user_type` tinyint(4) DEFAULT NULL,\n  `id_loginSID` int(11) DEFAULT NULL,\n  `id_device` tinyint(4) DEFAULT NULL,\n  `id_language` tinyint(3) unsigned DEFAULT NULL,\n  `smpl_var` int(1) DEFAULT NULL,\n  `sp_adult` int(1) DEFAULT NULL,\n  `sp_man` int(1) DEFAULT NULL,\n  `id_site` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,\n  `status` int(8) DEFAULT NULL,\n  `status_rec` int(8) DEFAULT NULL,\n  `flag_bad` int(3) NOT NULL DEFAULT \'99\',\n  `t_status` int(11) unsigned DEFAULT NULL,\n  `t_start` int(11) unsigned DEFAULT NULL,\n  `t_stop` int(11) unsigned DEFAULT NULL,\n  `d_status` datetime DEFAULT NULL,\n  `d_start` datetime DEFAULT NULL,\n  `d_stop` datetime DEFAULT NULL,\n  `t_pause` int(11) NOT NULL DEFAULT \'0\',\n  `t_diffs` int(10) NOT NULL DEFAULT \'0\',\n  `QT_user_id` int(5) DEFAULT NULL,\n  `q1` int(10) DEFAULT NULL,\n  PRIMARY KEY (`id`),\n  KEY `user_id_type` (`user_id`,`user_type`),\n  KEY `status` (`status`,`status_rec`),\n  KEY `id_device` (`id_device`),\n  KEY `id_language` (`id_language`),\n  KEY `flag_bad` (`flag_bad`),\n  KEY `id_site` (`id_site`(5)),\n  KEY `id_loginSID` (`id_loginSID`),\n  KEY `sp_man` (`sp_man`)\n) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\r\n<stat>CREATE TABLE `firstProject___EngineLog` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `id_structure` int(11) NOT NULL,\n  `id_question` smallint(6) NOT NULL,\n  `id_user` int(11) NOT NULL,\n  `user_type` tinyint(4) NOT NULL,\n  `id_language` smallint(6) DEFAULT NULL,\n  `q_name` varchar(25) COLLATE utf8_unicode_ci NOT NULL,\n  `currentRotationString` text COLLATE utf8_unicode_ci NOT NULL,\n  `questionnairePath` text COLLATE utf8_unicode_ci NOT NULL,\n  `engineTime` int(11) NOT NULL,\n  `questStart` int(11) DEFAULT NULL,\n  `questEnd` int(11) DEFAULT NULL,\n  `arriveStatus` tinyint(4) DEFAULT NULL,\n  `eventLogger` text COLLATE utf8_unicode_ci,\n  PRIMARY KEY (`id`),\n  KEY `id_structure` (`id_structure`)\n) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;','CREATE structure table: firstProject','2015-12-16 11:50:01',''),(10,'1',2,5,'table_warpit_webcati_base','\r\n<stat>INSERT IGNORE INTO `_www_ids` (`id`, `id_user`, `user_type`, `id_project`, `id_site`, `loginSID`, `idGenStruc`) VALUES (null, 0, 3, -2, 0, \'7e432d983351982\', 0);\r\n<stat>DELETE FROM _www_ids WHERE id_user>0 AND user_type=0 AND id_project=2 AND id_site=0 AND id_user NOT IN (SELECT * FROM (SELECT id_user FROM `_www_ids` WHERE id_user>0 AND user_type=0 AND id_site=0 AND id_project=-2) AS p );\r\n<stat>UPDATE IGNORE `_www_ids` SET `id_project`=ABS(`id_project`), `loginSID` = CONCAT(`loginSID`,\'-\',`id`) WHERE `id_project`<0;\r\n<stat>DELETE FROM `_www_ids` WHERE `id_project`<0;','UPDATE Questionnaire aprooved users: firstProject','2015-12-16 11:50:01',''),(12,'1',2,7,'table_warpit_webcati_base','\r\n<stat>TRUNCATE TABLE _DesignerTemplates;\r\n<stat>TRUNCATE TABLE _DesignerCss;\r\n<stat>TRUNCATE TABLE _DesignerClsPropLink;\r\n<stat>DELETE FROM _DesignerManager WHERE id_project = 2;\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'1\',id_sup = \'0\',name = \'Default\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"100\\\" position=\\\"relative\\\"><DIV id=\\\"101\\\" type=\\\"2\\\" width=\\\"30\\\" height=\\\"20\\\" position=\\\"relative\\\"><VARIABLE id=\\\"115\\\" type=\\\"7\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\"/><DIV id=\\\"116\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"2\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"9\\\"><TEMPLATE id=\\\"105\\\" type=\\\"47\\\" width=\\\"20\\\" height=\\\"161\\\" position=\\\"auto\\\" id_template=\\\"2\\\" question_num_1=\\\"1\\\"/><DIV id=\\\"106\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"107\\\" type=\\\"19\\\" width=\\\"75\\\" height=\\\"20\\\" position=\\\"absolute\\\"/><DIV id=\\\"108\\\" type=\\\"11\\\" width=\\\"80\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><SUBMIT id=\\\"109\\\" type=\\\"10\\\" width=\\\"100\\\" height=\\\"20\\\" position=\\\"absolute\\\" text=\\\"Submit &gt;&gt;\\\"/><DIV id=\\\"110\\\" type=\\\"19\\\" width=\\\"75\\\" height=\\\"20\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"111\\\" type=\\\"25\\\" width=\\\"99.73\\\" height=\\\"6.78\\\" position=\\\"relative\\\" text=\\\"Break interview\\\" catiOnly=\\\"true\\\"/><DIV id=\\\"114\\\" type=\\\"41\\\" width=\\\"99.71\\\" height=\\\"7.13\\\" position=\\\"relative\\\" text=\\\"Go to IDLE\\\" catiOnly=\\\"true\\\"/></DIV><DIV id=\\\"103\\\" type=\\\"2\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"2,3\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'1\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'13\',id_sup = \'0\',name = \'end-template\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"100\\\" position=\\\"relative\\\"><DIV id=\\\"101\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/><DIV id=\\\"102\\\" type=\\\"2\\\" width=\\\"900\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"9\\\"><IMAGE id=\\\"104\\\" type=\\\"8\\\" width=\\\"99.78\\\" height=\\\"150\\\" position=\\\"absolute\\\" src=\\\"http://capi.rmplus.si/WEB_projects/ipsos/logo.gif\\\" RMclass=\\\"9\\\"/><TEMPLATE id=\\\"105\\\" type=\\\"47\\\" width=\\\"20\\\" height=\\\"161\\\" position=\\\"auto\\\" id_template=\\\"2\\\" question_num_1=\\\"1\\\"/></DIV><DIV id=\\\"103\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'2\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'2\',id_sup = \'0\',name = \'defaultBase\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"60\\\" position=\\\"absolute\\\"><INSTRUCTION id=\\\"101\\\" type=\\\"4\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"1\\\" width=\\\"953\\\" height=\\\"63\\\" position=\\\"auto\\\" RMclass=\\\"2\\\"><VARIABLE id=\\\"103\\\" type=\\\"19\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"absolute\\\" question_num=\\\"1\\\" RMclass=\\\"1\\\"/><QUESTION id=\\\"104\\\" type=\\\"3\\\" width=\\\"325\\\" height=\\\"42\\\" position=\\\"auto\\\" question_num=\\\"1\\\" RMclass=\\\"3\\\"/></DIV><DIV id=\\\"105\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"164\\\" position=\\\"auto\\\" RMclass=\\\"6\\\"><ANSWER id=\\\"106\\\" type=\\\"6\\\" width=\\\"191\\\" height=\\\"20\\\" position=\\\"auto\\\" question_num=\\\"1\\\"/></DIV><DIV id=\\\"108\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"170\\\" position=\\\"auto\\\"><DIV id=\\\"109\\\" type=\\\"2\\\" width=\\\"75\\\" height=\\\"99.33\\\" position=\\\"absolute\\\"/><DIV id=\\\"110\\\" type=\\\"40\\\" width=\\\"243\\\" height=\\\"20\\\" position=\\\"auto\\\" text=\\\"Cannot leave the question\\\" question_num=\\\"1\\\" RMclass=\\\"11\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'3\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'3\',id_sup = \'0\',name = \'Answers\',template_xml = \'\',type = \'0\',orderBy = \'5\',is_leaf = \'0\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'10\',id_sup = \'3\',name = \'Basic\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><ANSWER id=\\\"14\\\" type=\\\"6\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"19\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"22\\\" type=\\\"22\\\" width=\\\"30\\\" position=\\\"absolute\\\" height=\\\"22\\\" RMclass=\\\"5\\\"/><DIV id=\\\"35\\\" type=\\\"21\\\" width=\\\"190\\\" height=\\\"20\\\" position=\\\"auto\\\" RMclass=\\\"5\\\"/></DIV><DIV id=\\\"23\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"30\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/><DIV id=\\\"36\\\" type=\\\"21\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/></DIV></ANSWER></DIV>\n\',type = \'0\',orderBy = \'1\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'11\',id_sup = \'3\',name = \'Scale\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><ANSWER id=\\\"30\\\" type=\\\"6\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"><DIV id=\\\"31\\\" type=\\\"1\\\" position=\\\"relative\\\" name=\\\"Legend row\\\" height=\\\"33.33\\\" subType=\\\"1\\\"><DIV id=\\\"33\\\" type=\\\"21\\\" width=\\\"485\\\" position=\\\"auto\\\"/><DIV id=\\\"34\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"relative\\\" RMclass=\\\"9\\\"/></DIV><DIV id=\\\"35\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"37\\\" type=\\\"21\\\" width=\\\"33.33\\\" position=\\\"relative\\\" RMclass=\\\"5\\\"/><DIV id=\\\"38\\\" type=\\\"22\\\" width=\\\"404\\\" position=\\\"auto\\\" RMclass=\\\"5,9\\\"/></DIV><DIV id=\\\"39\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"41\\\" type=\\\"21\\\" width=\\\"33.33\\\" position=\\\"relative\\\" RMclass=\\\"7\\\"/><DIV id=\\\"42\\\" type=\\\"22\\\" width=\\\"404\\\" position=\\\"auto\\\" RMclass=\\\"7,9\\\"/></DIV></ANSWER></DIV>\n\',type = \'0\',orderBy = \'2\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'4\',id_sup = \'0\',name = \'predictive dailer\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"2\\\" type=\\\"35\\\" width=\\\"99.79\\\" height=\\\"50\\\" position=\\\"absolute\\\"/><DIV id=\\\"4\\\" type=\\\"30\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/><DIV id=\\\"5\\\" type=\\\"39\\\" width=\\\"99.79\\\" height=\\\"7.08\\\" position=\\\"relative\\\"/><DIV id=\\\"6\\\" type=\\\"38\\\" width=\\\"99.79\\\" height=\\\"6.68\\\" position=\\\"relative\\\"/><DIV id=\\\"7\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV>\n\',type = \'1\',orderBy = \'6\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'5\',id_sup = \'0\',name = \'Status\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><QUESTION id=\\\"18\\\" type=\\\"3\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"17\\\"/><DIV id=\\\"3\\\" type=\\\"28\\\" width=\\\"99.84\\\" height=\\\"20\\\" position=\\\"absolute\\\"/><DIV id=\\\"4\\\" type=\\\"29\\\" width=\\\"99.84\\\" height=\\\"60\\\" position=\\\"absolute\\\"/><DIV id=\\\"5\\\" type=\\\"38\\\" width=\\\"1214\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"8,4,13\\\"/><DIV id=\\\"6\\\" type=\\\"39\\\" width=\\\"99.84\\\" height=\\\"20\\\" position=\\\"absolute\\\" RMclass=\\\"7\\\"/><DIV id=\\\"7\\\" type=\\\"30\\\" width=\\\"99.79\\\" height=\\\"101\\\" position=\\\"auto\\\" RMclass=\\\"8\\\"/><DIV id=\\\"8\\\" type=\\\"31\\\" width=\\\"99.84\\\" height=\\\"86\\\" position=\\\"auto\\\" text=\\\"Status of the telephone number\\\" displayAs=\\\"radio buttons\\\"/><DIV id=\\\"10\\\" type=\\\"1\\\" width=\\\"99.84\\\" height=\\\"9.35\\\" position=\\\"relative\\\"><SUBMIT id=\\\"14\\\" type=\\\"10\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Potrdi &gt;&gt;\\\" RMclass=\\\"8\\\"/><DIV id=\\\"17\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV><DIV id=\\\"20\\\" type=\\\"27\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Quota unsuccessful!\\\" RMclass=\\\"12\\\"/></DIV>\n\',type = \'1\',orderBy = \'8\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'6\',id_sup = \'0\',name = \'Appointment\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"1\\\" type=\\\"19\\\" width=\\\"99.79\\\" height=\\\"89\\\" position=\\\"auto\\\" text=\\\"Make appointment\\\"/><DIV id=\\\"2\\\" type=\\\"33\\\" width=\\\"99.79\\\" height=\\\"329\\\" position=\\\"auto\\\"/><SUBMIT id=\\\"3\\\" type=\\\"10\\\" width=\\\"99.79\\\" height=\\\"9.01\\\" position=\\\"relative\\\" text=\\\"Submit &gt;&gt;\\\"/><DIV id=\\\"4\\\" type=\\\"11\\\" width=\\\"99.84\\\" height=\\\"9.61\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><DIV id=\\\"5\\\" type=\\\"41\\\" width=\\\"99.84\\\" height=\\\"10.52\\\" position=\\\"relative\\\" text=\\\"Goto IDLE\\\"/></DIV>\n\',type = \'0\',orderBy = \'7\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'9\',id_sup = \'0\',name = \'QuotaFull\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><INSTRUCTION id=\\\"1\\\" type=\\\"4\\\" width=\\\"20\\\" height=\\\"154\\\" position=\\\"absolute\\\"/><QUESTION id=\\\"2\\\" type=\\\"3\\\" width=\\\"20\\\" height=\\\"154\\\" position=\\\"absolute\\\"/><DIV id=\\\"5\\\" type=\\\"1\\\" width=\\\"99.79\\\" height=\\\"23.77\\\" position=\\\"relative\\\"><DIV id=\\\"9\\\" type=\\\"2\\\" width=\\\"50\\\" height=\\\"99.37\\\" position=\\\"relative\\\"><DIV id=\\\"13\\\" type=\\\"11\\\" width=\\\"99.58\\\" height=\\\"40\\\" position=\\\"relative\\\" text=\\\"&lt;&lt; Back\\\"/><DIV id=\\\"14\\\" type=\\\"45\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Continue with other\\\"/></DIV><DIV id=\\\"10\\\" type=\\\"2\\\" width=\\\"54.47\\\" height=\\\"99.37\\\" position=\\\"relative\\\"><DIV id=\\\"15\\\" type=\\\"25\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Break interview and start new\\\" catiOnly=\\\"true\\\"/><DIV id=\\\"16\\\" type=\\\"41\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Go to IDLE\\\" catiOnly=\\\"true\\\"/></DIV></DIV></DIV>\n\',type = \'0\',orderBy = \'9\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'8\',id_sup = \'0\',name = \'EndConfirm\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"14\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"80\\\" position=\\\"absolute\\\"><DIV id=\\\"66\\\" type=\\\"40\\\" width=\\\"37.07\\\" height=\\\"98.33\\\" position=\\\"relative\\\" text=\\\"cannot leave\\\"/><DIV id=\\\"67\\\" type=\\\"19\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"whatever you want\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"15\\\" type=\\\"1\\\" width=\\\"1214\\\" height=\\\"400\\\" position=\\\"auto\\\"><DIV id=\\\"17\\\" type=\\\"2\\\" width=\\\"100\\\" height=\\\"379\\\" position=\\\"absolute\\\"/><DIV id=\\\"18\\\" type=\\\"2\\\" width=\\\"82.70\\\" height=\\\"99.83\\\" position=\\\"relative\\\"><VARIABLE id=\\\"19\\\" type=\\\"7\\\" width=\\\"99.80\\\" height=\\\"12.27\\\" position=\\\"relative\\\"/><QUESTION id=\\\"20\\\" type=\\\"3\\\" width=\\\"99.80\\\" height=\\\"13.00\\\" position=\\\"relative\\\" RMclass=\\\"4,3\\\"/><ANSWER id=\\\"35\\\" type=\\\"6\\\" width=\\\"99.80\\\" height=\\\"248\\\" position=\\\"auto\\\"><DIV id=\\\"36\\\" type=\\\"1\\\" position=\\\"relative\\\" name=\\\"Legend row\\\" height=\\\"33.33\\\" subType=\\\"1\\\"><DIV id=\\\"37\\\" type=\\\"20\\\" width=\\\"33.40\\\" position=\\\"relative\\\" height=\\\"98.21\\\"/><DIV id=\\\"38\\\" type=\\\"21\\\" width=\\\"21.30\\\" position=\\\"relative\\\" height=\\\"98.21\\\"/><DIV id=\\\"39\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"40\\\" type=\\\"1\\\" name=\\\"Odd rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"2\\\"><DIV id=\\\"41\\\" type=\\\"20\\\" width=\\\"33.33\\\" position=\\\"relative\\\"/><DIV id=\\\"48\\\" type=\\\"21\\\" width=\\\"173\\\" height=\\\"55\\\" position=\\\"absolute\\\" RMclass=\\\"4\\\"/><DIV id=\\\"49\\\" type=\\\"22\\\" width=\\\"315\\\" height=\\\"55\\\" position=\\\"absolute\\\"/></DIV><DIV id=\\\"44\\\" type=\\\"1\\\" name=\\\"Even rows\\\" height=\\\"33.33\\\" position=\\\"relative\\\" subType=\\\"3\\\"><DIV id=\\\"45\\\" type=\\\"20\\\" width=\\\"33.33\\\" position=\\\"relative\\\"/><DIV id=\\\"46\\\" type=\\\"21\\\" width=\\\"180\\\" position=\\\"absolute\\\" height=\\\"55\\\"/><DIV id=\\\"47\\\" type=\\\"22\\\" width=\\\"50\\\" position=\\\"absolute\\\" RMclass=\\\"7,3\\\"/></DIV></ANSWER></DIV><DIV id=\\\"50\\\" type=\\\"2\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV><DIV id=\\\"16\\\" type=\\\"1\\\" width=\\\"99.84\\\" height=\\\"10.00\\\" position=\\\"relative\\\"><DIV id=\\\"72\\\" type=\\\"43\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Start new\\\"/><DIV id=\\\"73\\\" type=\\\"44\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" text=\\\"Go to idle\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'10\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'18\',id_sup = \'3\',name = \'TextBox\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\" RMclass=\\\"4\\\"><DIV id=\\\"44\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\"/></DIV>\n\',type = \'0\',orderBy = \'3\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'19\',id_sup = \'3\',name = \'TextArea\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"1\\\" type=\\\"22\\\" width=\\\"20\\\" height=\\\"20\\\" position=\\\"relative\\\" RMclass=\\\"15\\\"/></DIV>\n\',type = \'0\',orderBy = \'4\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerTemplates SET id = \'20\',id_sup = \'0\',name = \'defaultPlugin\',template_xml = \'<?xml version=\\\"1.0\\\"?>\n<DIV id=\\\"0\\\"><DIV id=\\\"100\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"60\\\" position=\\\"absolute\\\"><INSTRUCTION id=\\\"101\\\" type=\\\"4\\\" width=\\\"50\\\" height=\\\"20\\\" position=\\\"relative\\\" question_num=\\\"1\\\" RMclass=\\\"4\\\"/></DIV><DIV id=\\\"102\\\" type=\\\"1\\\" width=\\\"953\\\" height=\\\"63\\\" position=\\\"auto\\\" RMclass=\\\"2,8\\\"><VARIABLE id=\\\"103\\\" type=\\\"19\\\" width=\\\"60\\\" height=\\\"20\\\" position=\\\"absolute\\\" question_num=\\\"1\\\" RMclass=\\\"1\\\"/><QUESTION id=\\\"104\\\" type=\\\"3\\\" width=\\\"325\\\" height=\\\"42\\\" position=\\\"auto\\\" question_num=\\\"1\\\" RMclass=\\\"3\\\"/></DIV><DIV id=\\\"105\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"164\\\" position=\\\"auto\\\" RMclass=\\\"6,8\\\"><DIV id=\\\"111\\\" type=\\\"56\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\"/></DIV><DIV id=\\\"108\\\" type=\\\"1\\\" width=\\\"20\\\" height=\\\"170\\\" position=\\\"auto\\\" RMclass=\\\"8\\\"><DIV id=\\\"109\\\" type=\\\"2\\\" width=\\\"75\\\" height=\\\"99.33\\\" position=\\\"absolute\\\"/><DIV id=\\\"110\\\" type=\\\"40\\\" width=\\\"243\\\" height=\\\"20\\\" position=\\\"auto\\\" text=\\\"Cannot leave the question\\\" question_num=\\\"1\\\" RMclass=\\\"11\\\"/><DIV id=\\\"112\\\" type=\\\"11\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\" text=\\\"&lt;&lt; Back\\\"/><SUBMIT id=\\\"113\\\" type=\\\"10\\\" width=\\\"100\\\" height=\\\"100\\\" position=\\\"auto\\\" text=\\\"Submit &gt;&gt;\\\"/></DIV></DIV>\n\',type = \'0\',orderBy = \'4\',is_leaf = \'1\',body_properties = \'\',custom_checkbox_enable = \'0\',custom_radio_enable = \'0\',checkbox_images = \'\',radio_images = \'\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'1\',id_sup = \'0\',idLab = \'varname\',css = \'\',is_leaf = \'1\',orderBy = \'8\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'2\',id_sup = \'0\',idLab = \'headerTitel\',css = \'\',is_leaf = \'1\',orderBy = \'7\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'3\',id_sup = \'0\',idLab = \'question\',css = \'\',is_leaf = \'1\',orderBy = \'6\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'4\',id_sup = \'0\',idLab = \'instructionText\',css = \'\',is_leaf = \'1\',orderBy = \'5\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'5\',id_sup = \'0\',idLab = \'oddRow\',css = \'\',is_leaf = \'1\',orderBy = \'3\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'6\',id_sup = \'0\',idLab = \'answerContainer\',css = \'\',is_leaf = \'1\',orderBy = \'2\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'7\',id_sup = \'0\',idLab = \'evenRow\',css = \'\',is_leaf = \'1\',orderBy = \'4\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'8\',id_sup = \'0\',idLab = \'controlButtons\',css = \'\',is_leaf = \'1\',orderBy = \'1\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'9\',id_sup = \'0\',idLab = \'align-middle\',css = \'\',is_leaf = \'1\',orderBy = \'9\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'10\',id_sup = \'0\',idLab = \'align-center\',css = \'\',is_leaf = \'1\',orderBy = \'10\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'11\',id_sup = \'0\',idLab = \'leave-text\',css = \'\',is_leaf = \'1\',orderBy = \'11\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'14\',id_sup = \'0\',idLab = \'textBoxControl\',css = \'\',is_leaf = \'1\',orderBy = \'14\';\r\n<stat>INSERT INTO _DesignerCss SET id = \'15\',id_sup = \'0\',idLab = \'textAreaControl\',css = \'\',is_leaf = \'1\',orderBy = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'1\',id_class = \'1\',id_property = \'84\',prop_value = \'white\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'17\',id_class = \'3\',id_property = \'82\',prop_value = \'15px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'3\',id_class = \'1\',id_property = \'10\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'4\',id_class = \'1\',id_property = \'88\',prop_value = \'center\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'5\',id_class = \'2\',id_property = \'51\',prop_value = \'30px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'6\',id_class = \'2\',id_property = \'84\',prop_value = \'black\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'18\',id_class = \'3\',id_property = \'1\',prop_value = \'24\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'8\',id_class = \'2\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'9\',id_class = \'2\',id_property = \'1\',prop_value = \'16px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'10\',id_class = \'2\',id_property = \'63\',prop_value = \'bold\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'11\',id_class = \'2\',id_property = \'26\',prop_value = \'solid\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'12\',id_class = \'2\',id_property = \'25\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'13\',id_class = \'2\',id_property = \'27\',prop_value = \'medium\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'16\',id_class = \'1\',id_property = \'86\',prop_value = \'2\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'15\',id_class = \'2\',id_property = \'79\',prop_value = \'20px\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'19\',id_class = \'1\',id_property = \'63\',prop_value = \'bolder\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'20\',id_class = \'4\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'21\',id_class = \'4\',id_property = \'1\',prop_value = \'20\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'22\',id_class = \'4\',id_property = \'10\',prop_value = \'#eaeaea\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'23\',id_class = \'4\',id_property = \'83\',prop_value = \'5\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'24\',id_class = \'5\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'28\',id_class = \'5\',id_property = \'1\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'27\',id_class = \'1\',id_property = \'54\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'26\',id_class = \'6\',id_property = \'82\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'29\',id_class = \'7\',id_property = \'57\',prop_value = \'Arial\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'30\',id_class = \'7\',id_property = \'1\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'32\',id_class = \'8\',id_property = \'79\',prop_value = \'20\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'33\',id_class = \'8\',id_property = \'19\',prop_value = \'thin\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'34\',id_class = \'8\',id_property = \'17\',prop_value = \'#0094da\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'35\',id_class = \'8\',id_property = \'18\',prop_value = \'solid\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'37\',id_class = \'6\',id_property = \'81\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'38\',id_class = \'6\',id_property = \'79\',prop_value = \'15\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'39\',id_class = \'4\',id_property = \'49\',prop_value = \'middle\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'40\',id_class = \'5\',id_property = \'10\',prop_value = \'#eaeaea\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'41\',id_class = \'6\',id_property = \'80\',prop_value = \'75\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'42\',id_class = \'9\',id_property = \'88\',prop_value = \'center\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'43\',id_class = \'11\',id_property = \'63\',prop_value = \'bold\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'44\',id_class = \'11\',id_property = \'84\',prop_value = \'red\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'45\',id_class = \'3\',id_property = \'88\',prop_value = \'left\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'52\',id_class = \'14\',id_property = \'54\',prop_value = \'300\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'54\',id_class = \'15\',id_property = \'51\',prop_value = \'80\';\r\n<stat>INSERT INTO _DesignerClsPropLink SET id = \'55\',id_class = \'15\',id_property = \'54\',prop_value = \'250\';','UPDATE WEB questionnaire styles: firstProject','2015-12-16 11:50:01','');
/*!40000 ALTER TABLE `_LiveUpdateSql` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateVersion`
--

DROP TABLE IF EXISTS `_LiveUpdateVersion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateVersion` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `file_program_ver` int(5) NOT NULL DEFAULT '2000',
  `support_program_ver` int(5) NOT NULL DEFAULT '0',
  `checksum` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `major_version` tinyint(4) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `version` (`file_program_ver`),
  KEY `active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateVersion`
--

LOCK TABLES `_LiveUpdateVersion` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateVersion` DISABLE KEYS */;
INSERT INTO `_LiveUpdateVersion` VALUES (1,1,1,0,NULL,0,1),(2,0,2,0,NULL,0,1);
/*!40000 ALTER TABLE `_LiveUpdateVersion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_LiveUpdateVersionClients`
--

DROP TABLE IF EXISTS `_LiveUpdateVersionClients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_LiveUpdateVersionClients` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `file_program_ver` int(5) NOT NULL,
  `id_client` int(5) NOT NULL DEFAULT '0',
  `permission_type` tinyint(11) NOT NULL COMMENT '1 - allow to client, 2 - not allow to client',
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_program_ver_id_client` (`file_program_ver`,`id_client`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_LiveUpdateVersionClients`
--

LOCK TABLES `_LiveUpdateVersionClients` WRITE;
/*!40000 ALTER TABLE `_LiveUpdateVersionClients` DISABLE KEYS */;
/*!40000 ALTER TABLE `_LiveUpdateVersionClients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liveUpdate_log`
--

DROP TABLE IF EXISTS `liveUpdate_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liveUpdate_log` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `interv_id` int(11) NOT NULL,
  `version` int(11) NOT NULL,
  `time_update` datetime NOT NULL,
  `error_message` longtext NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `int_ver` (`interv_id`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liveUpdate_log`
--

LOCK TABLES `liveUpdate_log` WRITE;
/*!40000 ALTER TABLE `liveUpdate_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `liveUpdate_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `questionary_log`
--

DROP TABLE IF EXISTS `questionary_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `questionary_log` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `interv_id` int(11) NOT NULL,
  `proj_id` int(11) NOT NULL,
  `time_update` datetime NOT NULL,
  `error_message` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `questionary_log`
--

LOCK TABLES `questionary_log` WRITE;
/*!40000 ALTER TABLE `questionary_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `questionary_log` ENABLE KEYS */;
UNLOCK TABLES;
