<?php 
header("Content-type: text/html; charset=utf-8");
header("Cache-Control: no-cache, must-revalidate"); 
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 

ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL ^ E_NOTICE);

date_default_timezone_set('Europe/Ljubljana');

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT.'_config/dbConfig.php');

set_time_limit(0);

// settings ****************************************************************************
$token = "sdbo892f";
// *************************************************************************************

// check *******************************************************************************
$sid = preg_replace('~[^a-zA-Z0-9]+~', '_', strtolower($_GET['sid']));
$sampleP = explode(",", preg_replace('~[^,0-9]+~', '', strtolower($_GET['sample_points'])));
$id_project = intval($_GET['project']);
// *************************************************************************************

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Strict//EN">
<html>
<head>
  <title>warpit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<?php

echo "<pre>";
//echo "sid: $sid, token: $token<br>";

if ($sid == $token AND $id_project>0) {
	echo "ID project: $id_project<br>Checking sample point(s): ";
	print_r($sampleP);
	echo "<br>";
	$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
	foreach ($sampleP as $sp) {
		if (!$sp) {
			echo "Bad sample point parameter. Can not continue.";
			exit;
		}
		$base = array();
		echo "<br><br>ID sample point: $sp<br>";
		
		// get known user_id, id of sample point (id of <project name>___sample) and data record (id of the <project name>_structure)
		$sql = "SELECT `user_id`,`quest_id`,`id_structure`,`sample_point`,`id_project`
				FROM `_capi_interviewer_visits` 
				WHERE `sample_point`=$sp AND `id_project`=$id_project
				ORDER BY `obisk_st` ASC LIMIT 1";
		//echo "$sql<br>";
		$result = $db->SQLexecute($sql);
		$base = $db->fetchAssoc($result);
		echo "Paremeters check...<br>";
		print_r($base);
		echo "<br><br>";
		
		// check for id_project
		if (!$base['id_project']) {
			echo "Check if visit for parameters exist... FAILED! Can not continue.<br>";
			echo "$sql<br>";
			exit;
		}

		// check for structure id
		if (!$base['id_structure']) {
			echo "Missing ID structure. Can not continue.<br>";
			exit;
		}
				
		// get project name
		$base['proj_name'] = $db->get('_Projects',$base['id_project'],'proj_name');
		//echo "SELECT proj_name FROM _Projects WHERE id = ".$base['id_project']."<br>";

		// check for project
		if (!strlen($base['proj_name'])) {
			echo "Missing project. Can not continue.<br>";
			echo "SELECT proj_name FROM _Projects WHERE id = ".$base['id_project']."<br>";
			exit;
		}

		// check for sample point
		if (!$base['sample_point']) {
			echo "Missing ID sample point. Can not continue.<br>";
			echo "$sql<br>";
			exit;
		}

		// get old SID and check if status of record is correct to update
		$sql = "SELECT `id_loginSID`,`status`,`status_rec`,`flag_bad`
				FROM ".$base['proj_name']."_structure 
				WHERE id=".$base['id_structure'];
		//echo "$sql<br>";
		$result = $db->SQLexecute($sql);
		$row = $db->fetchAssoc($result);
		if (!$row['status'] AND !$row['status_rec'] AND $row['flag_bad'] == 99) 
			$base['old_SID'] = $row['id_loginSID'];
		else {
			echo "Record status is not correct to repair it. Status=".$row['status'].". Can not continue.<br>";
			echo "$sql<br>";
			exit;			
		}
				
		// check for old id_loginSID (check if record inside structure exist)
		if (!$base['old_SID']) {
			echo "Missing old SID. Can not continue.<br>";
			echo "$sql<br>";
			exit;
		}
				
		// check for _www_ids exits, if yes, exit
		$sql = "SELECT loginSID FROM _www_ids
				WHERE id_project = ".$base['id_project']." AND id_user = ".$base['user_id']." AND user_type = 4 AND id_site = ".$base['quest_id'];					
		//echo "$sql<br>";
		$result = $db->SQLexecute($sql);
		if ($db->numRows($result)>0) {
			echo "Session exist on sample point ID=$sp. Can not continue.<br>";
			echo "$sql<br>";
			exit;
		}
	
		// generate new _www_ids for sample point		
		$sql = "INSERT IGNORE INTO _www_ids SET 
					id_user = ".$base['user_id'].",
					user_type =	4,
					id_project = ".($base['id_project'] * -1).",
					id_site = ".$base['quest_id'].",
					loginSID = '".substr(md5(time().$base['user_id'].$base['id_project']),0,15)."-'";	
		//echo "$sql<br>";
		$db->SQLexecute($sql);
		
		$sql = "UPDATE IGNORE _www_ids 
				SET loginSID = CONCAT(loginSID,id), id_project = ".$base['id_project']." 
				WHERE id_project = -".$base['id_project'];				
		//echo "$sql<br>";
		$db->SQLexecute($sql);
	
		$sql = "DELETE FROM _www_ids WHERE id_project = -".$base['id_project'];				
		//echo "$sql<br>";
		$db->SQLexecute($sql);
		
		
		// get new session SID for save it into multiple tables
		$sql = "SELECT `id`, `loginSID` FROM _www_ids 
				WHERE `id_user`=".$base['user_id']." AND `id_project`=".$base['id_project']." AND `id_site`=".$base['quest_id']." 
				ORDER BY id ASC LIMIT 1";
		//echo "$sql<br>";
		$result = $db->SQLexecute($sql);	
		$row = $db->fetchAssoc($result);
		$base['idSID'] = $row['id'];
		$base['loginSID'] = $row['loginSID'];
		
		echo "Second paremeters check...<br>";
		print_r($base);
		echo "<br><br>";
						
		// update data structure
		$sql = "UPDATE ".$base['proj_name']."_structure 
				SET `id_loginSID` = ".$base['idSID']." WHERE id=".$base['id_structure'];				
		//echo "$sql<br>";
		$db->SQLexecute($sql);
		echo "Update data structure...<br>";
		
		// update interviewer session
		$sql = "UPDATE _www_interviewer_session 
				SET `id_loginSID` = ".$base['idSID']." WHERE `id_loginSID`=".$base['old_SID'];				
		//echo "$sql<br>";
		$db->SQLexecute($sql);
		echo "Update session...<br>";
		
		// update interviewer statistics
		$sql = "UPDATE _www_interviewer_statistics 
				SET `id_loginSID` = ".$base['idSID']." WHERE `id_loginSID`=".$base['old_SID'];				
		//echo "$sql<br>";
		$db->SQLexecute($sql);
		echo "Update interview statistics...<br>";
		echo "ALL DONE!<br>";
	}
} else {
	echo "Wrong parameters to start.";
}

echo "</pre>";

?>
</body>
</html>