<?php 
header("Content-type: text/html; charset=utf-8");
header("Cache-Control: no-cache, must-revalidate"); 
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 

ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL ^ E_NOTICE);

date_default_timezone_set('Europe/Ljubljana');

include_once("_dirinfo.php");
include_once(PATH_TO_ROOT.'_config/dbConfig.php');
include_once('Combinations.php');

set_time_limit(900);

// ****************************************************************************************************
$workTable = "RNC_2014_structure";

$vars_arr[1] = "f1_1";
$vars_arr[2] = "f1_2";
$vars_arr[3] = "f1_3";
$vars_arr[4] = "f1_4";
$vars_arr[5] = "f1_5";
$vars_arr[6] = "f1_6";
$vars_arr[7] = "f1_7";
$vars_arr[8] = "f1_8";
$vars_arr[9] = "f1_9";
$vars_arr[10]= "f1_10";

$labs_f1[1] = "Auto";
$labs_f1[2] = "Moped, Motorrad";
$labs_f1[3] = "städtischer öffentlicher Verkehr";
$labs_f1[4] = "Zug";
$labs_f1[5] = "Überland-Bus (Postbus, private Busunternehmen, etc.)";
$labs_f1[6] = "zu Fuß";
$labs_f1[7] = "Fahrrad";
$labs_f1[8] = "Elektrofahrrad";
$labs_f1[9] = "Tretroller, Scooter";
$labs_f1[10]= "Sonstiges";
// ****************************************************************************************************

$f3_item = intval($_POST['f3_item']);
$f3_value = intval($_POST['f3_value']);
if (strlen($f3_item)>0 AND $f3_item>0 AND strlen($f3_value)>0 AND $f3_value>0) $f3_where = " AND f3_".$f3_item." = ".$f3_value;
$atLeast = intval($_POST['atLeast']);
if ($atLeast) $atLeast_checked = "checked";
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Strict//EN">
<html>
<head>
  <title>warpit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<pre>
<FORM ACTION="<?php echo $PHP_SELF ?>" METHOD="post">
 <b>SET FILTER:</b><br>
 f3 item: <INPUT type="textbox" name="f3_item" size=1 value="<?php echo $f3_item; ?>"> f3 value: <INPUT type="textbox" name="f3_value" size=1 value="<?php echo $f3_value; ?>"><br>
 only (X) item checked: <input type=checkbox name=atLeast value=1 <?php echo $atLeast_checked; ?> >
<br><br><input type=submit name=filterVar value=OK>
</FORM>
<hr>
<?php

	$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
		

	// get the number of togethers
	for ($k=1; $k<=10; $k++) {
		// make all combinations for specified number
		foreach(new Combinations("1234567890", $k) as $substring) {
		
			$varTmp = array();
			$labTmp = array();
			$varTmp_not = array();
			$varCond_not = null;
			$atLeast_lab = "at least";
							
			$arrComb = str_split($substring);
			foreach ($arrComb as $key => $value) {
				if ($value == 0) {
					$arrComb[$key] = 10;
					$value = 10;
				}
				$varTmp[] = "f1_".$value." = ".$value;
				$labTmp[] = $labs_f1[$value];
			}
			$varCond = implode(" AND ", $varTmp);
			$varLab = implode(",<br>", $labTmp);
			
			// add only checked filter
			if ($atLeast) {
				for ($i=1; $i<=10; $i++) {
					if (!in_array($i, $arrComb))
						$varTmp_not[] = "f1_".$i." = 0";
				}
				if (count($varTmp_not) > 0) $varCond_not = " AND " . implode(" AND ", $varTmp_not);
				
				$atLeast_lab = "only";
			}
			
			// total
			$sql = "SELECT count(*) AS N FROM $workTable WHERE status=1 AND status_rec=1 $f3_where";
			//echo "$sql<br>";
			$result = $db->SQLexecute($sql);
			$row = $db->fetchAssoc($result);
		
			$sql_ch = "SELECT count(*) AS N FROM $workTable WHERE $varCond $varCond_not AND status=1 AND status_rec=1 $f3_where";
			//echo "$sql_ch<br>";
			$result_ch = $db->SQLexecute($sql_ch);
			$row_ch = $db->fetchAssoc($result_ch);
			$pct = round($row_ch['N']/$row['N']*100);
			
			$calcResult[$varCond] = "<tr><td>".$varLab."</td><td align=right>".$row_ch['N']."</td>";
			$calcResult[$varCond] .= "<td align=right>".$pct."%</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td>";
			$calcResult[$varCond] .= "<td align=right>".($row['N'] - $row_ch['N'])."</td><td align=right>".(100 - $pct)."%</td></tr>";
			
		}

		echo "<b>total N = ".$row['N']."</b><br>";
		echo "<table cellspacing=0 border=1><tr><td><b>$atLeast_lab<br>$k item(s) checked</b></td><td colspan=2><b>clicked</b></td><td></td><td align=center colspan=2><b>not<br>clicked</b></td></tr>";
		foreach ($calcResult AS $key => $item) {
			echo $item;
		}
		echo "</table><br><br><br>";
		unset($calcResult);
	}

?>
</pre>
</body>
</html>