<?php
include_once ("_dirinfo.php");

include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.treeData.php");


$db->ChangeDatabase(DB_WARPIT_MAIN);

$tableName = '_Permissions';

class permissionGridManipulator extends TreeDataManipulator {
	
	/**
	 * recursive function for finding group allow and deny 
	 *
	 * @param unknown_type $permId - the id of the permission
	 * @param unknown_type $id - the current id of the user/group
	 */
	private function findGroupAD($permId,$id,$ptype)
	{
		$sql = "SELECT allow,deny FROM _PermissionLink WHERE id_permission = $permId AND id_permission_group = $id AND p_type=$ptype";
		if (!$res = $this->db->SQLexecute($sql)){ return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		if ($row = $this->db->fetchArray($res)) 
		{
			if($row[0] || $row[1])
			return $row;	
		}
		$sql = "SELECT id_sup FROM _PermissionGroups WHERE id = $id";
		if (!$res = $this->db->SQLexecute($sql)){ return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';}
		if ($row = $this->db->fetchArray($res)) 
		{
			if($row[0] > 0 )
				return $this->findGroupAD($permId, $row[0],$ptype);	
		}
		return array(0,0);
		
	}
	function selectAction()
	{
		
		$parent = $_POST['node'];
		$isUser = $_POST['isUser'] == 'true';
		$id = $_POST['id'];
		$field = $isUser ? 'id_user' : 'id_permission_group';
		$ptype=0;
		if($parent == 6 || substr($parent,0,6 ) == 'wcmenu' ) {
			if ($parent != 6) $parent = substr($parent,7);
			else  $parent = 0;
			
			$ptype = 1;
			$sql = "SELECT a.*,b.allow,b.deny
					FROM ".DB_WARPIT_WEBCATI_BASE."._ProgramMenu AS a
						LEFT JOIN ".DB_WARPIT_MAIN."._PermissionLink AS b ON a.id = b.id_permission AND b.$field =$id AND p_type = $ptype
				 WHERE id_sup = ".$parent.' AND idLab != "fake" ORDER BY orderBy';
			$prefix = 'wcmenu_';
		} else if($parent == 8 || substr($parent,0,6 ) == 'wcproj' ) {
			if ($parent != 8) $parent = substr($parent,7);
			else  $parent = 0;
			
			$ptype = 2;
			$sql = "SELECT a.*,b.allow,b.deny
					FROM ".DB_WARPIT_WEBCATI_BASE."._ProjectsTree AS a
						LEFT JOIN ".DB_WARPIT_MAIN."._PermissionLink AS b ON a.id = b.id_permission AND b.$field =$id AND p_type = $ptype
				 WHERE id_sup = ".$parent.' AND idLab != "fake" ORDER BY orderBy';
			$prefix = 'wcproj_';
		}
        elseif ($parent == 44 ) {
            // mystery shopping visit groups
            $ptype = 9;
            $sql = "SELECT a.*,b.allow,b.deny
					FROM ". DB_WARPIT_MYSTERY . "._Visits  AS a
						LEFT JOIN ".DB_WARPIT_MAIN."._PermissionLink AS b ON a.id = b.id_permission AND b.$field =$id AND p_type = $ptype
				 WHERE is_leaf = 0 and id_sup = 0";
            $prefix = 'mystery_';
        }
        elseif ($parent == 47 ) {
            // mystery shopping project Groups in statistics
            $ptype = 10;
            $sql = "SELECT a.*,b.allow,b.deny
					FROM ". DB_WARPIT_MYSTERY . "._Groups  AS a
						LEFT JOIN ".DB_WARPIT_MAIN."._PermissionLink AS b ON a.id = b.id_permission AND b.$field =$id AND p_type = $ptype
				 WHERE is_leaf = 0 ORDER BY orderBy ";
            
            $prefix = 'mysteryP_';
        }
        else {
			$sql = "SELECT a.*,b.allow,b.deny
					FROM _Permissions AS a
					LEFT JOIN _PermissionLink AS b ON a.id = b.id_permission AND b.$field =$id AND p_type=0
				 	WHERE id_sup = ".$parent.' ';
			// ORDER BY a.orderBy ASC   --- tole nima smisla, ker je sort v JS nareti po permissions koloni, 
			// kakorkoli posljem podatke vedno klijent posortira po imenu
		}
		
		$this->db->LogWrite($sql,true,"Permission sql");
		if (!$res = $this->db->SQLexecute($sql)) {			
		  return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
		} else {
		
			// display each child
			while ($row = $this->db->fetchAssoc($res)) {
				
				// Response parameters.
				$path = array();
				$path['id']			= $prefix.$row['id'];	
				$path['permission']	= html_entity_decode($row['idLab']);				
				
				if ($row['allow']) $row['allow'] = "checked";
				if ($row['deny']) $row['deny'] = "checked";
				
				
				//lets find the group allow and deny
				if($isUser) {
					$sql = "SELECT permissionGroup FROM _user WHERE id = $id";
				} else{
					$sql = "SELECT id_sup FROM _PermissionGroups WHERE id = $id";
				}
					
				if (!$resGAD = $this->db->SQLexecute($sql)){ 
					return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
				}
				if ($rowGAD = $this->db->fetchArray($resGAD)) {
					if( $rowGAD[0] > 0) {
						$groupAD = $this->findGroupAD($row['id'], $rowGAD[0],$ptype);
						if($groupAD[0]) $path['gallow'] = 'checked';	
						if($groupAD[1]) $path['gdeny'] = 'checked';
					}
				}
				
				
				$path['allow']		= $row['allow'];
				$path['deny']		= $row['deny'];
				$path['leaf']		= $row['is_leaf'] ? true : false;

				$nodes[] = $path;
			}
			
			
		}
		return json_encode($nodes);
	}

	function updateAction()
	{
		$node = $_POST['node'];
		$isUser = $_POST['isUser'];
		$id = $_POST['id'];
		$field = $isUser == 'true' ? 'id_user' : 'id_permission_group';
		$type = $_POST['type'];
		$checked = $_POST['checked'];
		if(substr($node,0,6) == 'wcmenu')
		{
			$node = substr($node,7);
			$ptype = 1;
		}
        else if (substr($node,0,8) == 'mysteryP') {
			$node = substr($node,9);
			$ptype = 10;
		}
		else if (substr($node,0,7) == 'mystery') {
			$node = substr($node,8);
			$ptype = 9;
		}
		else if(substr($node,0,6) == 'wcproj')
		{
			$node = substr($node,7);
			$ptype = 2;
		}
		else 
			$ptype = 0;
		
		$sql = "INSERT INTO _PermissionLink (id_permission,$field,$type , p_type ) VALUES ($node,$id,$checked , $ptype )
		ON DUPLICATE KEY UPDATE $type = $checked ";
		
		if (!$res = $this->db->SQLexecute($sql)) 
		{			
		  return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
		}
		global $UserSession;
		if($isUser == 'true' && $id == $UserSession->user_id)
		{
			$UserSession->getRights();
		}
		
		return "{success:true}";
	}
}

$manipulator = new permissionGridManipulator($db,$tableName);
$comm = $_POST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else 
{	
	Echo '{success:false,error:"Unknown action!"}';	
	
}
?>