<?php
namespace Steps;

use \ActionData;

use \Curl\Curl;

class UploadRecords extends AbstractStep
{
    private $db;

    private $actionData;

    public function __construct(\DataContainers\ActionData $actionData)
    {
          $this->actionData = $actionData;
    }

    public function execute()
    {

      $xml = $this->actionData->getXML();

      $url = config('reciveUrl');

    	$params = array(
  				'client-machine-id' => config('client-machine-id'),
  				'user_id=' =>          config('user_id'),
  				'PostData' =>          $xml
  			);

      $curl = new Curl();
      //$curl->setDefaultDecoder("xml");
      //curl_setopt($process, CURLOPT_USERPWD, $username . ":" . $password);
    //  $curl->setOpt(CURLOPT_USERPWD, 'tanis:test');
      $curl->success([$this, "success"]);
      $curl->error([$this, "error"]);

      $curl->setOpt(CURLOPT_SSL_VERIFYHOST, config('ssl_verify'));
      $curl->setOpt(CURLOPT_SSL_VERIFYPEER, config('ssl_verify'));

      $curl->post($url, $params);

    }

    public function success($curl)
    {
      $response = json_decode($curl->response, true);
      $uploadData = $this->actionData->getUploaded();

      if($response['insertedIds'])
      {
          foreach($response['insertedIds'] as $database => $tables)
          {
                $localDatabase = $this->getLocalDatabase($database);
                foreach($tables as $tableName => $data)
                {
                    if(isset($data['msg']))  $this->clientStatus->uploadErrorOnServer($data);

                    $datatab = $localDatabase . "." . $tableName;
                    $this->actionData->addUploadedRecords($datatab, $data['ids']);

                    $updateData['uploaded'] = count($uploadData[$datatab]['forUpload']);
                    $updateData['saved'] = count($data['ids']);

                    if (strpos($tableName, '_structure') !== false)
                    {
                        $this->clientStatus->recordsUploaded($updateData);
                    }
                    else
                    {
                        $this->clientStatus->visitsUploaded($updateData);
                    }

                }
          }
      }
    }

    public function error($curl)
    {
        if($curl->httpStatusCode == 404)
        {
            $this->clientStatus->cantConnect();
        }
        else if($curl->httpStatusCode == 500)
        {
            $this->clientStatus->errorOnServer();
        }
        else
        {
            $this->clientStatus->errorOnServer();
        }
    }

    public function getLocalDatabase($remoteDatabase)
    {
        switch($remoteDatabase)
        {
          case "table_warpit_webcati_base": return DB_WARPIT_WEBCATI_BASE; break;
          default: return DB_WARPIT_LIVEUPDATE;
        }
    }
}
