<?php

namespace Warpit\Services;

use App\Services\WarpitConfigService;
use Warpit\Repositories\SendEmailRepository;
use Log;

class SendEmailService
{
    protected $sendEmailRepository = null;

    protected $warpitConfigService = null;

    public function __construct(SendEmailRepository $sendEmailRepository, WarpitConfigService $warpitConfigService)
    {
        $this->sendEmailRepository = $sendEmailRepository;
        $this->warpitConfigService = $warpitConfigService;
    }

    public function sendEmails()
    {
        $toSend = $this->sendEmailRepository->getQueuedMailSets();
        Log::debug('Send:', [$toSend]);

        if($toSend->isEmpty()){
          Log::debug("Nothing to send!");
           return true;
        }

        foreach($toSend as $mailSet){
            $id = $mailSet->id;
            $this->sendEmailRepository->setInProgressStatus($id);
            $this->sendMailSet($id);
            $this->sendEmailRepository->setFinishedStatus($id);
        }

    }

    private function sendMailSet($id)
    {
          Log::debug("Start sending mailSetId: " . $id);
          $url = $this->warpitConfigService->getConfig('paths','cli_www', WARPIT_WWW);
          $url .= 'webuserspool/_ajax/ajax.sendMail.php';

          $post = [
              'appID'      => 'SoulskinerHardCodedAndVerySecure',
              'mailStatus' => '2',
              'mailSet'    => $id
          ];


          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $url);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
          $response = curl_exec($ch);


          Log::debug("Done with MailSetId:" . $id);
    }
}
