<?php

namespace Warpit\Services;

use App\Services\WarpitConfigService;
use Log;
use Warpit\Repositories\SendEmailRepository;

require(PATH_TO_ROOT. 'webcati/_class/class.quotas.php');


class ResetQuotasService
{
    protected $sendEmailRepository = null;

    protected $warpitConfigService = null;

    public function __construct(SendEmailRepository $sendEmailRepository, WarpitConfigService $warpitConfigService)
    {

        define(PATH_TO_ROOT, '../../');

        $this->sendEmailRepository = $sendEmailRepository;
        $this->warpitConfigService = $warpitConfigService;
    }

    public function resetQuotas()
    {
        $projects = $this->warpitConfigService->getConfig('webcati', 'reset_quotas_schedule_projects', WARPIT_WWW);
        $projects = explode(',', $projects);
        foreach ($projects as $project) {
            $this->resetProjectQuotas($project);
        }
    }

    private function resetProjectQuotas($projectId)
    {
        global $db;

        $projectName = getProjectName($projectId);
        $quotaCalcTable = $projectName . "___quotaCalc";

        $db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);

        $sql = "TRUNCATE TABLE " . $quotaCalcTable;
        $db->SQLexecute($sql);

        error_reporting(0);
        $quotas = new \quotes($projectId, $db);
        $quotas->recalculateLock();
        error_reporting(E_ALL ^ E_DEPRECATED);
    }
}
