<?php

namespace Warpit\Repositories;

use Rah\Danpu\Dump;
use Rah\Danpu\Import;

class WarpitInstallRepository
{
    public function setDatabase(\db $db)
    {
        $this->db = $db;
    }

    public function createDatabase($name)
    {
        $create_sql = "CREATE DATABASE IF NOT EXISTS `" . $name . "` /*!40100 COLLATE 'utf8_general_ci' */";
        $this->db->SQLexecute($create_sql);

        return $this;
    }
    
    public function mainDatabaseExists($prefix)
    {
        $check_sql = 'SHOW DATABASES WHERE `Database` LIKE "' . $prefix . '"';
        $data = $this->db->SQLexecute($check_sql);
        return $this->db->NumRows($data) > 0;
    }

    public function databasesExists($prefix)
    {
        $check_sql = 'SHOW DATABASES WHERE `Database` LIKE "' . $prefix . '%"';
        $data = $this->db->SQLexecute($check_sql);
        return $this->db->NumRows($data) > 1;
    }

    public function importDatabase($path, $database, $mysqlUser, $mysqlPass, $mysqlHost)
    {
        $dump = new Dump;
        $dump
            ->file($path)
            ->dsn('mysql:dbname=' . $database . ';host=' . $mysqlHost)
            ->user($mysqlUser)
            ->pass($mysqlPass);

        new Import($dump);

        return $this;
    }

    public function updateDatabaseConfig($config, $value, $dbName, $prefix = null)
    {
          $update_sql = "UPDATE " . $dbName . "._WarpitConfig SET cValue = '" . $value ."' WHERE cName ='" . mysql_real_escape_string($config) . "'";
          if($prefix !== null) {
              $update_sql .= " AND prefix = '$prefix'";
          }

          $this->db->SQLexecute($update_sql);

          return $this;
    }

}
