<?php

namespace Warpit\Repositories;

use App\Repositories\BaseRepository;
use Carbon\Carbon;

class SendEmailRepository extends BaseRepository
{

    public function getQueuedMailSets()
    {
        return $this->webuserspool
                      ->table('_SendMailSet')
                      ->select('id')
                      ->where('status', 3)
                      ->where('date_schedule', '<=', Carbon::now())->get();
    }

    public function setInProgressStatus($mailSetId)
    {
        $this->setStatus($mailSetId, 2);
    }

    public function setFinishedStatus($mailSetId)
    {
        $this->setStatus($mailSetId, 1);
    }

    private function setStatus($mailSetId, $status)
    {
        $this->webuserspool
                ->table('_SendMailSet')
                ->where('id', $mailSetId)
                ->update(['status' => $status]);
    }

}
