<?php

namespace Warpit\Repositories;

use App\Repositories\BaseRepository;
use Carbon\Carbon;

class MaintenencModeRepository extends BaseRepository
{

    protected function change($newValue)
    {
        $this->warpitConnection
            ->table('_WarpitConfig')
            ->where('prefix', 'warpit')
            ->where('cName', 'maintenance_mode')
            ->update(['cValue' => $newValue]);
    }

    public function turnOn()
    {
        $this->change(1);
    }

    public function turnOff()
    {
        $this->change(0);
    }
}
