<?php

use Warpit\Utilities;
use Symfony\Component\Console\Application;

require __DIR__ . '/../../framework/bootstrap.php';
include_once('_dirinfo.php');

$container = app();
$application = $container->make(Symfony\Component\Console\Application::class);

if(configExists() === false){
    error_reporting(E_ALL ^ E_DEPRECATED);
    include_once(__DIR__ . '/../../_support/class.db.php');
}

$application->add($container->make(Warpit\Console\Command\InstallConfigCommand::class));
$application->add($container->make(Warpit\Console\Command\InstallDatabaseCommand::class));
$application->add($container->make(Warpit\Console\Command\InstallFilesCommand::class));
$application->add($container->make(Warpit\Console\Command\InstallCronjobCommand::class));
$application->add($container->make(Warpit\Console\Command\InstallWarpitCommand::class));
$application->add($container->make(Warpit\Console\Command\TestInstallationCommand::class));

if(configExists() === true){

    //This is very very very ugly. World can be ugly sometime :S
    error_reporting(0);
    $dbConfigOnly = false;
    include_once(__DIR__ . '/../../_config/dbConfig.php');
    error_reporting(E_ALL ^ E_DEPRECATED);

    $container->instance('Schedule', Warpit\Console\Schedule::class);

    $application->add($container->make(Warpit\Console\Command\ScheduleCommand::class));
    $application->add($container->make(Warpit\Console\Command\MigrateCommand::class));
    $application->add($container->make(Warpit\Console\Command\MigrateCreateCommand::class));
    $application->add($container->make(Warpit\Console\Command\MigrateRollbackCommand::class));
    $application->add($container->make(Warpit\Console\Command\GenerateHashCommand::class));
    $application->add($container->make(Warpit\Console\Command\MaintenencModeCommand::class));
    $application->add($container->make(Warpit\Console\Command\RecreateStructureCommand::class));
}



$application->run();
