<?php

namespace Warpit\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Warpit\Services\MaintenencModeService;


class MaintenencModeCommand extends Command
{
    protected $maintenencModeService = null;

    public function __construct(MaintenencModeService $maintenanceModeService)
    {
        $this->maintenencModeService = $maintenanceModeService;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('maintenenc')
            ->setDescription('Turn on/off maintenenc mode')
            ->setHelp('');

        $this->addArgument('state',InputArgument::REQUIRED, 'on/off');
    }


    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $state = $input->getArgument('state');

        if($state === 'on'){
            $this->maintenencModeService->turnOn();
        } else if($state ==='off') {
            $this->maintenencModeService->turnOff();
        }

        $output->writeln('<info>Maintenenc mode is ' . $state . ' now!</info>');
    }

}