<?php 

class export
{
	protected $db;
	
	public function __construct($db) {
		$this->db=$db;
	}
	
	
	public function loadColumns($table) {
		$exclude = array("id", "id_clien", "flag_cli", "user_id", "user_type", "id_loginSID", "id_device", "id_language", 
						"smpl_var", "sp_adult", "sp_man", "id_site", "status", "status_rec", "flag_bad", "t_status", 
						"t_start", "t_stop", "d_status", "d_start", "d_stop", "t_pause", "t_diffs", "QT_user_id");
		
		$sql = "SHOW COLUMNS FROM ".DB_WARPIT_WEBCATI_BASE.".".$table."_structure";
		$this->db->LogWrite($sql,true,"get TGI project fields");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			if (!in_array($row['Field'],$exclude)) $cols[] = $row['Field'];
		}

		return $cols;
	}
	
	
	public function getIDs($table) {
		$sql = "SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".".$table."_structure";
		$this->db->LogWrite($sql,true,"get TGI project IDs");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			$ids[] = $row['id'];
		}
		
		return $ids;
	}
	
	
	public function getTGIstructure($addExportVars,$addExportVarsPool) {
		$tgiFields = array("id","d_start","d_stop","status","status_rec");
		if (strlen($addExportVars) > 0) {
			$addVars_arr = explode(",", $addExportVars);
			$tgiFields = array_merge($tgiFields,$addVars_arr); // adding custom fields
		}
		if (strlen($addExportVarsPool) > 0) {
			$addVarsPool_arr = explode(",", $addExportVarsPool);
			$tgiFields = array_merge($tgiFields,$addVarsPool_arr); // adding custom pool fields
		}
		$where = null;

		
		$sql = "SELECT * FROM `TGI_projects_export` $where";
		//echo "$sql<br>";
		$this->db->LogWrite($sql,true,"get TGI fields");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			if (in_array($row['TGI_code'],$tgiFields) == false) {
				$tgiFields[] = $row['TGI_code'];
			}
		}
		
		return $tgiFields;
	}
	
	
	public function getTGIstructureProject($project) {
		$tgiFields = array();
		$where = "WHERE warpit_project='$project'"; 
		
		$sql = "SELECT * FROM `TGI_projects_export` $where";
		//echo "$sql<br>";
		$this->db->LogWrite($sql,true,"get TGI fields");
		$res = $this->db->SQLexecute($sql);
		while ($row = $this->db->fetchAssoc($res)) {
			if (!isset($tgiFields[$row['TGI_code']])) {
				$tgiFields[$row['TGI_code']] = $row['warpit_question'].",".$row['warpit_code'].",".$row['column_count'].",".$row['qType'].",".$row['qSubType'];
			}
		}
		
		return $tgiFields;
	}
	
	
	public function getData($project,$structure,$id_structure,$addExportVars) {
		$predefinedFields = "status,status_rec,d_start,d_stop";
		if (strlen($addExportVars) > 0) {
			$predefinedFields .= ",".$addExportVars;
		}
		
		$sql = "SELECT $predefinedFields,".implode(",",$structure)." 
				FROM ".DB_WARPIT_WEBCATI_BASE.".".$project."_structure 
				WHERE id=$id_structure";
		//echo "$sql<br>";
		
		$this->db->LogWrite($sql,true,"get TGI data from $project for ID=$id_structure");
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		
		return $row;
	}
	
	
	public function getDataPool($project,$id_structure,$addExportVarsPool) {
		// get webcati interviewer user and pass
		$sql_pass = "SELECT username, password 
				FROM ".DB_WARPIT_WEBCATI_BASE."._Interviewer 
				WHERE id=$id_structure";
		//echo "$sql_pass<br>";
		
		$this->db->LogWrite($sql_pass,true,"get user and pass for ID=$id_structure");
		$res_pass = $this->db->SQLexecute($sql_pass);
		$row_pass = $this->db->fetchAssoc($res_pass);
		
				
		$sql = "SELECT ".$addExportVarsPool." 
				FROM ".DB_WARPIT_USERSPOOL."._Interviewer 
				WHERE  TGIuser='".$row_pass['username']."' AND TGIpass='".$row_pass['password']."'";
		//echo "$sql<br>";
		
		$this->db->LogWrite($sql,true,"get TGI data from POOL for TGIuser=".$row_pass['username']." AND TGIpass=".$row_pass['password']);
		$res = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($res);
		
		return $row;
	}
	
}
	
?>