<?php

namespace App\Tests;

use PHPUnit\Framework\TestCase;
use App\Services\AnswersConvertService;
use App\Entities\Answer;

class AnswersConvertServiceTest extends TestCase
{
      public function test_toArray()
      {
          $answersConvertService = new AnswersConvertService();

          $answersString = '1 Yes/2 No';
          $answersArray  = $answersConvertService->toArray($answersString);

          $this->assertInternalType('array',$answersArray);
          $this->assertCount(2, $answersArray);
          $this->assertSame(reset($answersArray)->id, 1);
          $this->assertSame(reset($answersArray)->label, 'Yes');
          $this->assertSame(end($answersArray)->id, 2);
          $this->assertSame(end($answersArray)->label, 'No');

          $answersArray  = $answersConvertService->toArray('');
          $this->assertEmpty($answersArray);

      }

      public function test_toString()
      {
          $answersArray = [];

          $answer = new Answer;
          $answer->id = 1;
          $answer->label = "Yes";
          $answersArray[] = $answer;

          $answer = new Answer;
          $answer->id = 2;
          $answer->label = "No";
          $answersArray[] = $answer;

          $answersConvertService = new AnswersConvertService();
          $answersString = $answersConvertService->toString($answersArray);

          $this->assertInternalType('string', $answersString);
          $this->assertSame($answersString, '1 Yes/2 No');

          $answersString = $answersConvertService->toString([]);
          $this->assertNull($answersString);
      }
}
