<?php

namespace App\Services;

use App\Repositories\WarpitConfigRepository;

class WarpitConfigService
{
    private static $config = [];

    public function __construct(WarpitConfigRepository $configRepository)
    {
        $this->configRepository = $configRepository;
    }

    public function getConfig($prefix, $cName, $default = null)
    {
        $config = &self::$config;

        if (!array_key_exists($prefix, $config)) {
            $config[$prefix] = $this->configRepository->getConfig($prefix);
        }

        if (array_key_exists($cName, $config[$prefix])) {
            return $config[$prefix][$cName];
        }

        if (!is_null($default)) {
            return $default;
        }

        throw new RuntimeException('Warpit Config doesn\'t contains this prefix cName pair: ' . $prefix . ' ' . $cName . '!');
    }
}
