<?php

namespace App\Services;

use App\Repositories\UniqueLinksRepository;

class UniqueLinksService
{
    public function __construct(UniqueLinksRepository $uniqueLinksRepository)
    {
        $this->uniqueLinksRepository = $uniqueLinksRepository;
    }

    public function createPopup($projectId)
    {
        $this->createLink($projectId, 3);
    }

    public function createUniqueLink($projectId)
    {
        $maxSiteId = $this->uniqueLinksRepository->getLastUniqueLink($projectId)->id_site;

        $this->createLink($projectId, 4, $maxSiteId + 1);

        return $this->uniqueLinksRepository->getLastUniqueLink($projectId)->loginSID;
    }

    public function createLink($projectId, $type, $siteId)
    {
        $loginSID = substr(md5(time().$projectId),0,15);
        $link = [
            'id_user'    => 0,
            'user_type'  => $type,
            'id_project' => $projectId,
            'id_site'    => $siteId,
            'idGenStruc' => $siteId,
            'loginSID'   => $loginSID,
        ];

        $linkId = $this->uniqueLinksRepository->insert($link);
        $newLoginSID = $loginSID . '-' . $linkId;

        $this->uniqueLinksRepository->updateLoginSID($linkId, $newLoginSID);
    }

    public function deletePopup($projectId)
    {
        $this->uniqueLinksRepository->deletePopup($projectId);
    }
}
