<?php

namespace App\Services\ProjectManager\Projects;

use App\Exceptions\RuntimeException;
use App\Repositories\ProjectManager\Projects\ExportProjectDataRepository;
use App\Services\ProjectService;
use App\Support\Filter;
use App\Traits\FilteringTrait;

class ExportProjectDataService
{
    protected $exportProjectDataRepository = null;

    protected $projectService = null;

    protected $outputStream = null;

    use FilteringTrait;

    public function __construct(ExportProjectDataRepository $exportProjectDataRepository, ProjectService $projectService)
    {
        $this->exportProjectDataRepository = $exportProjectDataRepository;
        $this->projectService = $projectService;
    }

    public function __destruct()
    {
        if($this->outputStream === null){
            return;
        }

        fclose($this->outputStream);
        $this->outputStream = null;
    }

    protected function exportCSVLine(array $line)
    {
        if($this->outputStream === null){
            $this->outputStream = fopen('php://output', 'w');
            fputcsv($this->outputStream,array_keys($line));
        }

        fputcsv($this->outputStream,$line);
    }

    public function validRecordsOnly()
    {
        $statusFilter    = new Filter('status','=',1);
        $statusRecFilter = new Filter('status_rec', '=', 1);

        $this->addFilter($statusFilter, 'exportProjectDataRepository');
        $this->addFilter($statusRecFilter, 'exportProjectDataRepository');
    }

    public function exportCSV($projectId, array $selectedColumns)
    {
        $structureTable = $this->projectService->getStructureTable($projectId);
        $structureData  = $this->exportProjectDataRepository->getData($structureTable, $selectedColumns);

        foreach ($structureData as $structureRecord){
            $structureRecordArray = json_decode(json_encode($structureRecord),true);
            $this->exportCSVLine($structureRecordArray);
        }
    }

}