<?php

namespace App\Services;


use App\Repositories\PanelistFieldsRepository;

class PanelistFieldsService
{
    protected $panelistFieldsRepository;

    public function __construct(PanelistFieldsRepository $panelistFieldsRepository)
    {
        $this->panelistFieldsRepository = $panelistFieldsRepository;
    }

    public function get()
    {
        return $this->panelistFieldsRepository->get();
    }

    public function findFields($needleField, $fieldsArray)
    {
        foreach ($fieldsArray as $field){
            if($field->field_name === $needleField){
                return $field;
            }
        }
        return null;
    }

    public function exits(array $fieldNames)
    {
        $allFields = $this->get();

        foreach($fieldNames as $field){
            if($this->findFields($field,$allFields) === null){
                return false;
            }
        }

        return true;
    }
}