<?php

namespace App\Repositories;

use App\Support\Filter;
use App\Support\Filtering;
use DBL;

class BaseRepository
{

    protected $filtering = null;

    protected $warpitConnection = null;

    protected $webcatiConnection = null;

    protected $webcatiBaseConnection = null;

    protected $webuserspool = null;

    public function __construct()
    {
        $this->warpitConnection      = DBL::connection();
        $this->webcatiConnection     = DBL::connection('webcati');
        $this->webcatiBaseConnection = DBL::connection('webcati_base');
        $this->webuserspool          = DBL::connection('webuserspool');
    }

    public function addFilter(Filter $filter)
    {
        if(!$this->filteringExists()){
            $this->filtering = new Filtering();
        }

        $this->filtering->addFilter($filter);
    }

    public function addOneTimeFilter(Filter $filter)
    {
        if(!$this->filteringExists()){
            $this->filtering = new Filtering();
        }

        $this->filtering->addOneTimeFilter($filter);
    }

    public function removeFiltering()
    {
        $this->filtering = null;
    }

    protected function filteringExists()
    {
        return $this->filtering !== null;
    }

    protected function filter($query)
    {
        if(!$this->filteringExists()){
            return false;
        }

        $this->filtering->filter($query);

    }




}
