<?php

namespace App\Middleware;

use App\Exceptions\RuntimeException;
use SolveX\Interfaces\RequestInterface as Request;
use DBL;
use Response;

class BasicAuth
{

    protected function checkPermissions($currentRoute, $allowedRoutes)
    {
        if(in_array($currentRoute,$allowedRoutes) === false){
            throw new RuntimeException("Not allowed",405);
        }
    }

    public function authenticate(Request $request)
    {
        if (! $request->hasHeader('authorization')) {
            Response::abort(400, 'Authentication required!');
        }

        $authorization = $request->header('authorization');
        list($username, $token) = explode(':', base64_decode(substr($authorization, 6)));

        $account = DBL::table('_apiAccounts')
                      ->select(['user', 'token', 'allowedRoutes'])
                      ->where('user', $username)
                      ->first();

        if (is_null($account) || $account->token !== $token) {
            Response::abort(400, 'Authentication failed!');
        }

        $allowedRoutes = json_decode($account->allowedRoutes);
        if($allowedRoutes !== null){
            $currentRoute  = $request->getCurrentRoute();
            $this->checkPermissions($currentRoute, $allowedRoutes);
        }
    }
}
