<?php

namespace App\Entities;

class SingleResponse extends Question
{
    protected function __construct($question)
    {
        $this->dataType = 4;
        $this->showAs   = 1;
        $this->openSql  = 1;

        parent::__construct($question);
    }

    public function addAnswerAndGetNewColumns(Answer $answer)
    {
          if($this->addAnswer($answer) === false){
              return false;
          }

          if(count($this->answersArray) == 1){
            return $this->getStructureColumns();
          }

          return [];
    }


    public function removeAnswerAndGetColumnsForDrop($id)
    {
        if($this->removeAnswer($id) === false){
            return false;
        }

        if(count($this->answersArray) == 0){
          return $this->getStructureColumns();
        }

        return [];
    }

    public function getStructureColumns()
    {
          $column = new StructureColumn;

          $column->name = $this->questionName;
          $column->dataType = $this->dataType;

          $structureColumns[] = $column;

          if($this->openAnswers)
          {
              $column = new StructureColumn;

              $column->name = $this->questionName . '_opn';
              $column->dataType = $this->openDataType;

              $structureColumns[] = $column;
          }

          return $structureColumns;
    }
}
