<?php

namespace App\Entities;

use App\Traits\AnswersConvertTrait;

class Question extends BaseEntity
{
    use AnswersConvertTrait;

    public $questionName;

    public $dataType;

    public $openDataType;

    public $answersString;

    public $answersArray;

    public $structureColumns;

    public $openAnswers;

    public $openSql;

    public $showAs;

    public $id;

    public $type;

    public $questionText;

    private $propertiesMapper =
    [
        'q_name'           => 'questionName',
        'variableTypeBase' => 'dataType',
        'variableTypeOpen' => 'openDataType',
        'answersString'    => 'answersString',
        'open_answers'     => 'openAnswers',
        'les_sql'          => 'showAs',
        'id'               => 'id',
        'tip_sql'          => 'type',
        'questionText'     => 'questionText',
    ];

    public static function createQuestion($question)
    {
        switch ($question->tip_sql) {
              case QuestionType::SINGLE_RESPONSE: return new SingleResponse($question);
              case QuestionType::MULTI_RESPONSE:  return new MultiResponse($question);
          }
    }

    protected function __construct($question)
    {
        foreach (get_object_vars($question) as $varName => $varValue) {
            if (!key_exists($varName, $this->propertiesMapper)) {
                continue;
            }

            $localName = $this->propertiesMapper[$varName];
            $this->$localName = $varValue;
        }
    }

    public function getStructureColumns()
    {
        throw new Exception('Not implemented!');
    }

    public function addAnswer(Answer $answer)
    {
        if(!$this->isAnswereUnique($answer)){
          return false;
        }

        $this->answersArray[] = $answer;

        return true;
    }

    public function addAnswerAndGetNewColumns(Answer $answer)
    {
        throw new Exception('Not implemented!');
    }

    public function removeAnswer($id)
    {
        $answerKey = $this->searchAnswersById($id);

        if($answerKey === null){
          return false;
        }

        unset($this->answersArray[$answerKey]);

        return true;
    }

    public function removeAnswerAndGetColumnsForDrop($id)
    {
        throw new Exception('Not implemented!');
    }

    public function isAnswereUnique($answer)
    {
        $key = $this->searchAnswersById($answer->id);
        return $key === null?true:false;
    }

    public function searchAnswersById($id)
    {
        foreach ($this->answersArray as $key => $answer) {
            if ($answer->id === $id) {
                return $key;
            }
        }

        return null;
    }
}
