<?php

namespace App\Controllers\V2;

use App\Http\Request;
use App\Services\ProjectManager\Projects\ExportProjectDataService;
use App\Services\ProjectManager\Projects\ExportTemplateService;
use App\Services\ProjectService;
use App\Exceptions\RuntimeException;

class ExportTemplateDataController
{
    protected $exportProjectService = null;

    protected $exportTemplateService = null;

    protected $projectService = null;

    public function __construct(ExportProjectDataService $exportProjectService,
                                ExportTemplateService $exportTemplateService,
                                ProjectService $projectService)
    {
        $this->exportProjectService  = $exportProjectService;
        $this->exportTemplateService = $exportTemplateService;
        $this->projectService        = $projectService;
    }

    public function getCSV(Request $request, $templateHash)
    {
        $excludedColumns = explode(',', $request->input('excludedColumns',''));

        $onlyValidRecords = filter_var(
            $request->input('onlyValidRecords', false),
            FILTER_VALIDATE_BOOLEAN
        );

        if($onlyValidRecords !== false){
            $this->exportProjectService->validRecordsOnly();
        }

        $template = $this->exportTemplateService->getByHash($templateHash);

        if($this->projectService->projectExists($template->projectId) === false){
            throw new RuntimeException('Project doesn\'t exists!', 400);
        }

        $selectedColumns = $this->exportTemplateService->getStructureColumns($template->variables, $excludedColumns);

        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=project_data.csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        $this->exportProjectService->exportCSV($template->projectId, $selectedColumns);

        exit;
    }
}