<?php

namespace App\Controllers\V1;

use DB;
use App\Services\UniqueLinksService;

class SurveyController
{

    public function __construct(UniqueLinksService $uniqueLinksService)
    {
        $this->uniqueLinksService = $uniqueLinksService;
    }

    /**
    * Retrieves single survey url
    *
    * GET method for REST service - get single survey. The url for user in context of selected
    * survey is generated and saved into DB.
    */
    public function createSurveyLink($userId, $surveyId)
    {
        $webcatiBaseTable = env('DB_WARPIT_WEBCATI_BASE');
        $catiLink = '';
        $projectId = $surveyId;

        $sql = " SELECT loginSID FROM $webcatiBaseTable._www_ids WHERE id_user = ? AND user_type = 2 AND id_project = ?";
        $loginSID = DB::selectOne($sql, [$userId, $projectId]);

        if ($loginSID) {
            $catiLink = $loginSID;
        }
        else {
            $catiLink = substr(md5(time() . $userId . $projectId), 0, 15) . '-';

            $sql = "INSERT INTO $webcatiBaseTable._www_ids
            SET id_user     = ?,
                user_type   = 2,
                id_project  = ?,
                id_site     = 0,
                loginSID    = ?";

            $res = DB::insert($sql, [$userId, $projectId, $catiLink]);
            $lastId = DB::selectOne('SELECT LAST_INSERT_ID()');

            $sql = "UPDATE $webcatiBaseTable._www_ids SET loginSID = CONCAT(loginSID, id) WHERE id = ?";
            DB::update($sql, [$lastId]);

            $catiLink .= $lastId;
        }

        return ['surveyURL' => $catiLink];
    }

    public function createUniqueLink($projectId)
    {
        $link = $this->uniqueLinksService->createUniqueLink($projectId);

        return ['surveyURL' => $link];
    }

    /*
    Get onboarding questionare information
    */
    public function getOnboardingQuestionare($userId){
        $webcatiBaseTable = env('DB_WARPIT_WEBCATI_BASE');
        $onboarding = DB::select("SELECT loginSID, ids.id_project, proj_name as title, id_user, id_site, start_date, end_date as expires, MIN(setPoints) as minPoints, SUM(setPoints) as maxPoints
                               FROM $webcatiBaseTable._www_ids ids
                               LEFT JOIN $webcatiBaseTable._Projects p
                               ON ids.id_project = p.id
                               LEFT JOIN $webcatiBaseTable._wwwPointsStructure ps
                               ON ids.id_project = ps.id_project
                               WHERE onboarding = 1  GROUP BY ids.id_project ORDER BY p.created ASC LIMIT 1");

        //$onboarding = DB::select("SELECT proj_name FROM $webcatiBaseTable._projects WHERE onboarding = 1");
        return ['onboarding' => $onboarding];
    }
}
