<?php
class SampleCalcultor{
    private $variables;
    private $results;
    private $countN;

    function __construct($variables = [], $countN){
        $this->variables = $variables;
        $this->countN = $countN;
    }

    function getResults(){
        return $this->results;
    }

    function getVariables(){
        return $this->variables;
    }

    function calculate(){
        $this->recursiveWalk("", $this->variables[0], array_slice($this->variables, 1));
    }

    private function recursiveWalk($result = "", $currVariable, $otherVariable){
        if($currVariable == null){
            $this->calculateResults($result);
            return $result;
        }

        foreach($currVariable['values'] as $value){
            $this->recursiveWalk(trim($result . "-" . $value, '-'), $otherVariable[0], array_slice($otherVariable, 1));
        }
    }

    private function calculateResults($key){
        $mult = $this->countN;
        $values = explode("-", $key);

        $variablesCount = count($this->variables);
        for($i = 0; $i < $variablesCount; $i++) {
            $multValue = $this->variables[$i]["valueToLimit"][$values[$i]];
            $mult *= floatval(($multValue / 100));
        }

        for($i = 0; $i < $variablesCount; $i++) {
            $this->variables[$i]["countByValue"][$values[$i]] += $mult;
        }

        $this->results[$key] = $mult;
    }
}
?>
