<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT . "init.php");
include_once(PATH_TO_ROOT . "_ajaxManipulators/_class/class.gridData.php");

//ini_set('display_errors',1);

use \App\Support\Filter;

class projectOverview extends GridDataManipulator
{
    protected $db;

    protected function getInvites(array $projectIds, $projectType)
    {
        if(count($projectIds) <= 0){
            return [];
        }

        $sql = "SELECT x.id_project, count(*) as invited FROM (SELECT a.id_project, b.mail_address
                  FROM ". DB_WARPIT_USERSPOOL . "._SendMailSet as a
                  LEFT JOIN ". DB_WARPIT_USERSPOOL . "._MailStatistic as b 
                  ON a.id = b.mail_set
                  AND b.mail_status = 3 
                  AND a.project_type= {$projectType}
                  WHERE id_project IN(" . implode(',', $projectIds) .")
                  GROUP BY b.interviewer_id, a.id_project) as x GROUP BY x.id_project";

        $res = $this->db->SQLexecute($sql);
        $invitedArray = [];
        while($row = $this->db->fetchAssoc($res)){
            $invitedArray[$row['id_project']] = (int)$row['invited'];
        }

        return $invitedArray;
    }

    protected function calculateRow($project, $invites, callable $getCounts)
    {
        $projectId = $project->id;

        $invited     = $invites[$projectId];
        $projName    = $project->proj_name;
        $createdAt   = $project->created;
        $createdBy   = $project->creat_name;
        $projectType = $project->proj_type;

        $counts = call_user_func($getCounts,$projName);

        $started     = $counts['started'];
        $completed   = $counts['completed'];
        $quotaFull   = $counts['quotaFull'];
        $screenedOut = $counts['screenedOut'];


        $responseRate   = ($completed + $quotaFull + $started) / $invited;
        $incidanceRate  = $completed / ($screenedOut + $completed);
        $dropoutRate    = $started / ($screenedOut + $completed);
        $completionRate = $completed / $invited;

        return [
                'project_id'     => $projectId,
                'proj_name'      => $projName,
                'created'        => $createdAt,
                'creat_name'     => $createdBy,
                'invited'        => $invited,
                'completed'      => $completed,
                'quotaFull'      => $quotaFull,
                'started'        => $started,
                'screenedOut'    => $screenedOut,
                'proj_type'      => $projectType,
                'responseRate'   => number_format($responseRate, 2),
                'incidanceRate'  => number_format($incidanceRate, 2),
                'dropoutRate'    => number_format($dropoutRate, 2),
                'completionRate' => number_format($completionRate, 2),
            ];
    }

    protected function getCounts($projectName)
    {
        $sql = "SELECT count(*) as cnt, status, status_rec
              FROM `" . DB_WARPIT_WEBCATI_BASE . "`.`" . $projectName . "_structure`
              GROUP BY status,status_rec";
        $res = $this->db->SQLexecute($sql);

        $dat = [];
        while ($row = $this->db->fetchAssoc($res)) {
            if ($row['status'] === "1" && $row['status_rec'] === "1") {
                $dat['completed'] = intval($row['cnt']);
            } else if ($row['status'] === "51" && $row['status_rec'] === "1") {
                $dat['quotaFull'] = intval($row['cnt']);
            } else if ($row['status'] === null && $row['status_rec'] === null) {
                $dat['started'] = intval($row['cnt']);
            } else if ($row['status'] === "54" && $row['status_rec'] === "1") {
                $dat['screenedOut'] = intval($row['cnt']);
            }
        }

        return $dat;
    }

    protected function getRedirectCounts($projectName)
    {
        $projectId = getRedirectProjectId($projectName);

        $sql = "SELECT id_project, int_finish, count(*) as cnt 
                    FROM " . DB_WARPIT_USERSPOOL . "._RedirectEndLink 
                    WHERE id_project = $projectId
                    GROUP BY id_project, int_finish";
        $res = $this->db->SQLexecute($sql);

        $dat = [];
        while ($row = $this->db->fetchAssoc($res)) {
            if ($row['int_finish'] === "1") {
                $dat['completed'] = intval($row['cnt']);
            } else if ($row['int_finish'] === "51") {
                $dat['quotaFull'] = intval($row['cnt']);
            } else if ($row['int_finish'] === "0") {
                $dat['started'] = intval($row['cnt']);
            } else if ($row['int_finish'] === "54") {
                $dat['screenedOut'] = intval($row['cnt']);
            }
        }

        return $dat;

    }

    protected function returnId($project)
    {
        return $project->id;
    }

    protected function hasInvites($projectId, $invites)
    {
        return key_exists($projectId, $invites);
    }

    protected function getCountFunction($projectType)
    {
        if($projectType === 'Warpit'){
            return 'getCounts';
        }

        return 'getRedirectCounts';
    }

    protected function calculate($projectType, $projects, $invites)
    {
        $function = $this->getCountFunction($projectType);

        $dat = [];
        foreach ($projects as $project){
            $projectId = $project->id;

            if(!$this->hasInvites($projectId,$invites)){
                continue;
            }
            $project->proj_type = $projectType;
            $dat[$projectId] = $this->calculateRow($project,$invites,[$this, $function]);
        }

        return $dat;
    }

    protected function createServices($displayType)
    {
        if($displayType === 1){
            $projectsService = make(App\Services\ProjectManager\Projects\ActiveProjectService::class);
            $redirectService = make(App\Services\PanelManager\RedirectionsManager\ActiveProjectService::class);
        } else {
            $projectsService = make(App\Services\ProjectManager\Projects\ProjectListService::class);
            $redirectService = make(App\Services\PanelManager\RedirectionsManager\ProjectService::class);
        }

        return [$projectsService, $redirectService];
    }

    public function selectAction()
    {
        $searchField = mysql_real_escape_string($_POST['srcquery']);
        $displayType = intval($_POST['displayType']);

        list($catiProjects, $redirectProjects) = $this->createServices($displayType);

        if(strlen($searchField) > 0) {
            $filter = new Filter('proj_name','like',"%{$searchField}%");
            $catiProjects->addOneTimeFilter($filter, 0);

            $filter = new Filter('idLab','like',"%{$searchField}%");
            $redirectProjects->addOneTimeFilter($filter, 0);

        }

        $activeProjects   = $catiProjects->get();
        $redirectProjects = $redirectProjects->get();

        $catiInvites     = $this->getInvites(array_map([$this,'returnId'],$activeProjects), 1);
        $redirectInvites = $this->getInvites(array_map([$this, 'returnId'], $redirectProjects), 2);

        $catiProjects     = $this->calculate('Warpit',$activeProjects,$catiInvites);
        $redirectProjects = $this->calculate('Redirect',$redirectProjects, $redirectInvites);

        $dat = array_merge(array_values($catiProjects), array_values($redirectProjects));

        $data['success'] = TRUE;
        $data['results'] = count($dat);
        $data['rows']    = $dat ? $dat : [];

        echo json_encode($data);
    }

}

$db->ChangeDatabase($_POST['database']);

$tableName = $_POST['RMtable'];

$manipulator = new projectOverview($db, $_POST['RMtable']);

$manipulator->tableAddon = $tableAddon;
$comm = $_REQUEST['action'] . 'Action';
if (method_exists($manipulator, $comm))
    echo $manipulator->$comm();
else {
    echo '{success:false,error:"Unknown action!"}';
}


?>
