<?php

class Installer
{
    private $db;
    
    private $plugin_table;
    
    private $plugin_name;
    
    private $plugin_path;
    
    private $property_list;
    
    private $table;
    
    private $errors;
    
    private $install_path;
    
    public function __construct($db, $path)
    {
        $this->db = $db;
        $this->plugin_table = "_Plugin";
        $this->plugin_name = 'Multi response with additional text';
        $this->plugin_path = 'multiresponse_with_text';
        
        $this->install_path = $path;
        
        $this->errors = array();
    }
    
    public function install()
    {
        $this->init();
        if(!$this->pluginExsist())
        {
            $this->createDatabase();
            
            return TRUE;
        }
        else
        {
            $this->errors[] = "Plugin name already exist in database!";
            return FALSE;
        }
    }
    
    public function getErrors()
    {
        return $this->errors;
    }
    
    
    private function pluginExsist()
    {
       $sql  = "SELECT plugin_name FROM ". DB_WARPIT_WEBCATI_BASE. "." . $this->plugin_table .  "  
            WHERE plugin_path = '" . $this->plugin_name ."'";
            
            
       $res= $this->db->SQLexecute($sql);
       if($this->db->NumRows($res) > 0)
       {
           return TRUE;
       }
       return FALSE;
        
    }
    
    private function init()
    {
        $this->property_list = array(
            //array('name', 'label', 'type', 'default_value'),
            array('button_image_clicked', 'Button clicked image', 'string', ''),
            array('button_color_normal', 'Button color normal', 'string', ''),
            array('answer_box_width', 'Answer box width', 'string', ''),
            array('button_height', 'Button height', 'string', ''),
            array('button_width', 'Button width', 'string', ''),
            array('button_image_normal', 'Button image normal', 'string', ''),
            array('answer_box_height', 'Answer box height', 'string', ''),
        );
        
    }
    
    private function createDatabase()
    {
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "." . $this->plugin_table . " SET 
            plugin_name = '" . $this->plugin_name ."', plugin_path = '" . $this->plugin_path . "'
        ";
        
        $this->db->SQLexecute($sql);
        $plugin_id = $this->db->GetLastInsertId();
      
        $sql = file_get_contents($this->install_path . "/install/sql/database.sql");
        $this->db->SQLexecute($sql);
      
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . "._Plugin_label (name, label, type, default_value, id_plugin) VALUES ";
        $tmpSql = array();
        foreach($this->property_list as $property)
        {
            $tmp = implode("', '", $property);
            $tmpSql[] = "('" . $tmp  ."', " .  $plugin_id .")";
        }
        
        $sql .= implode(",", $tmpSql);
        $this->db->SQLexecute($sql); 
    }
}
?>