<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."_class/class.Extjs_grid.php");

$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);
if(isset($_POST["selected_folder_id"]))
{
    $nodeId = $_POST["selected_folder_id"];
    $sql = "SELECT a.id_project, b.proj_name, b.id_telname  FROM _ProjectsTree as a LEFT JOIN _Projects b ON a.id_project = b.id WHERE a.id_sup = $nodeId";
}
else
{
    $projectIds = $_POST["projectIds"];
    $sql = "SELECT id as id_project, proj_name, id_telname FROM _Projects WHERE id IN($projectIds)";
}

$res = $db->SQLexecute($sql);
$projects = Array();
$projectNames = Array();
while($project = $db->fetchAssoc($res))
{
    if(!is_null($project["id_telname"]))
    {
        $projects[] = $project;
        $projectNames[] = $project["proj_name"];
    }
}
$tabTitle = "";
if(isset($_POST["selected_folder_id"]))
{
    $tabTitle = $_POST["selected_folder_text"];
}
else
{
    $tabTitle = implode(",", $projectNames);
}

if(count($projects) < 1)
{
    echo "Ext.Msg.alert('Error','Non of project has telephone table attached!');
	removeSession('$tabId')";
    exit;
}

$tabId = $_POST['uniqueTabId'];

$grid = new MakeGrid( 'grid_'.$tabId );
$gridName = $grid->getName();

$grid->setDatabase(DB_WARPIT_WEBCATI_BASE)->setMainTable("noNametable")->setTitle('Sample statistics')->dateSQL = 'U';
$grid->setReqUrl("webcati/_ajax/telNumberManagment/ajax.sampleStatistics.php");
$grid->baseParams("
	action: 'select',
	projects:'" . json_encode($projectNames) . "'
");


$grid->addColumn('status','ID status')->width(80);
$grid->addColumn('status_rec','ID rec status')->width(80);
$grid->addColumn('status_name','Call status')->width(300);

$grid->addColumn("total_count","Total")->setProperty("css", "'background-color: #00222222;'");
foreach ($projects as $project)
{
    $projectName = $project["proj_name"];
    $grid->addColumn("total_count_$projectName","Total $projectName");//->width(60);
}


$grid->setSortable(false)->region('center')
    ->addTbarItem("{iconCls:'x-tbar-loading',handler:function(){ $grid.getStore().reload(); }}")
    ->addTbarItem("{text:'Recode status',handler:function(){
		 CallScript('webcati/_forms/telNumberManagment/window.GroupStatuses.php', {mainGrid:$gridName.id});
	 }}");

$grid->addExportButton();
echo $grid->createGrid();

echo "
mainTabPanel.add({
id: '$tabId',
iconCls:'RMicon_sample_statistics',
layout:'border',
title: 'Sample statistics - $tabTitle',
closable: true,
items:[$gridName]

 })";
if(!$_POST['uniqueNotShow'])
    echo  ".show();";
?>
