<?php
//ini_set('display_errors', 1);
include_once('_dirinfo.php');
include_once(PATH_TO_ROOT . 'init.php');
include_once(PATH_TO_ROOT . 'config.php');

/*

Check if server.php is running with something like:
# ps -ef | grep php
apache     527     1  0 10:27 ?        00:00:00 php /var/www/html/warpitDevelopment/webcati/_forms/websockets/server.php
root       530 32318  0 10:28 pts/0    00:00:00 grep --color=auto php

# ls ./tmp/
log  pid

To stop server:
# kill -9 $(cat ./tmp/pid)

*/

$config = ConfigLoader::loadConfig('live_watch');
$websocketsServerAddress = $config['websockets_server_address'];
$showLog = ($config['show_log'] == 1) ? 1 : 0;
$serverPhp = $config['server_php'];
$tmpPath = $config['tmp_path'];
$pidFile = $tmpPath . 'pid';
$logFile = $tmpPath . 'log';

function isProcessRunning($pidFile) {
    // http://stackoverflow.com/questions/3111406/checking-if-process-still-running
    if (! file_exists($pidFile) || ! is_file($pidFile))
        return false;
    $pid = file_get_contents($pidFile);

    // Signal 0 does not actually get sent, but checks to see
    // if it is possible to send the signal.
    $running = posix_kill($pid, 0);

    // Check if not running, but pid file exists.
    // This means e.g. kill -9 process_id
    // was done, but pid file was not removed,
    // or the process crashed. In this case, we remove
    // the invalid pid file.
    if (! $running)
        unlink($pidFile);

    return $running;
}

$isServerStarting = false;

if (! isProcessRunning($pidFile)) {
    // nohup => don't kill the process on logout (ignore HUP hangup signal)
    // We need to redirect output to run this process in the background (otherwise
    // PHP waits for completion).
    exec('nohup php ' . $serverPhp . ' >>' . $logFile . ' 2>&1 &');
    $isServerStarting = true;
}


$projectTitle = $_POST['projectTitle'];
$questionnaireId = $_POST['projectId'];
$tabId = $_POST['uniqueTabId'];

$subscriberId = uniqid(); // Each tab has unique id.
$_SESSION['live_watch_subscriber_id'] = $subscriberId; // Store in session, check for it in server.php!
$sessionId = session_id();


// Create a list of clients for this questionnaire ("project").
// This list will be passed to an Ext.data.Store
$sql = "SELECT a.*,
               b.*,
               c.proj_name
        FROM ". DB_WARPIT_WEBCATI_BASE ."._www_ids a
        INNER JOIN " . DB_WARPIT_WEBCATI_BASE . "._Projects c ON a.id_project = c.id
        INNER JOIN (SELECT id AS origId,username,Firstname,Surname,email,0 AS id_type FROM " . DB_WARPIT_WEBCATI_BASE . ".`_Interviewer`
              UNION SELECT id AS origId,username,Firstname,Surname,email,1 AS id_type FROM " . DB_WARPIT_MAIN . "._user) b
            ON a.id_user = b.origId AND a.user_type = b.id_type
        WHERE a.id_project = $questionnaireId";

$clients = [];
$res = $db->SQLexecute($sql);
while ($row = $db->fetchAssoc($res)) {
    $userId = $row['origId'];
    $userType = $row['id_type'];
    // user ids are not unique themselves, need to include user_type!
    $clientId = $userType . '_' . $userId;
    $clients[] = "['$clientId', '{$row['username']}', 3]";
}

$clientListData = '[' . implode(',', $clients) . ']';
?>


(function() { // IIFE

var websocketsServerAddress = '<?php echo $websocketsServerAddress; ?>';
var questionnaireId = '<?php echo $questionnaireId; ?>';
var subscriberId = '<?php echo $subscriberId; ?>';
var sessionId = '<?php echo $sessionId; ?>';
var isServerStarting = <?php echo($isServerStarting ? 'true' : 'false'); ?>;

var tabId = '<?php echo $tabId; ?>';
// ExtJS ids, we want to be able to have multiple Live watches (tabs).
// Need to have unique ids.
var watchPanelId = 'watchpanel<?php echo $subscriberId; ?>';
var clientListId = 'clientList<?php echo $tabId; ?>';
var tabPanelId = 'tab_<?php echo $tabId; ?>';
var tabPanelTitle = 'Watch - <?php echo $projectTitle ?>';

// Client status.
var CLIENT_LOGGED_IN = 1;
var CLIENT_ACTIVE = 2;
var CLIENT_LOGGED_OUT = 3;

var flagTabClosing = false;
var flagConnected = false;

// Client list window setup (Ext.Window with GridPanel)

var clientListStore = new Ext.data.Store({
    reader: new Ext.data.ArrayReader({idIndex: 0}, Ext.data.Record.create([
        {name: 'id'},
        {name: 'name'},
        {name: 'status'},
        {name: 'ip_address'},
        {name: 'question'},
        {name: 'surveyStart'},
        {name: 'duration'},
        {name: 'isClosed'}
    ])),
    data: <?php echo $clientListData; ?>
});


function getStyle(record) {
    var status = record.get('status');
    var style = '';
    switch (status) {
        case CLIENT_LOGGED_IN:  style = 'color:blue'; break;
        case CLIENT_LOGGED_OUT: style = 'color:gray';    break;
        case CLIENT_ACTIVE:     style = 'color:green';  break;
    }

    return style;
}

function columnRenderer(val, md, record) {
    return '<span style="' + getStyle(record) + '">' + val + '</span>';
}

function statusRenderer(val, md, record) {
    var status = record.get('status');
    switch (status) {
        case CLIENT_LOGGED_IN:  status = 'Logged-in';  break;
        case CLIENT_LOGGED_OUT: status = 'Logged-out'; break;
        case CLIENT_ACTIVE:     status = 'Active';     break;
    };
    return '<span style="' + getStyle(record) + '">' + status + '</span>';
}

var clientListGrid = new Ext.grid.GridPanel({
    store: clientListStore,
    tbar: new Ext.Toolbar(),
    colModel: new Ext.grid.ColumnModel({
        columns: [
            {header: 'ID',       dataIndex: 'id',     renderer: columnRenderer, width: 20},
            {header: 'Username', dataIndex: 'name',   renderer: columnRenderer},
            {header: 'Status',   dataIndex: 'status', renderer: statusRenderer},
            {header: 'Ip address',   dataIndex: 'ip_address'},
            {header: 'Question',   dataIndex: 'question'},
            {header: 'Duration',   dataIndex: 'duration'}
        ]
    }),
    viewConfig: {
        forceFit: true,
    },
    sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
    frame: false,
    multiColumnSort:true,
    region: 'center',
    viewConfig: {
        markDirty: false
    },
    plugins:[
        new Ext.ux.grid.Search({searchText:'Search',  minChars:0,position:'top',mode:'local',disableIndexes:['id', 'status'], indexPos:4 , ref: 'searchField'})
    ],
    listeners: {
        cellClick: function(grid, rowIndex) {
            if (! flagConnected) {
                Ext.Msg.alert('Error', 'Not connected to the WebSocket server!');
                return;
            }

            var record = grid.getStore().getAt(rowIndex);
            var clientId = record.get('id');

            var status = record.get('status');
            if (status !== CLIENT_ACTIVE) {
                Ext.Msg.alert('Note', 'Client not active!');
                return;
            }

            bringToFront(clientId);
        }
    }
});

function bringToFront(clientId) {

    // Count shown windows, ensure there are always less than 6.
    var numShownWindows = 0;
    $.each(clientContentPanels, function(_, panel) {
        var win = panel.ownerCt;
        if (win !== undefined && ! win.hidden)
            numShownWindows += 1;
    });

    if (numShownWindows < 6) {
        // New client => we need a new window.
        //
        var win = new Ext.Window({
            title: 'clientId: ' + clientId,
            renderTo: watchPanelId,
            closeAction: 'close',
            constrain: true,
            layout: 'fit',
            width: 500,
            height: 400,
            tbar: new Ext.Toolbar({
                items:[
                    new Ext.form.Label({
                        id: clientId + tabId + '_ip_label',
                        text: 'Client ip: ' /*+ clientIp*/
                    }),
                    {xtype: 'tbspacer', width: 10},
                    new Ext.form.Label({
                        id: clientId + tabId + '_question_label',
                        text: 'Question name: ' /*+ questionName*/
                    }),
                    {xtype: 'tbspacer', width: 10},
                    new Ext.form.Label({
                        id: clientId + tabId + '_timer',
                        text: 'Durnation: 00:00:00'
                    }),
                ]
            }),
            listeners: {
                close: function(){
                    delete clientContentPanels[clientId];
                }
            },
            items: [{html: 'Waiting for intitalization'}],
            buttons: [],
        });
        watchPanel.insert(0, win);
        win.show();
            
        // Remember this window (one window per client).
        clientContentPanels[clientId] = win.items.get(0);
      
        Ext.WindowMgr.bringToFront(win);
    }
    else
        Ext.Msg.alert('Note', 'Reached limit of 6 windows!');
}

var clientListWindow = new Ext.Window({
    title: 'Clients',
    id : clientListId,
    autoShow: true,
    constrain: true,
    layout: 'fit',
    width: 550,
    height: 500,
	minimizable: true,
    items: [clientListGrid],
    buttons: [],
	listeners: {
        minimize: function(){
			MinimizeWindow(this, Ext.getCmp(watchPanelId));
        }
    }
});

// A container for client windows (Ext.Window)
var watchPanel = new Ext.Panel({
    id: watchPanelId,
    items: [clientListWindow]
});

// Added to main tab panel
var tabPanel = new Ext.Panel({
    id: tabPanelId,
    title: tabPanelTitle,
    defaults: {
        split: true,
        border: false
    },
    iconCls: 'RMicon_layout_doc',
    layout: 'fit',
    border: false,
    closable: true,
    items: [watchPanel],
    timeNow: Math.floor(Date.now() / 1000),
    listeners: {
        destroy: function() {
            // Close this WebSocket connection when tab is closed.
            flagTabClosing = true;
            if (ws)
                ws.close();

            if(tabPanel.runner)
                tabPanel.runner.stop(tabPanel.task);
        },

    }
    // TODO: how to handle reopen?
});

// A map from client IDs to HTML panel inside Ext.Windows.
// One window for each client.
var clientContentPanels = {};

// See also server.php
var ws = null;

function setupWebSocketConnection() {
    ws = new WebSocket(websocketsServerAddress);

    ws.onopen = function(evt) {
        // As soon as the WebSocket connection is ready,
        // admin subscribes to events for specific *questionnaire*
        var message = {
            type: 'subscribe',
            subscriber_id: subscriberId,
            questionnaire_id: questionnaireId,
            session_id: sessionId // PHP session id, cookies are not sent!
        };

        ws.send(JSON.stringify(message));

        flagConnected = true;
    };

    ws.onmessage = function(evt) {
        var message = JSON.parse(evt.data);
        if(<?php echo $showLog;?>)
        {
            console.log(message);
        }


        switch (message.type) {
        case 'client_login'        : handleClientLogin(message);       break;
        case 'client_setup'        : handleClientSetup(message);       break;
        case 'client_event'        : handleClientEvent(message);       break;
        case 'client_closed'       : handleClientClosed(message);      break;
        default:
            if(<?php echo $showLog;?>)
            {
                console.log('Warning: unknown message type received!');
            }
        }
    };

    ws.onclose = function(event) {
        if (! flagTabClosing)
            Ext.Msg.alert('Note', 'WebSocket connection closed!');

        flagConnected = false;

        event = event;
        if (event.code == 1000)
            reason = 'Normal closure, meaning that the purpose for which the connection was established has been fulfilled.';
        else if(event.code == 1001)
            reason = 'An endpoint is \"going away\", such as a server going down or a browser having navigated away from a page.';
        else if(event.code == 1002)
            reason = 'An endpoint is terminating the connection due to a protocol error';
        else if(event.code == 1003)
            reason = 'An endpoint is terminating the connection because it has received a type of data it cannot accept (e.g., an endpoint that understands only text data MAY send this if it receives a binary message).';
        else if(event.code == 1004)
            reason = 'Reserved. The specific meaning might be defined in the future.';
        else if(event.code == 1005)
            reason = 'No status code was actually present.';
        else if(event.code == 1006)
           reason = 'The connection was closed abnormally, e.g., without sending or receiving a Close control frame';
        else if(event.code == 1007)
            reason = 'An endpoint is terminating the connection because it has received data within a message that was not consistent with the type of the message (e.g., non-UTF-8 [http://tools.ietf.org/html/rfc3629] data within a text message).';
        else if(event.code == 1008)
            reason = 'An endpoint is terminating the connection because it has received a message that \"violates its policy\". This reason is given either if there is no other sutible reason, or if there is a need to hide specific details about the policy.';
        else if(event.code == 1009)
           reason = 'An endpoint is terminating the connection because it has received a message that is too big for it to process.';
        else if(event.code == 1010) // Note that this status code is not used by the server, because it can fail the WebSocket handshake instead.
            reason = 'An endpoint (client) is terminating the connection because it has expected the server to negotiate one or more extension, but the server didnt return them in the response message of the WebSocket handshake. <br /> Specifically, the extensions that are needed are: ' + event.reason;
        else if(event.code == 1011)
            reason = 'A server is terminating the connection because it encountered an unexpected condition that prevented it from fulfilling the request.';
        else if(event.code == 1015)
            reason = 'The connection was closed due to a failure to perform a TLS handshake (e.g., the server certificate cant be verified).';
        else
            reason = 'Unknown reason';

        if(<?php echo $showLog; ?>)
        {
            console.log('Connection closed: ' + reason);
        }
        // TODO: maybe try to re-connect regularly?
    };

    ws.onerror = function() {
        if(<?php echo $showLog;?>)
        {
            console.log('WebSocket error');
        }
        flagConnected = false;
    };

    ws.onsend = function(evt) {
    };
}

function handleClientLogin(message) {
    // Client has logged-in, but is not yet doing the questionnaire (not yet active).

    var clientId = message.client_id;
    var clientIp = message.client_ip;
    var questionName = message.question_name;

    var record = clientListStore.getById(clientId);
    if (record !== undefined){
        record.set('status', CLIENT_LOGGED_IN);
        record.set('question', questionName);
        record.set('ip_address', clientIp);
        clientListStore.multiSort( [{field : 'status', direction : 'ASC'}, {field : 'name', direction : 'ASC'}] );
    }


    if (clientContentPanels[clientId] !== undefined) {
        var clientContentPanel = clientContentPanels[clientId];
        clientContentPanel.body.update(''); // Clear window.
    }
}

function handleClientClosed(message) {
    var clientId = message.client_id;

    var record = clientListStore.getById(clientId);
    if (record !== undefined){
        record.set('isClosed', true);

        var delay = 2 * 1000; // 2000ms = 2s
        var taskArgs = {clientId: clientId};
        var delayTask = new Ext.util.DelayedTask(
            function(){
                var record = clientListStore.getById(clientId);
                if (record !== undefined){
                    var isClosed = record.get('isClosed');
                    if(isClosed){
                        record.set('surveyStart', '');
                        record.set('ip_address', '');
                        record.set('question', '');
                        record.set('duration', '');
                        record.set('status', CLIENT_LOGGED_OUT);
                    }
                }
            },
            taskArgs
        );
        delayTask.delay(delay);
    }

}

function handleClientEvent(message) {
    var clientId = message.client_id;
    var clientIp = message.client_ip;
    var questionName = message.question_name;
    var timeNow = tabPanel.timeNow;

    var record = clientListStore.getById(clientId);
    if (record !== undefined){
        record.set('status', CLIENT_ACTIVE);
        record.set('question', questionName);
        record.set('ip_address', clientIp);
        if(record.get('surveyStart') == ''){
            record.set('surveyStart', timeNow);
            record.set('isClosed', false);
        }
        clientListStore.multiSort( [{field : 'status', direction : 'ASC'}, {field : 'name', direction : 'ASC'}] );
    }


    var clientContentPanel = clientContentPanels[clientId];
    if (clientContentPanel === undefined) // Events received before client_setup!
        return;

    var objName = message.event.objName;
    var objValue = message.event.objValue;
    if (message.event.eventType == '1' && message.event.objType == 'radio') {
        // Radio button was selected.
        // Replicate the selection here.
        // Color the background to make the change more visible.
        $(clientContentPanel.body.dom).find('input[name="' + objName + '"]')
                                      .parent()
                                      .css('background-color', 'white');
        $(clientContentPanel.body.dom).find('input[name="' + objName + '"][value="' + objValue + '"]')
                                      .prop('checked', true)
                                      .parent().css('background-color', 'red');
    }
    else if (message.event.eventType == '1' && message.event.objType == 'checkbox') {
        // Checkbox checked.
        var checked = (message.event.checked == 'true');
        $(clientContentPanel.body.dom).find('input[name="' + objName + '"][value="' + objValue + '"]')
                                      .prop('checked', checked)
                                      .parent().css('background-color', 'red');
    }
    else if (message.event.eventType == 'input') {
        // Input text box change.
        var id = message.event.id;
        var val = message.event.value;
        $(clientContentPanel.body.dom).find('#' + id)
                                      .val(val);
        if(id){
            var idParts = id.split('_');
            var chkName = 'answers[' + idParts[1] + '_' + idParts[2] + ']';
            var chkId = 'ct_' + idParts[1] + '_' + idParts[2];
            var chkValue = idParts[2];

            if($(clientContentPanel.body.dom).find('input[name="' + chkName + '"][value="' + chkValue + '"][type="checkbox"]').length > 0 ){
              var chkMessage = {};
              chkMessage.client_id = clientId;
              chkMessage.question_name = questionName;
              chkMessage.event = {
                  checked   : 'true',
                  eventType : 1,
                  objName   : chkName,
                  objType   : 'checkbox',
                  objValue  : chkValue
              };

              handleClientEvent(chkMessage);
            }
        }


    }
    else if (message.event.eventType == 'textarea') {
        // textarea text box change.
        var id = message.event.id;
        var val = message.event.value;
        $(clientContentPanel.body.dom).find('#' + id)
                                      .val(val);

        if(id){
            var idParts = id.split('_');

            var chkName = 'answers[' + idParts[1] + '_' + idParts[2] + ']';
            var chkId = 'ct_' + idParts[1] + '_' + idParts[2];
            var chkValue = idParts[2];

            if($(clientContentPanel.body.dom).find('input[name="' + chkName + '"][value="' + chkValue + '"][type="checkbox"]').length > 0 ){
                var chkMessage = {};
                chkMessage.client_id = clientId;
                chkMessage.question_name = questionName;
                chkMessage.event = {
                    checked   : 'true',
                    eventType : 1,
                    objName   : chkName,
                    objType   : 'checkbox',
                    objValue  : chkValue
                };

                handleClientEvent(chkMessage);
            }
        }
    }

    var questionLabel = Ext.getCmp(clientId + tabId +'_question_label');
    if(questionLabel){
        questionLabel.setText('Question name: ' + questionName);
    }


    // TODO: other events?
}

function prepareClientHtml(html) {
    // Path fix for images (not sure this is always correct).
    // Removal of iframes.
    // Wrapping everything with scrollbars if needed, applying
    // a small zoom-out.

    html = html.replace(/..\/_img/g, '_img');
    html = html.replace(/<iframe.*?\/iframe>/ig, '');
    return '<div style="overflow:auto; width:100%; height:100%;">' +
               '<div style="transform: scale(0.95);">' +
                   html +
        '</div></div>';
}

function removeUnneededFromDom(node) {
    // Disable inputs (checkboxes etc), we're only watching.
    // Also remove buttons and other clutter.
    //
    // TODO: some of this trimming is not needed anymore, because it's
    // already done before sending the html over.

    node.find('input, select, textarea')
        .prop('disabled', true)
        .prop('readonly', true);

    // Questionnaires can have custom checkboxes and radio buttons (images instead of default GUI elements).
    // This is implemented by hiding <input> and appending an <img> with id starting with "img_".
    // We'll try to find these custom elements and de-customify them (removing imgs, unhiding inputs).
    node.find('input').each(function(_, input) {
        input = $(input);
        var next = input.next();
        if (next.is('img[id^="img_"]')) {
            next.hide();
            input.show();
        }
    });

    $('#datetimepickerHolder').parent().remove();

    node.find('input[type="submit"], input[type="button"]').remove();

    node.find('input[type="checkbox"][name="gotoIdle"]').parent().remove();

    node.find('select[name="languageChooser"]').parent().remove();

    node.find('iframe').remove();
}

function handleClientSetup(message) {
    var clientId = message.client_id;
    var clientIp = message.client_ip;
    var questionName = message.question_name;
    var surveyStart =  message.start_survey;
    var timeNow = tabPanel.timeNow;

    var record = clientListStore.getById(clientId);
    if (record !== undefined){
        record.set('status', CLIENT_ACTIVE);
        record.set('question', questionName);
        record.set('ip_address', clientIp);
        record.set('isClosed', false);
        if(questionName == 'tStatus'){
            record.set('surveyStart', timeNow);
        }
        clientListStore.multiSort( [{field : 'status', direction : 'ASC'}, {field : 'name', direction : 'ASC'}] );
    }
    
    
    //if client doesn't exists we ignor message
    if (clientContentPanels[clientId] !== undefined) {
        // This is not the first time this client was "setup".
        // Every time a client goes forwards or backwards, we re-send the entire questionnaire HTML.

        var questionLabel = Ext.getCmp(clientId + tabId + '_question_label');
        if(questionLabel){
            questionLabel.setText('Question name: ' + questionName);
        }
        
        var ipLabel = Ext.getCmp(clientId + tabId + '_ip_label');
        if(ipLabel){
            ipLabel.setText('Client ip:	' + clientIp);
        }

        var clientContentPanel = clientContentPanels[clientId];
        clientContentPanel.body.update(prepareClientHtml(message.html));
        removeUnneededFromDom($(clientContentPanel.body.dom));
        return;
    }
}

function updateDurationField(){
    tabPanel.timeNow += 1;
    var allRecords = clientListStore.getRange();
    allRecords.forEach(function(record, index, array){
        var surveyStart = parseInt(record.get('surveyStart'));
        var clientId = record.get('id');
        if(Number.isInteger(surveyStart) && surveyStart > 0){
            var elapsed = tabPanel.timeNow - surveyStart;
            var date = new Date(1970,0,1);
            date.setSeconds(elapsed);

            var timeString = date.format('H:i:s');
            record.set('duration', timeString);
            var timerLabel = Ext.getCmp(clientId + tabId + '_timer');
            if(timerLabel){
                timerLabel.setText('Durnation: ' + timeString);
            }
        }
    });
}

tabPanel.task = {
    run: updateDurationField,
    interval: 1000 //1 second
};
tabPanel.runner = new Ext.util.TaskRunner();
tabPanel.runner.start(tabPanel.task);

mainTabPanel.add(tabPanel).show();
clientListWindow.show();

if (isServerStarting) {
    Ext.Msg.alert('Note', 'Waiting for WebSocket server to start...');
    Ext.defer(function() {
        Ext.MessageBox.hide();
        setupWebSocketConnection();
    }, 3000);
}
else
    setupWebSocketConnection();

})();
