<?php
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT."init.php");
include_once(PATH_TO_ROOT."webcati/_class/class.quotas.php");

class QuotaCellImportExport{
    private $db;
    private $quotaManager;

    private $projectId;
    private $projectName;

    private $importData;
    private $importErrors;
    private $allColumns;
    private $ids;

    function __construct($db, $quotaManager, $projectId, $projectName){
        $this->db           = $db;
        $this->projectId    = $projectId;
        $this->importData   = [];
        $this->projectName  = $projectName;
        $this->quotaManager = $quotaManager;
    }

    function export($data, $encoding = 'UTF-8'){
        header( "Content-Type: text/csv; charset=$encoding");
        header( "Content-Disposition: attachment; filename=\"". $this->projectName . "_quota_cell_layers.csv\";" );

        $fp = fopen('php://temp', 'w');

        foreach ($data as $row) {
            $line = [$row['cell'], $row['quota']];
            fputcsv($fp, $line, ';');
        }

        rewind($fp);
        echo stream_get_contents($fp);
        fclose($fp);
    }

    function import($file){
        $this->readCSV($file);
        $this->getIdsArray();

        if(!$this->isImportValid()){
            echo json_encode(['success' => false, 'errors' => $this->importErrors]);
            return;
        }

        $this->clearQuotaData();
        $this->insertLayers();
        $this->insertCells();

        echo json_encode(['success' => true]);
        return;
    }

    function readCSV($file){
        $uploadFile = fopen($file['podatki']['tmp_name']['importData'], 'r');
        while($row = fgetcsv($uploadFile, 0, ';', '"')){
            $splitedCondition = explode('and', $row[0]);
            $lineConditions = [];
            foreach($splitedCondition as $condition){
                $condition = trim($condition);
                $columnAndValue = explode('=', $condition);
                $lineConditions[ trim($columnAndValue[0]) ] = trim($columnAndValue[1]);
            }

            $this->importData[] = [
                'quota' => $row[1],
                'conditions' => $lineConditions
            ];
        }
        fclose($uploadFile);
    }

    function getIdsArray(){
        $this->ids = [];
        foreach ($this->quotaManager->tel_quest_names as $quotaField) {
            $this->ids[$quotaField['name']] = $quotaField['id_s'];
        }
    }

    function isImportValid(){
        $this->importErrors = [];
        $docLine = 0;
        foreach ($this->importData as $quotaCell) {
            $docLine++;
            foreach($quotaCell['conditions'] as $columnName => $value){
                $this->quotaManager->get_recoded_values($this->ids[$columnName]);
                if(count($this->quotaManager->recoded_values) == 0){
                    $this->importErrors[] = "Field " . $columnName . " is not recoded, please recode it and try again. (Document line $docLine)";
                }
                else {
                    $recodeValueExists = false;
                    foreach ($this->quotaManager->recoded_values as $recode_value) {
                        if($recode_value['reconum'] == $value){
                            $recodeValueExists = true;
                            break;
                        }
                    }
                    if(!$recodeValueExists){
                        $this->importErrors[] = "Recode value " . $value . " ($columnName) is not in recoded values. (Document row $docLine)";
                    }
                }
            }
        }

        return count($this->importErrors) == 0;
    }

    function clearQuotaData(){
        $layers = [];
        $sql = "SELECT layer FROM " . DB_WARPIT_WEBCATI_BASE . ".quota_layer WHERE id_project = " . $this->projectId . " GROUP BY layer";
        $res = $this->db->SQLexecute($sql);
        while($row = $this->db->fetchAssoc($res)){
            $this->quotaManager->delete_quota_layer($row['layer']);
        }
    }

    function insertLayers(){
        $newLayerAdded = true;
        foreach ($this->importData as &$quotaCell) {
            if($newLayerAdded){
                $this->quotaManager->select_quota_layer();
                $newLayerAdded = false;
            }

            $working_layer = $quotaCell['conditions'];
            $working_variables = array_keys($working_layer);

            sort($working_variables);
            $layer_data = [];
            foreach ($quotaCell['conditions'] as $quotaField => $value) {
                $layer_data[] = $this->ids[$quotaField];
            }

            $layer_exists = false;
            $id_layer = 0;
            foreach($this->quotaManager->quota_layers as $layer)
            {
                $layer_names_array = explode(',', $layer['names']);
                sort($layer_names_array);

                if($working_variables == $layer_names_array)
                {
                    $layer_exists = true;
                    $id_layer = $layer['id'];
                    break;
                }
            }

            if(!$layer_exists){
                 $this->quotaManager->add_quota_layer($layer_data);
                 $id_layer = $this->quotaManager->get_inserted_layer_id();
                 $newLayerAdded = true;
            }

            $quotaCell['id_layer'] = $id_layer;
        }
    }

    function getColumnPrefix($source){
        $prefix = 'TP_';
        if($source == 2){
            $prefix = 'QT_';
        }
        return $prefix;
    }

    function getAllColumns(){
        $this->allColumns = [];
        foreach($this->importData as $lineData){
            foreach($lineData['conditions'] as $columnName => $value){
                $source = end(explode('_', $this->ids[$columnName]));
                $prefix = $this->getColumnPrefix($source);

                $fullColumnName = $prefix . $columnName;
                if(!array_key_exists($fullColumnName, $this->allColumns)){
                    $this->allColumns[$fullColumnName] = count($this->allColumns);
                }
            }
        }

        return $this->allColumns;
    }

    function insertCells(){
        $limitsColumns = $this->getAllColumns();
        $rows = [];
        foreach ($this->importData as $quotaCell) {
            $row = array_fill(0, count($limitsColumns), 'null');

            foreach($quotaCell['conditions'] as $columnName => $value){
                $source = end(explode('_', $this->ids[$columnName]));
                $prefix = $this->getColumnPrefix($source);

                $row[$limitsColumns[$prefix . $columnName]] = $value;
            }

            $row[] = $quotaCell['id_layer'];
            $row[] = $quotaCell['quota'];
            $rows[] =  "(" . implode(',', $row)  . ")";
        }


        $quota_limits_table = $this->projectName . "___quotaLimits";
        $sql = "INSERT INTO " . DB_WARPIT_WEBCATI_BASE . ".$quota_limits_table
                (" .implode(',', array_keys($limitsColumns)). ", id_layer, q_value) VALUES " . implode(',', $rows)  . "";

        $this->db->SQLexecute($sql);
    }

}

$action     = $_POST['action'];
$db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);

$quotaManager = new quotes($_POST['id_project'], $db);
$importExportManager = new QuotaCellImportExport($db, $quotaManager, $_POST['id_project'], $_POST['proj_name']);

if($action == 'import'){
    $importExportManager->import($_FILES);
}
else if($action == 'export'){

    $_POST['action'] = 'list_cells';

    //we call ajax.cell-quotas with output buffer
    ob_start();
    include_once(PATH_TO_ROOT."webcati/_forms/_ajax/ajax.cell-quotas.php");
    $response = json_decode(ob_get_contents(), TRUE);
    $rows = $response['rows'];
    ob_end_clean();

    $exportOption = configLoader::loadConfig('export_option');
    $encoding = $exportOption['cp_default'];

    $importExportManager->export($rows, $encoding);
}



?>
