<?php

interface iNode
{
    public function addChild(iNode $child);

    public function setTotal($total);
}

class Matrix
{
    private static $instance = null;

    private $data;

    private $userData;

    private $regionData;

    public static function getInstance()
    {
        if(is_null(Matrix::$instance)){
          Matrix::$instance = new Matrix();
        }

        return Matrix::$instance;
    }

    public function set($key, $val)
    {
        if(array_key_exists($key, $this->data))
        {
          $this->data[$key] += $val;
        }
        else
        {
          $this->data[$key] = $val;
        }
    }

    public function get($key = null)
    {
      if(!is_null($key))
        return  $this->data[$key];

      return $this->data;
    }

    public function setUser($user_id, $val)
    {
        if(array_key_exists($user_id, $this->userData))
        {
          $this->userData[$user_id] += $val;
        }
        else
        {
          $this->userData[$user_id] = $val;
        }
    }

    public function getUser($user_id = null)
    {
        if(!is_null($user_id))
        {
          return $this->userData[$user_id];
        }

        return $this->userData;
    }

    public function setRegion($quotaKey, $val)
    {
        if(array_key_exists($quotaKey, $this->regionData))
        {
          $this->regionData[$quotaKey]+= $val;
        }
        else
        {
          $this->regionData[$quotaKey] = $val;
        }
    }

    public function getRegion($key = null)
    {
        if(!is_null($key))
        {
          return $this->regionData[$key];
        }

        return $this->regionData;
    }

    public function restart()
    {
      $this->data = array();
      $this->userData = array();
      $this->regionData = array();
    }

    private function __construct(){}
}

class Node implements iNode
{
    public $total;

    public $childNodes;

    public $name;

    public static $inter;


    public function __construct($proc = null)
    {
       $this->proc = $proc;
    }


    public function getProc()
    {
      return $this->proc;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function addChild(iNode $child)
    {
        $this->childNodes[] = $child;
    }

    public function addCustomChild($key, iNode $child)
    {
        $this->childNodes[$key] = $child;
    }

    public function setTotal($total)
    {
        $this->total = $total;
    }

    public function setProcTotal($procTotal)
    {
        $this->procTotal = $procTotal;
    }

    public function hasChildren()
    {
      return count($this->childNodes) > 0;
    }

    public function getTotal()
    {
      return $this->total;
    }

    public function getName()
    {
      return $this->name;
    }

    public function calculateWithShare($path, $cnt, & $inters)
    {
        $quotaKey = implode("__", $path);


        $matrix = Matrix::getInstance();

        foreach($inters as $id => &$data)
        {
            //$matrixKey = $data['region'] . "_" . $quotaKey;
            $calc = $this->total * $data['share'] / 100;

            $ceilCalc = ceil($calc);

          //  $matrix->set($quotaKey,  $ceilTotal - $this->total);
            $matrix->set($quotaKey,  $ceilCalc - $calc);
            $matrix->setUser($id, $ceilCalc);
            $matrix->setRegion($quotaKey, $ceilCalc);

            //$calc = ceil($calc);

        //    $total += $ceilCalc;
      //      $inters[$id]['actualTotal'] += $calc;
            $inters[$id][$quotaKey] = $ceilCalc;
        }
    }

    public function calculateWithTotal($path, $cnt, & $inters)
    {

        $quotaKey = implode("__", $path);
      //  $inter[1][$sex][$age] = 555;

        $intCount = count($inters);

        $needed = (int)($cnt/$intCount);
        $leftover = $cnt % $intCount;

      foreach($inters as $id => $inter)
      {
          $inters[$id][$quotaKey] = $needed;
      }
      if($leftover > 0)
      {
        $keys = array_rand($inters, $leftover);
        if(!is_array($keys)) $keys = array($keys);

        foreach($keys as $key)
        {
          if(isset($inters[$key][$quotaKey]))
            $inters[$key][$quotaKey]++;
          else
            $inters[$key][$quotaKey] = 1;
        }
      }/**/
    }

    function calc(& $path = null, & $inter)
    {
        if(count($this->childNodes))
        {
          foreach($this->childNodes as $id => $childNode)
          {
              $path[] = $childNode->getName();
              $calculated = $this->getTotal() * $childNode->getProc() / 100;

              $procCalc = $childNode->getProc();

              if($this->proc)
              {
                  $procCalc = $this->proc * $childNode->getProc() / 100;
              }

              $childNode->setProcTotal($procCalc);
              //$calculated = ceil($calculated);
              $childNode->setTotal($calculated);
              $childNode->calc($path, $inter);
          }
          array_pop($path);
        }
        else
        {
            //  print implode(" ", $path) . ": " . $this->proc  . " " . $this->total . "<br/>";
              //$this->inter($path, $this->total, $inter);

              if(InterviwerParser::$hasBeenUsed)
                $this->calculateWithShare($path, $this->total, $inter);
              else
                $this->calculateWithTotal($path, $this->total, $inter);
              array_pop($path);
        }
    }

}
