<?php
/**
 * SurveySession System
 *
 */

class SurveySession {

	private $db; // class to database connection
	private $UserAgent; // user agent user is using
	private $php_session_id; // 32 character ascii string created by php
	private $native_session_id; // autoincrement id in database
	private $sessionTimeOut = 86400; // 10 minutes session timeout
	private $loginStatus;
	private $newSession = '';
	private $IgnoreSessionSave = false;
	private $qStatus = 0;
	private $idStructure = 0;

	public $idGenStruc; // with www_ids link creation we can create also predefined structure IDs

	/**
	 * Main constructor where  save handler and database connection is set
	 *
	 * @param object $db
	 */
	public function __construct($db, $loginSID,$asteriskID = 0, $otherData = null, $parentSession = null) {
		$this->db = $db;
		$this->loginSID = $loginSID;
		$this->resetSession = $resetSession;

		$sessionConfig = configLoader::loadConfig('session_logging');
		$this->statusLogsFolder = $sessionConfig['statuses_log_folder'];

		session_set_save_handler(
			array(&$this, '_session_open_method'),
			array(&$this, '_session_close_method'),
			array(&$this, '_session_read_method'),
			array(&$this, '_session_write_method'),
			array(&$this, '_session_destroy_method'),
			array(&$this, '_session_gc_method')
		);
		$this->UserAgent = $GLOBALS["HTTP_USER_AGENT"];
		$this->CheckPermission();
		// session name was enabled again at 9.3.2015 - soulskiner
		// if you change this name please contact Borut, before changing anything
		session_name("warpitSurveySess");
		if ($this->newSession) session_id($this->newSession);
		if (!is_null($parentSession))  session_id($parentSession);
		session_cache_limiter("nocache");
		session_start();
		if ($this->newSession && $this->SaveToSession )
		{
			$_SESSION = $this->SaveToSession;
			$_SESSION['questionFields'] = array();
		}
		if(!is_null($parentSession))
		{
			include_once(PATH_TO_ROOT."survey/class.ProjectJumpManager.php");
			ProjectJumpManager::loadMainProjectContext();
		}

		if(!is_null($otherData) && is_array($otherData))
		{
			foreach ($otherData as $key => $value) {
				$_SESSION[$key] = $value;
			}
		}
		if ($asteriskID) $_SESSION['asteriskID'] = $asteriskID;
		if($_GET['test']) $_SESSION['testSurvey'] = true;

		//echo "READ SESSION:";print_r($_SESSION);echo "<br><br><br>";
	}

	private function LogingAllowed()
	{
				if(strlen($this->statusLogsFolder) <= 0){
					return false;
				}

				$fullPath = WARPIT_WEBPROJECTS . $this->statusLogsFolder;

				if(!is_writable($fullPath)){
					return false;
				}

				return true;
	}

	private function Log()
	{
			if($this->LogingAllowed()){

					$fullPath = WARPIT_WEBPROJECTS . $this->statusLogsFolder;
					$fileName = $fullPath . 'status_log_' . date('Ymd') . '.log';

					$content = [
						'[' . date('r') . ']',
						'[loginSID ' . $this->loginSID . ']',
						'[client ' . $_SERVER['REMOTE_ADDR'] . ']',
						'[status ' . $this->loginStatus . ']',
						'[browser ' . $_SERVER['HTTP_USER_AGENT'] . ']',
					];

					file_put_contents($fileName, implode("\t", $content) . "\n", FILE_APPEND);
			}
	}


	function CheckPermission() {

		if ( $this->loginSID ) {

			$expSID = explode("-",$this->loginSID,2);
		//	xdebug_break();
			if (!is_numeric($expSID[1])) {
				$this->loginStatus = 98;
				$this->Log();
				return;
			}

			$sql = "SELECT a.*, b.id_structure , b.qstatus, d.id_loginSID, d.id AS sessionID, d.variable_value AS oldSessionState,
							c.proj_name,c.active,c.start_date,c.end_date,c.has_user_quotas,e.language as id_userLng,
							c.language as id_defaultQuestionLng,c.redirectActive,c.interview_show_variable,c.back_delete,
							c.hide_back_button
							FROM ".DB_WARPIT_WEBCATI_BASE."._www_ids as a
							LEFT JOIN ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_statistics as b ON a.id = b.id_loginSID
							LEFT JOIN ".DB_WARPIT_WEBCATI_BASE."._Projects as c ON a.id_project = c.id
							LEFT JOIN ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session as d ON d.id_loginSID = a.id
							LEFT JOIN ".DB_WARPIT_MAIN."._user as e ON (e.id = a.id_user AND a.user_type = 1)
						WHERE a.id = ".$expSID[1]." LIMIT 1 ";
			//echo $sql."<br>";

			$res = $this->db->SQLexecute($sql);
			$zad = $this->db->fetchAssoc($res);


			// preverim ali se loginSID (kljuc do ankete) ki je poslan preko URL ujema s tistim v bazi
			// ce se ne ujema vrnem status 97
			if ($zad['loginSID'] != $this->loginSID) {
				$this->loginStatus = 97;
				$this->Log();
				return;
			}

			//login SID se ujema, zato lahko nadaljujem s proceduro pravic in pridobivanja
			// podatkov o izvedbi projekta...

			//if user has no language set, we use the project default
			if(!$zad['id_userLng']) $zad['id_userLng'] = $zad['id_defaultQuestionLng'];

			$this->id_project 	= $zad['id_project'];
			$this->proj_name 	= $zad['proj_name'];
			$this->idGenStruc 	= $zad['idGenStruc'];
			//echo "idGenStruc:".$this->idGenStruc." - ".$zad['idGenStruc']."<br>";

										//popup links always create new session!
			if (!$zad['id_loginSID'] || $zad['user_type'] == 3) {

				$sql = "INSERT INTO ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session
							SET
								id_loginSID = ".$zad['id'].",
								last_impression = NOW(),
								user_agent = '".$this->UserAgent."'";
				//echo "$sql<br>";

				$this->db->SQLexecute($sql);
				$this->native_session_id  = $this->db->GetLastInsertId();

				$zad['id_loginSID'] = $zad['id'];

				$this->newSession = md5($this->native_session_id.time())."-".$this->native_session_id;

				$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session  SET id_ascii_session = '".$this->newSession."' WHERE id = ".$this->native_session_id;
				$this->db->SQLexecute($sql);
				foreach ($zad as $key=>$val) $this->SaveToSession[$key] = $val;


			} else {

				//20170328 Bojan Orter - We need to get subQuestionnaire from last session so we know
				//where we left sub survey in previous session
				$oldSession = $this->_custom_session_decode(stripslashes($zad['oldSessionState']));
				if(isset($oldSession["subQuestionnaire"]))
				{
					$zad["subQuestionnaire"] = $oldSession["subQuestionnaire"];
				}

				/*if(isset($oldSession["jumpToSubProject"]))
				{
					foreach ($oldSession as $key => $value)
					{
						if(!isset($zad[$key]))
						{
							$zad[$key] = $value;
						}
					}

					//$zad["jumpToSubProject"] = $oldSession["jumpToSubProject"];
					$_POST = $zad["jumpToSubProject"]["post"];
				}*/
				unset($zad['oldSessionState']);
				$this->native_session_id  = $zad['sessionID'];
				$this->newSession = md5($this->native_session_id.time())."-".$this->native_session_id;
				$sql = "UPDATE ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session
							SET
								created 			=	NOW(),
								last_impression		= 	NOW(),
								id_ascii_session 	= '".$this->newSession."'
							WHERE id = ".$this->native_session_id;
				//echo "$sql<br>";
				$this->db->SQLexecute($sql);

				//echo "<br>na kaj nastavim ID strukture: ".$zad['id_structure']."<br>";
				$this->setIdStructure($zad['id_structure']);

				$zad['id_loginSID'] = $zad['id'];
				$zad['native_session_id'] = $this->native_session_id;

				foreach ($zad as $key=>$val) $this->SaveToSession[$key] = $val;

				$this->ReLoginStatus = 1;
			}

			if($zad['user_type'] == 2 || $zad['user_type'] == 4)// userspool interviewers and uniqe popup links can take survey only once!
				{
					$this->setQstatus($zad['qstatus']);
					$this->SaveToSession['popUpQuestionnaire'] = true;
				}
				else if($zad['user_type'] == 3)
					$this->SaveToSession['popUpQuestionnaire'] = true;


		}

	}



	/**
	 * called by session_start(.
	 *
	 * @param unknown_type $save_path
	 * @param unknown_type $session_name
	 * @return unknown
	 */
	function _session_open_method($save_path,$session_name) {
		return (true);
	}

	/**
	 * called at page end
	 *
	 * @return unknown
	 */
	function _session_close_method() {
		return (true);
	}

	/**
	 * called after session_start()
	 * id is 32 character session ID produced by php system
	 * @param char $id
	 * @return unknown
	 */
	function _session_read_method($id) {
		$this->php_session_id = $id;
	//	xdebug_break();
		$expSID = explode("-",$this->php_session_id,2);
		if (!is_numeric($expSID[1])) {
			$this->loginStatus = 98;
			$this->Log();
			return;

		}

		$result = $this->db->SQLexecute("SELECT  id, variable_value, id_ascii_session , TIME_TO_SEC( TIMEDIFF( NOW( ) , `last_impression` ) )  as diff
												FROM  ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session  WHERE id = '".$expSID[1]."'");

			if ($this->db->NumRows($result)) {
				$data = $this->db->fetchAssoc($result);

				if ($data['id_ascii_session'] != $this->php_session_id ) {
					$this->loginStatus = 97;
					$this->Log();
					return; }

				// checking for session timeout
				// if condition is true, session record is updated with reset data
				if ( $data['diff'] > $this->sessionTimeOut ) {
					$this->loginStatus = 96;
					$this->Log();
					return;
				}

				$this->native_session_id 	=  $data['id'];

				// Update Last Login field
				$this->db->SQLexecute("UPDATE ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session  SET last_impression = NOW() WHERE id = ".$this->native_session_id);

				$this->loginStatus = 2;
				// we return all session variables

				return 		 $data['variable_value'];

			} else {
				$this->loginStatus = 9;
				return "";
			}


	}

	/**
	 * called when session data is to be written
	 *
	 * @param int $id
	 * @param serialized $sess_data
	 * @return unknown
	 */
	function _session_write_method($id, $sess_data) {
/*		echo "<pre>";
		echo "WRITE SESSION:";print_r($_SESSION);echo "<br><br><br>";
		echo "</pre>";*/
		// if we have any session data we save it into database
		try {
		if ($sess_data && $this->GetIgnoreSessionSave() == false ) {
			$this->db->SQLexecute("INSERT INTO ".DB_WARPIT_WEBCATI_BASE."._www_interviewer_session (id,variable_value) VALUES
							  			('".$this->native_session_id."','".addslashes( $sess_data )."') ON DUPLICATE KEY UPDATE variable_value = '".addslashes($sess_data)."'");
		}
		}
		catch (Exception $e)
		{
			print_r($e->getMessage());
		}

		return true;
	}


	/**
	 * called by session_destroy()
	 *
	 * @param int $id
	 * @return unknown
	 */
	function _session_destroy_method($id) {
		//echo "session DESTROY<br />";
		/*$this->db->SQLexecute("UPDATE ".DB_WARPIT_MAIN."._user_session SET logout = NOW(), logged_in = 0 WHERE id = '".$this->native_session_id."'");
		$this->logged_in 	= 0;*/
		//echo session_id();
		return true;
	}

	//20170328 Bojan Orter - I had problems to decode session string from data base with session_decode
	//after google i took solution from http://php.net/manual/en/function.session-decode.php, first comment
	//and i changed a bit that function
	function _custom_session_decode($session_data)
	{
		$return_data = array();
        $offset = 0;
        while ($offset < strlen($session_data)) {
            /*if (!strstr(substr($session_data, $offset), "|")) {
                throw new Exception("invalid data, remaining: " . substr($session_data, $offset));
            }*/
            $pos = strpos($session_data, "|", $offset);
            $num = $pos - $offset;
            $varname = substr($session_data, $offset, $num);
            $offset += $num + 1;
            $data = unserialize(substr($session_data, $offset));
            $return_data[$varname] = $data;
            $offset += strlen(serialize($data));
        }
        return $return_data;
	}
	//END
	function GetLoginStatus() { return $this->loginStatus; }
	function IsReLogin() { return $this->ReLoginStatus; }
	function GetNativeSessionId() { return $this->native_session_id; }

	function setQstatus($aStatus) { $this->qStatus = $aStatus; }
	function getQstatus() { return $this->qStatus; }

	function setIdStructure($aId) { $this->idStructure = $aId; }
	function getIdStructure() { return $this->idStructure; }


	function SetIgnoreSessionSave($aFlag = false) { $this->IgnoreSessionSave = $aFlag; }
	function GetIgnoreSessionSave() { return $this->IgnoreSessionSave; }

	function GetPhpSessionId(){return $this->php_session_id;}
	/**
	 * called randomly
	 *
	 * @return unknown
	 */
	function _session_gc_method() {
		//echo "session GC<br />";
		return (true);
	}


}



?>
