<?php
/*
    class helps to create post data for form, from array,
*/
class PostDataHelper
{
    private $data;
    private $formParams;

    private $beforeHtml;
    private $afterHtml;

    function __construct($formParams, $beforeHtml = "", $afterHtml="")
    {
        $this->data = Array();
        $this->formParams = $formParams;
        $this->beforeHtml = $beforeHtml;
        $this->afterHtml = $afterHtml;
    }

    public function getHtml()
    {
        $rtnHtml = "";
        $rtnHtml .= $this->beforeHtml;
        $rtnHtml .= $this->getFormHtml();
        $rtnHtml .= $this->afterHtml;

        return $rtnHtml;
    }

    public function addData($data, $prefix = null)
    {
         array_push($this->data, Array("data" => $data, "prefix" => $prefix));
    }

    private function getFormHtml()
    {
        $form = "<form ";
        foreach ($this->formParams as $key => $value)
        {
            $form .= " $key='$value' ";
        }
        $form .= ">";

        foreach ($this->data as $dataParams)
        {
            $form .= $this->prepareFormBody($dataParams["data"], $dataParams["prefix"]);
        }

        $form .= "</form>";
        return $form;
    }

    private function prepareFormBody($data, $prefix = null)
    {
        $str = "";
        foreach ($data as $key => $value) {
            if(is_array($value))
            {
                $name = (!is_null($prefix)) ? $prefix . "[" . $key . "]" : $key;
                $str .= $this->prepareFormBody($value, $name);
            }
            else
            {
                $name = (!is_null($prefix)) ? $prefix . "[" . $key . "]" : $key;
                $str .= $this->prepareField($name, $value);
            }
        }
        return $str;
    }


    private function prepareField($key, $value)
    {
        return "<input type='hidden', name='$key' value='$value' />";
        //return "$key => $value<br>";
    }
}

?>
