<?php

class DesignerText
{
    protected $currentQuestionairPosition = null;

    protected $userDefinedTexts = [];

    public function getValue($name)
    {
        if(key_exists($name,$this->userDefinedTexts)){
            return $this->userDefinedTexts[$name];
        }

        if(property_exists($this, $name) === true){
            return $this->$name;
        }

        return $name;
    }

    public function setValue($name, $value){
        if(property_exists($this, $name) === true){
            $this->$name = $value;
        }
    }

    public function setUserDefinedText($name, $value){
        $this->userDefinedTexts[$name] = $value;
    }

    public function textExists($name){
        return key_exists($name,$this->userDefinedTexts) || property_exists($this, $name);
    }
}