<?php

class CheckQuotas
{
    private $quotasFullList = null;

    public function __construct($db, $id_project)
    {
        $this->db = $db;
        $this->id_project = $id_project;

        $this->projname = $this->db->get('_Projects','id = ' . $this->id_project,'proj_name', DB_WARPIT_WEBCATI_BASE);
        $this->projname = reset($this->projname);

    }

    private function getQuotaFullLayers()
  	{
  		$quotaDefinitionSql = "SELECT layer,q_name,source FROM " . DB_WARPIT_WEBCATI_BASE . ".quota_layer a
  		  LEFT JOIN " . DB_WARPIT_WEBCATI_BASE. ".quota_layer_addon b ON a.layer=b.id
  		  WHERE b.active=1 AND id_project = " . $this->id_project;
  		$res = $this->db->SQLexecute($quotaDefinitionSql);

  		$layers = [];
  		$selectFields = [];
  		while($row = $this->db->fetchAssoc($res))
  		{
  				$prefix = '';
  				switch($row['source'])
  				{
  						//case 3:
  						case 2: $prefix = 'QT_';break;
  						default: $prefix = 'TP_';
  				}
  				$layers[$row['layer']][] = $prefix . $row['q_name'];

  				//TODO tole lahko prestaviš v switch
  				if($prefix == 'TP_')
  				{
  					if(in_array($row['q_name'], array('zip', 'oms', 'region')))
  						$this->fields[$prefix . $row['q_name']] = 'a.'. $row['q_name'];
  					else
  						$this->fields[$prefix . $row['q_name']] = 'a.tel_' . $row['q_name'];
  				}
  				else
  				{
  					$this->fields[$prefix . $row['q_name']] = 'c.' . $prefix. $row['q_name'];
  					$this->structureFields[$prefix.$row['q_name']] = $prefix . $row['q_name'];
  				}
  		}

  		foreach($layers as $layer_id=>$layer_data)
  		{
  		    $where = [];
  		    $fields = [];
  				$fullLayer = true;
  		    foreach($layer_data as $cell)
  		    {
  		          $where[] = "a." . $cell . " = b.".$cell;
  		          $fields[] = $cell;
  		    }

  		    $sql = "SELECT a.*,(SELECT count(*) FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projname . "___quotaCalc b WHERE " . implode(' AND ', $where) ." ) AS q_done FROM " . DB_WARPIT_WEBCATI_BASE . "." . $this->projname . "___quotaLimits a WHERE id_layer = " . $layer_id;
  		    $res = $this->db->SQLexecute($sql);
  		    while($row = $this->db->fetchAssoc($res))
  		    {
  		        $values = [];
  		        foreach($fields as $field)
  		              $values[] = $row[$field];

              $enabled = filter_var($row['enabled'], FILTER_VALIDATE_BOOLEAN);

  		        if($row['q_done'] >= $row['q_value'] && $enabled)
  		            $quotaFullList[implode('-', $layer_data)][] = implode('-', $values);
  						else
  								$fullLayer = false;
  		    }

  				if($fullLayer) $this->fullLayersList[] = $layer_id;
  		}

  		return $quotaFullList;
  	}

  	public function checkQuotas($data)
  	{
        if(!$this->quotasFullList)
          $this->quotasFullList = $this->getQuotaFullLayers();

  			foreach($this->quotasFullList as $quotaColumns=>$quotaValuse)
  		  {
  				//TODO tole razbijanje ni potrebno. Lahko narediš v prave arraye že ko prebereš fielde iz baze
  		        $columns = explode('-', $quotaColumns);

  		        foreach($quotaValuse as $val)
  		        {
  		            $values = explode('-', $val);
  		            $cell = array_combine($columns, $values);

  		            $diff = true;
  		            foreach($cell as $colName=>$colVal)
  		            {
  		                if($data[$colName] != $colVal)
  		                {
  		                    $diff = false;
  		                    break;
  		                }
  		            }

  		        if($diff){
  		          return true;
  		        }
  		      }
  		    }

          return false;
  	}
}
