<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.gridData.php");
include_once(PATH_TO_ROOT . 'webcati/_class/class.quotas.php');
include_once(PATH_TO_ROOT."config.php");

$interviewer = '_Interviewer';
$intStructure = '_InterviewerStructure';

class quotaStatManipulator extends GridDataManipulator
{
	private function getTelIndexField($name)
	{
	    if(in_array($name, ['oms', 'region', 'zip'])){
	      return $name;
	    }

	    return 'tel_' . $name;
	}

	private function getSourceMap(\quotes $q)
	{
			foreach ($q->tel_quest_names as $value)
			{
					$source = end(explode('_', $value['id_s']));
					switch($source)
					{
							case 2: $prefix = 'QT_';break;
							default: $prefix = 'TP_';
					}
					$sourceMap[$value['name']] = $prefix;
			}

			return $sourceMap;
	}

	private function generateSQL($qDoneCondition, $notNull)
	{
				$selectSql = "SELECT a.*";

				$selectSql .= " FROM $this->tableLimits a  WHERE 1 = 1 ";

				if(count($notNull)){
					$selectSql .= ' AND ' . implode(' AND ', $notNull);
				}

				return $selectSql;
	}

	private function getFieldsList(\quotes $q)
	{
			$sourceMap = $this->getSourceMap($q);

			foreach($q->quota_layers as $layer)
			{
					foreach(explode(',', $layer['names']) as $q_name)
					{
							$field =  $sourceMap[$q_name] . $q_name;

							$telIndexField = null;
							if($sourceMap[$q_name] === 'TP_'){
								$telIndexField = $this->getTelIndexField($q_name);
							}

							$fieldsList[$layer['id']][] = [
									'field' 		 		=> $field,
									'q_name'		 		=> $q_name,
									'telIndexField' => $telIndexField,
							];
					}
				}

				return $fieldsList;
	}

	private function buildQuery($fieldsList)
	{
		$sqls 			= [];
		foreach($fieldsList as $layer)
		{
				$notNull              = [];
				$qDoneCondition       = [];

				foreach($layer as $variable)
				{
						$field =  $variable['field'];

						$notNull[]        = 'a.' . $field . ' IS NOT NULL';
						$qDoneCondition[] = 'a.' . $field .' = b.'.$field;
				}

				$sqls[] = $this->generateSQL($qDoneCondition, $notNull);

			}

			return implode(' UNION  ', $sqls);
		}

	private function selectFreeNumbers($quotaFields)
	{
				if(!$quotaFields){
					return [];
				}

				$cnts = [];

				$countFreeNumbers = "SELECT count(*) as cnt, " . implode(',', $quotaFields) . " FROM " . $this->tableTelIndex . " WHERE status = 0 and status_rec = 0 GROUP BY " . implode(',', $quotaFields) . ';';
				$res = $this->db->SQLexecute($countFreeNumbers);

				while($row = $this->db->fetchAssoc($res)){
						$tmp = [];
						foreach ($quotaFields as $field) {
								$tmp[] = $field . '-' . $row[$field];
						}
						$cnts[implode('*', $tmp)] = $row['cnt'] ;
				}

				return $cnts;
	}

	private function getFreeNumbers($fieldsList)
	{
			$freeNumberCounts = [];

			foreach($fieldsList as $layerId => $layerFields){
					$quotaFields = [];

					foreach($layerFields as $variable){
						if($variable['telIndexField'] !== null){
							$quotaFields[] = $variable['telIndexField'];
						}
					}

					$data = $this->selectFreeNumbers($quotaFields);
					$freeNumberCounts = array_merge($freeNumberCounts, $data);
			}

			return $freeNumberCounts;
		}

	private function getOriginalValues($fieldsList)
	{
			$originalValues = [];

			$sql = "SELECT * FROM " . $this->tableLimits."Default";
			$res = $this->db->SQLexecute($sql);

			while($row = $this->db->fetchAssoc($res)){
					$quotaFields = [];
					$layerId 		 = $row['id_layer'];

					foreach($fieldsList[$layerId] as $field){
						$columnName  = $field['field'];
						$columnValue = $row[$columnName];

						if($columnValue === null){
							continue;
						}

						$quotaFields[] = "$columnName-$columnValue";
					}

					$originalValues[implode('*', $quotaFields)] = $row['q_value'];
			}

			return $originalValues;

	}

	private function getDoneValues($fieldList)
	{
			$doneValues = [];

			foreach($fieldList as $layerId => $layerFields){

					$quotaFields = [];
					foreach($layerFields as $variable){
								$quotaFields[] = $variable['field'];
					}

					$doneValues = array_merge($doneValues, $this->selectDoneValues($quotaFields));
			}
			return $doneValues;
	}

	private function selectDoneValues($quotaFields)
	{
			if(!$quotaFields){
				return [];
			}

			$sql = "SELECT count(*) as cnt, " . implode(',', $quotaFields) . " FROM  $this->tableCalc GROUP BY " . implode(',', $quotaFields);
			$res = $this->db->SQLexecute($sql);

			$dones = [];

			while($row = $this->db->fetchAssoc($res)){
					$tmp = [];
					foreach ($quotaFields as $field) {
							$tmp[] = $field . '-' . $row[$field];
					}
					$dones[implode('*', $tmp)] = $row['cnt'] ;
			}

			return $dones;
	}

	private function getValueFromQuotaFieldsArray($quotaFields, $dataArray)
	{
			$value = null;

			$key = implode('*', $quotaFields);
			if(key_exists($key, $dataArray)){
				$value = $dataArray[$key];
			}

			return $value;
	}

	private function prepareInputParameters()
	{
			$this->projectId 				 = intval($_POST['id_project']);
			list($this->projectName) = explode('___', $_POST['RMtable']);

			$this->tableCalc     = $this->projectName . "___quotaCalc";
			$this->tableLimits   = $this->projectName . "___quotaLimits";
			$this->tableTelIndex = $this->projectName . "___telIndex";
	}


	public function selectAction()
	{
			$this->prepareInputParameters();

			$q = new quotes($this->projectId, $this->db);
			$q->select_quota_layer();

			$fieldsList 		  = $this->getFieldsList($q);
			$query 					  = $this->buildQuery($fieldsList);
			$freeNumbersCount = $this->getFreeNumbers($fieldsList);
			$originalValues 	= $this->getOriginalValues($fieldsList);
			$doneValues 			= $this->getDoneValues($fieldsList);

			$res = $this->db->SQLexecute($query);

			$cells = [];
			while($row = $this->db->fetchAssoc($res)){
			    $layerId = $row['id_layer'];

			    $currentLayerFields  = [];
					$telIndexQuotaFields = [];
					$quotaLimitsFields 	 = [];
			    foreach($fieldsList[$layerId] as $fields){

						$currentLayerFields[] = $fields['q_name'] . ' = ' . $row[$fields['field']];
						$quotaLimitsFields[] = $fields['field'] . "-" . $row[$fields['field']];

						if($fields['telIndexField'] !== null){
							$indexValue = $row[$fields['field']];
							$telIndexQuotaFields[] = $fields['telIndexField'] . '-' . $indexValue;
						}

					}

					$freeNumbers   = $this->getValueFromQuotaFieldsArray($telIndexQuotaFields, $freeNumbersCount);
					$originalValue = $this->getValueFromQuotaFieldsArray($quotaLimitsFields, $originalValues);
					$doneValue 		 = $this->getValueFromQuotaFieldsArray($quotaLimitsFields, $doneValues);

					$doneValue = $doneValue === null?0:$doneValue;

					$qValue = intval($row['q_value']);

			    $cells[] = [
						'id'						 => $row['id'],
			      'cell_name'      => implode(' AND ', $currentLayerFields),
			      'q_value'        => $qValue,
			      'q_done'         => $doneValue,
			      'q_done_percent' => ($doneValue/$qValue) * 100,
			      'q_todo' 				 => $qValue - $doneValue,
			      'q_todo_percent' => ($qTodo/$qValue) * 100,
			      'free_numbers'   => $freeNumbers,
						'originalValue'	 => $originalValue,
			    ];
			}
				
			$sortColsExclude = array(
				"qt_lock",
				"cell_name",
				"q_value",
				"originalValue",
				"free_numbers",
				"q_done",
				"q_done_percent",
				"q_todo",
				"q_todo_percent"
			);

			$manualSort = array();

			if(in_array($_POST['sort'], $sortColsExclude)) {
				$manualSort['sort'] = $_POST['sort'];
				$manualSort['dir'] = $_POST['dir'];
				
				unset($_POST['sort']);
				unset($_POST['dir']);
			}
			
			if(isset($manualSort['sort']) && isset($manualSort['dir'])) {
				//manual sort function call
				usort($cells, $this->make_comparer([$manualSort['sort'], ($manualSort['dir'] == 'ASC' ? SORT_ASC : SORT_DESC)]));
			}

			return json_encode(["success" => true, "rows" => $cells, 'SQL' => $query]);
	}

	public function exportAction(){
		$result = $this->selectAction();
		$result = json_decode($result, TRUE);

		$this->arr = $result['rows'];
		parent::exportAction();
	}

	public function resetQuotasAction()
	{
			$this->db->ChangeDatabase(DB_WARPIT_WEBCATI_BASE);

			$quotaCalcTable = substr($this->tableAddon, 0, -5);
			list($projectName) = explode('___quotaCalc', $quotaCalcTable);

			$sql = "TRUNCATE TABLE " . $quotaCalcTable;
			$r['success'] = true;
			if(!$this->db->SQLexecute($sql)) $r['success'] = false;

			$projectId = $this->db->get('_Projects','proj_name = "' . $projectName .'"','id', DB_WARPIT_WEBCATI_BASE);
			$projectId = reset($projectId);

			include_once(PATH_TO_ROOT. 'webcati/_class/class.quotas.php');

			$quotas = new quotes($projectId, $this->db);

			$quotas->recalculateLock();
			return "{success:true}";
	}

	public function updateAction(){
		$projName = explode('___', $_POST['RMtable'])[0];
		$projectId = $_POST['id_project'];
		$cellId = $_POST['id'];
		$field = $_POST['field'];
		$value = $_POST['value'];
		$action = "update_cell";

		$_POST = [
			'action' => $action,
			'projName' => $projName,
			'cell_id' => $cellId,
			'field' => $field,
			'value' => $value,
			'id_project' => $projectId
		];

		$db = $this->db;
		include_once(PATH_TO_ROOT."webcati/_forms/_ajax/ajax.cell-quotas.php");
	}
	
	//manual sort function
	function make_comparer() {
		// Normalize criteria up front so that the comparer finds everything tidy
		$criteria = func_get_args();
		foreach ($criteria as $index => $criterion) {
			$criteria[$index] = is_array($criterion)
				? array_pad($criterion, 3, null)
				: array($criterion, SORT_ASC, null);
		}

		return function($first, $second) use (&$criteria) {
			foreach ($criteria as $criterion) {
				// How will we compare this round?
				list($column, $sortOrder, $projection) = $criterion;
				$sortOrder = $sortOrder === SORT_DESC ? -1 : 1;

				// If a projection was defined project the values now
				if ($projection) {
					$lhs = call_user_func($projection, $first[$column]);
					$rhs = call_user_func($projection, $second[$column]);
				}
				else {
					$lhs = $first[$column];
					$rhs = $second[$column];
				}

				// Do the actual comparison; do not return if equal
				if ($lhs < $rhs) {
					return -1 * $sortOrder;
				}
				else if ($lhs > $rhs) {
					return 1 * $sortOrder;
				}
			}

			return 0; // tiebreakers exhausted, so $first == $second
		};
	}
}



$db->ChangeDatabase($_POST['database']);

$tableName = $_POST['RMtable'];
$tableAddon = $tableName.'Addon';

$manipulator = new quotaStatManipulator($db,$_POST['RMtable']);
$manipulator->tableAddon = $tableAddon;
$comm = $_REQUEST['action'].'Action';

if(method_exists($manipulator,$comm)) {
	echo $manipulator->$comm();
} else {
	echo json_encode(array("success" => false, "error" => "Unknown action!"));
}

?>
