<?php
include_once ("_dirinfo.php");
include_once (PATH_TO_ROOT."init.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.formData.php");
include_once (PATH_TO_ROOT."_ajaxManipulators/_class/class.treeData.php");
include_once(PATH_TO_ROOT."config.php");

class systemQuestionTreeManipulator extends TreeDataManipulator
{
	function selectAction()
	{
        $this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
        $this->lab = "q_name";
        $this->table = $_POST['RMtable'];
		$id_language = $_POST['language'];
		$tableLanguage = $this->table . "_language";

		$sql = "SELECT a.id, a.q_name, b.instruction, c.question FROM
 			 	(SELECT id, q_name, q_pos FROM " . $this->table . " WHERE q_pos < 0) as a
			 	LEFT JOIN (SELECT id_question, lngText as instruction FROM " . $tableLanguage . " WHERE id_text_type = 1 AND id_language = $id_language) as b ON a.id = b.id_question
			 	LEFT JOIN (SELECT id_question, lngText as question FROM " . $tableLanguage . " WHERE id_text_type = 2 AND id_language = $id_language) as c ON (a.id = c.id_question)
			 	ORDER BY a.id";

        If (!$res = $this->db->SQLexecute($sql)){
			return '{success:false,error:"'.$this->db->GetError().'", STATEMENT: "'.$sql.'"}';
		}
		$this->db->LogWrite($sql,false,"selectAction -> builded SQL");

		// display each child
		while ($row = $this->db->fetchAssoc($res)) {
			$this->db->LogWrite($row['id'],false,"selectAction -> going inside while...");
			// Response parameters.
			$path = array();

			$path['text']		=html_entity_decode( $row[ $this->lab ] );
			$path['instruction'] = $row['instruction'];
			$path['question'] = $row['question'];
 			//some tree may set a prefix to IDs to make them uniqe (if trees load data from multiple tables)
			$path['id']	= $this->idPrefix.$row['id'];
			$path['origId'] = $row['id'];
			//$path['position'] = $row['orderBy'];

			$path['leaf'] = true;
			$path['iconCls'] = $row['node_img'];

			$this->nodes[] = $path;
		}
		return json_encode($this->nodes);
	}
}

class fieldEditManipulator extends FormDataManipulator
{
	function loadAction()
	{
		echo json_encode(Array("success" => true));
	}

	function updateAction()
	{
		$this->db->ChangeDatabase(DB_WARPIT_WEBCATI);
		$tableName =  $_POST['RMtable'] . "_language";

		$fieldToUpdate = $_POST['field'];
		$newValue = addslashes($_POST['value']);
		$id_question = $_POST['id'];
		$id_language = $_POST['language'];

		if($fieldToUpdate == "question")
		{
			$id_text_type = 2;
		}
		else if($fieldToUpdate == "instruction")
		{
			$id_text_type = 1;
		}

		$sql = "REPLACE INTO $tableName SET id_language = $id_language, id_question = $id_question, id_text_type = $id_text_type, lngText = '$newValue'";
		if(!$this->db->SQLexecute($sql))
		{
			return json_encode(Array("success" => false));
		}

		return json_encode(Array("success" => true));
	}
}

class systemQuestionComboManipulator
{
    private $db;
    private $tableName;

    public function __construct($db, $tableName)
    {
        $this->db = $db;
        $this->tableName = $tableName;
    }

    public function selectAction()
    {
		$id_project = $_POST["id_project"];
		$sql = "SELECT b.id, b.country_code, b.cp_comment FROM " . DB_WARPIT_WEBCATI_BASE . "._LanguageProjects a LEFT JOIN " . DB_WARPIT_WEBCATI_BASE . "._LanguageCodepage b ON a.id_language = b.id WHERE a.id_project = $id_project";

		if(!$res = $this->db->SQLExecute($sql))
        {
            return json_encode( Array("success" => "false", "STATMENT" => $sql, "error" => $this->db->GetError()) );
        }

        while($row = $this->db->fetchAssoc($res)) {
            $item["langId"] = $row['id'];
			$item["langLabel"] = $row['country_code'] . " - " . $row["cp_comment"];
            $items[] = $item;
            unset($item);
        }

        return json_encode( Array("success" => TRUE, "items" => $items) );
    }
}

if($_POST['RMcomp']=='tree')
{
	$manipulator = new systemQuestionTreeManipulator($db,$_POST['RMtable']);
}
else if($_POST['RMcomp'] == 'combo')
{
	$manipulator = new systemQuestionComboManipulator($db,$_POST['RMtable']);
}
else
{
	$manipulator = new fieldEditManipulator($db,$_POST['RMtable']);
}

$comm = $_REQUEST['action'].'Action';
if(method_exists($manipulator,$comm))
	echo $manipulator->$comm();
else
{
	echo '{success:false,error:"Unknown action!"}';
}
?>
