<?php
	ini_set("display_errors", 1);
	session_start();
	
	require_once 'data/class.MapServer.php';
	
	header('Content-type: text/html; charset=utf-8');
	// unset($_SESSION['mapfile']);
	// $_SESSION['layers'] = "obcina,katastrske_obcine";
	$_SESSION['layers'] = "ob";
	if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	$ms = new MapServer($_SESSION['mapfile']);
	$ms->setLayers(explode(",", $_SESSION['layers']));
	
	$ms->generateMapFile();
	
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
  <title>OpenLayers Example</title>
  <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
    <script src="http://openlayers.org/api/OpenLayers.js"></script>
    <!--[if lte IE 7]>
		<script src="json2.js"></script>
	<![endif]-->
    <style>
    	.loader {
    		display: none;
    		position: absolute;
    		background: rgba(255, 255, 255, 0.3);
			filter: progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr='#4cffffff', endColorstr='#4cffffff');
    		width: 500px;
    		height: 400px;
    	}
    	.load-img {
			margin-left: 225px;
			margin-top: 175px;
		}
		.smallmap {
			border: 1px solid #ccc;
		}
    </style>
    <link rel="stylesheet" type="text/css" href="assets/css/jquery.contextmenu.css">
    </head>
    <body>
      <div style="width:500px; height:400px" id="map" class="smallmap cmenu1"><div id="loader" class="loader"><img class="load-img" src="images/ajax-loader.gif"></img></div></div>
      <div id="name"></div>
      <input id="export" type="button" value="Izvoz" /><input id="test" type="button" value="test" />
      <script src="assets/js/jquery.contextmenu.js"></script>
      <script defer="defer" type="text/javascript">
      	var tout, exportMapControl,opacity=1.0;
    	$(document).ready(function() {
      	// OpenLayers.ProxyHost = "/cgi-bin/proxy.cgi?url=";
      	
      	var view = 0; // view of map .. 0 = slovenija, 1 = statisticne regije, 2 = obcine, 3 = volilne enote
      	var layers = '<?php echo $_SESSION['layers']; ?>' ;
      	var osm = true;
      	var wms = [];
      	var auto = true;
      	var home = new OpenLayers.LonLat(14.88, 46.10).transform('EPSG:4326', 'EPSG:3857');
      	
        var map = new OpenLayers.Map('map', {
        	units: "m",
			projection: "EPSG:3857",
			restrictedExtent: [
                1474983, 5683129, 1865714, 5929025
            ],
            allOverlays: true
        });

		var disableAllControls = function() {
		    for (var i = 0; i< map.controls.length; i++) {
		    	if (map.controls[i].displayClass == "olControlNavigation") {
		        	map.controls[i].deactivate();
		    	}
			}
		};        
        
        disableAllControls();
        
        if (osm) {
        	map.addLayer(new OpenLayers.Layer.OSM('OSM'));
        }
        
        var split = layers.split(",");
        
        for (var i=0;i<split.length;i++) {
        	wms.push(new OpenLayers.Layer.WMS(
			    "StatView",
			    "../cgi-bin/mapserv.fcgi?MAP=<?php echo $_SESSION['mapfile']; ?>",
			    {
			        layers: split[i],
			        transparent: "true",
			        srs: 'EPSG:3857',
			        format: "image/png"
			    },
			    {
			    	isBaseLayer: false
			    }
			));
			map.addLayer(wms[i]);
			
			if (view != i) wms[i].setVisibility(false);
			
			wms[i].events.register("loadstart", wms[i], function() {
                showLoader();
            });
            
            wms[i].events.register("loadend", wms[i], function() {
                hideLoader();
            });
        }
		
		map.setCenter(home, 8);
        
		var dragcontrol = new OpenLayers.Control.DragPan({'map':map, 'panMapDone':function(evt){
		    console.log('drag');
		}});
		dragcontrol.draw();
		
        map.addControls([
        	new OpenLayers.Control.MousePosition({
            	separator: ' | ',
            	numDigits: 2,
            	emptyString: ''
        	}),
        	dragcontrol
        ]);
        
        dragcontrol.activate();
        
        document.getElementById('map').oncontextmenu = function(e){
		 e = e?e:window.event;
		 if (e.preventDefault) e.preventDefault(); // For non-IE browsers.
		 else return false; // For IE browsers.
		};
		
		map.events.register("mousemove", map, function(event) {
			var lonlat = map.getLonLatFromPixel(event.xy);
			clearTimeout(tout);
			tout = setTimeout(function() { getMouseEventPosition(lonlat.toShortString()); },100);
		});
        
        // A control class for capturing click events...
		OpenLayers.Control.Click = OpenLayers.Class(OpenLayers.Control, {

			defaultHandlerOptions: {
				'single': true,
				'double': true,
				'pixelTolerance': 0,
				'stopSingle': false,
				'stopDouble': false
			},
			handleRightClicks:true,
			initialize: function(options) {
				this.handlerOptions = OpenLayers.Util.extend(
					{}, this.defaultHandlerOptions
				);
				OpenLayers.Control.prototype.initialize.apply(
					this, arguments
				); 
				this.handler = new OpenLayers.Handler.Click(
					this, this.eventMethods, this.handlerOptions
				);
			},
			CLASS_NAME: "OpenLayers.Control.Click"
		});


		// Add an instance of the Click control that listens to various click events:
		var oClick = new OpenLayers.Control.Click({eventMethods:{
			'rightclick': function(e) {
				console.log('Rightclick');
			},
			'click': function(e) {
				var lonlat = map.getLonLatFromPixel(e.xy);
				handleZoomEvents(lonlat.toShortString());
				/*var lonlat = map.getLonLatFromPixel(e.xy);
                    alert("You clicked near " + lonlat.lat + " N, " +
                                              + lonlat.lon + " E");*/
			}/*, 
			'dblclick': function(e) {
				console.log('dblclick at '+e.xy.x+','+e.xy.y);
			},
			'dblrightclick': function(e) {
				console.log('dblrightclick at '+e.xy.x+','+e.xy.y);
			}*/ 
		}});
		
		map.addControl(oClick);
		oClick.activate();
		
		var handleZoomEvents = function(coord) {
			if (auto) {
				if ((wms.length - 1) > view) {
					wms[view].setVisibility(false);
					
					view++;
					wms[view].setVisibility(true);
					
					getNextFeature(coord, view-1);
				} else {
					wms[view].setVisibility(false);
					
					view = 0;
					wms[view].setVisibility(true);
					
					map.setCenter(home, 8);
				}
			} else {
				
			}
		};
       
       function getNextFeature(coord, view) {
       	showLoader();
       		$.ajax({
       			type: 'post',
       			url: 'data/update.php',
       			data: { action: 'getNextFeature', coord: coord, type: view },
       			success: function(result) {
       				var data = JSON.parse(result);
       				
       				if (data.success) {
       					var bounds = new OpenLayers.Bounds(data.bounds[0], data.bounds[1], data.bounds[2], data.bounds[3]);
       					map.zoomToExtent(bounds);
       					
       					wms[view].redraw(true);
       					setTimeout(function() { hideLoader(); },1000);
       				}
       			}
       		});
       }
       
       function getMouseEventPosition(coord) {
       	$.ajax({
       			type: 'post',
       			url: 'data/update.php',
       			data: { action: 'getLayerPositionData', coord: coord, type: view },
       			success: function(result) {
       				var data = JSON.parse(result);
       				
       				$("#name").text(data.name);
       			}
       		});
       }
       
       function showLoader() {
       	$(".loader").css("display", "block");
       }
       
       function hideLoader() {
       	$(".loader").css("display", "none");
       }
       
       $("#export").click(function() {
       	var layer = layers.split(',')[view];
       	var extent = map.getExtent().toArray();
       	window.open('../cgi-bin/mapserv?MAP=<?php echo $_SESSION['mapfile']; ?>&LAYERS='+layer+'&TRANSPARENT=false&SRS=EPSG%3A3857&FORMAT=image%2Fjpeg&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&BBOX='+extent.join(",")+'&WIDTH=500&HEIGHT=400', '_blank');
       });
       
       $("#test").click(function() {
       	var osm = map.getLayersBy('name', 'OSM')[0];
       	opacity -= 0.1
       	osm.setOpacity(opacity);
       });
       
       var menu1 = [{
       		'Option 1':function(menuItem,menu) { 
       			alert("You clicked Option 1!");
       		}
       	}, 
       	$.contextMenu.separator, 
       	{'Option 2':function(menuItem,menu) { alert("You clicked Option 2!"); } } ]; 
       	$(function() { $('.cmenu1').contextMenu(menu1,{theme:'vista'}); });
       
       });
      </script>

</body>
</html>