<?php
	ini_set("display_errors", 1);
	session_start();
	
	require_once 'data/class.MapServer.php';
	
	header('Content-type: text/html; charset=utf-8');
	// unset($_SESSION['mapfile']);
	$_SESSION['layers'] = "obcina,ko";
	if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	$ms = new MapServer($_SESSION['mapfile']);
	$ms->setLayers(explode(",", $_SESSION['layers']));
	
	$ms->generateMapFile();
	
?>
<!doctype html>
<html lang="en">
  <head>
  	<meta charset="utf-8">
    <link rel="stylesheet" href="http://ol3js.org/en/master/css/ol.css" type="text/css">
    <style>
      .map {
        height: 400px;
        width: 500px;
      }
      .box {
      	background-color: #ffffff;
      	border: 1px solid black;
      	display: none;
      	position: absolute;
      }
    </style>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
    <script src="http://ol3js.org/en/master/build/ol.js" type="text/javascript"></script>
    <title>OpenLayers 3 example</title>
  </head>
  <body>
    <div id="map" class="map"></div>
    <div id="info"></div>
    <div class="span6" id="mouse-position"></div>
    <button id="update">Update</button>
    <label>opacity</label>
	<input id="opacity" type="range" min="0" max="1" step="0.01"/>
	<select id="obmocja"><option value="obala">Obalno-Kraška</option><option value="goriska">Goriška</option><option value="notranjska">Notranjsko-Kraška</option>
		<option value="gorenjska">Gorenjska</option><option value="osrednjeslovenska">Osrednjeslovenska</option><option value="jugovzhod">Jugovzhodna Slovenjia</option>
		<option value="zasavska">Zasavska</option><option value="spodnjeposavska">Spodnjeposavska</option><option value="savinjska">Savinjska</option>
		<option value="koroska">Koroška</option><option value="podravska">Podravska</option><option value="pomurska">Pomurska</option>
	</select>
    <script type="text/javascript">
    var map, view, interval, info = {
            cX: 0,
            cY: 0
        }, obcine, style;
    $(document).ready(function () {

        var scaleLineControl = new ol.control.ScaleLine();
        var mousePositionControl = new ol.control.MousePosition({
            coordinateFormat: ol.coordinate.createStringXY(4),
            projection: 'EPSG:4326',
            className: 'custom-mouse-position',
            target: document.getElementById('mouse-position'),
            undefinedHTML: '&nbsp;'
        });

        var styles = {
            '0': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(10,50,0,0.5)'
                })
            })],
            '1': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(30,170,15,0.5)'
                })
            })],
            '2': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(100,170,30,0.5)'
                })
            })],
            '3': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(10,50,0,0.5)'
                })
            })],
            '4': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(150,170,30,0.5)'
                })
            })],
            '5': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(180,170,30,0.5)'
                })
            })],
            '6': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(180,130,30,0.5)'
                })
            })],
            '7': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(120,50,15,0.5)'
                })
            })],
            '8': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(120,5,5,0.5)'
                })
            })],
            '9': [new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: 'black',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(50,0,0,0.5)'
                })
            })]
        };

        view = new ol.View2D({
            center: ol.proj.transform([14.88, 46.10], 'EPSG:4326', 'EPSG:3857'),
            zoom: 8,
            extent: [
                1474983, 5683129, 1865714, 5929025
            ]
        });

        var geojson = new ol.source.GeoJSON({
            projection: 'EPSG:3857',
            url: 'http://188.226.147.165/data/obcine.php'
            // url: 'http://188.226.147.165:8080/json/1'
            // url: 'data/geojson/out20.json'
        });

        var obcine = new ol.layer.Image({
            source: new ol.source.ImageVector({
                source: geojson,
                style: function (feature, resolution) {
                    // return styles[feature.get('value')];
                    if (typeof feature.get('value') !== "undefined") return styles[feature.get('value')+""];
                    else return styles[(feature.get('ob_mid') + "").substring(0, 1) + ""];
                }
            }),
            minResolution: 80,
            maxResolution: 1000
        });

        map = new ol.Map({
            controls: ol.control.defaults().extend([mousePositionControl, scaleLineControl, new ol.control.FullScreen(),
                new ol.control.ZoomToExtent({
                    extent: [
                        1474983, 5683129, 1865714, 5929025
                    ]
                })
            ]),
            target: 'map',
            layers: [
                new ol.layer.Tile({
                    source: new ol.source.OSM()
                }),
                obcine,
                new ol.layer.Image({
                    source: new ol.source.ImageVector({
                        source: new ol.source.GeoJSON({
                            projection: 'EPSG:3857',
                            url: 'data/geojson/ko20.json'
                        }),
                        style: style
                    }),
                    minResolution: 0,
                    maxResolution: 80
                })
            ],
            view: view
        });

        var featureOverlay = new ol.FeatureOverlay({
            map: map,
            style: new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: '#f00',
                    width: 1
                }),
                fill: new ol.style.Fill({
                    color: 'rgba(255,0,0,0.1)'
                })
            })
        });

        function onMoveEnd(evt) {
            var map = evt.map;
            var zoom = map.getView().getZoom();
            if (zoom < 8) map.getView().setZoom(8);
        }

        map.on('moveend', onMoveEnd);

        var highlight;
        var displayFeatureInfo = function (pixel) {

            var feature = map.forEachFeatureAtPixel(pixel, function (feature, layer) {
                if (map.getView().getResolution() >= 80 && obcine == layer) return feature;
            });

            var info = document.getElementById('info');
            if (feature) {
                info.innerHTML = feature.get('ob_mid') + ': ' + feature.get('ob_ime');
            } else {
                info.innerHTML = '&nbsp;';
            }

            if (feature !== highlight) {
                if (highlight) {
                    featureOverlay.removeFeature(highlight);
                }
                if (feature) {
                    featureOverlay.addFeature(feature);
                }
                highlight = feature;
            }

        };

        var displayFeature = function (pixel) {

            var feature = map.forEachFeatureAtPixel(pixel, function (feature, layer) {
                return feature;
            });

            var polygon = /** @type {ol.geom.SimpleGeometry} */ (feature.getGeometry());
            var size = /** @type {ol.Size} */ (map.getSize());
            view.fitGeometry(
                polygon,
                size, {
                    padding: [170, 50, 30, 150],
                    constrainResolution: false
                }
            );

            /*var info = document.getElementById('info');
  if (feature) {
    info.innerHTML = feature.get('ob_mid') + ': ' + feature.get('ob_ime');
  } else {
    info.innerHTML = '&nbsp;';
  }

  if (feature !== highlight) {
    if (highlight) {
      featureOverlay.removeFeature(highlight);
    }
    if (feature) {
      featureOverlay.addFeature(feature);
    }
    highlight = feature;
  }*/

        };

        $(map.getViewport()).on('mousemove', function (evt) {
            var pixel = map.getEventPixel(evt.originalEvent);
            displayFeatureInfo(pixel);
        });

        map.on('singleclick', function (evt) {
            displayFeature(evt.pixel);
        });

        /*map.on('singleclick', function(evt) {
  		var coordinate = evt.coordinate;
  		var hdms = ol.coordinate.toStringHDMS(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326'));
      		
      	$.ajax({
      		url: 'data/update.php',
      		type: 'post',
      		data: { action: 'toggleLayerSelect', zoom: view.getZoom(), coord: evt.coordinate.join(", ") },
      		success: function(data) {
      			var params = layer.getSource().getParams();
				params.SHA = getUniqueParam();
				layer.getSource().updateParams(params);
      		}
      	});

  		/*alert(hdms);
  		console.log(evt.coordinate);
  		console.log(ol.coordinate.toStringXY(ol.proj.transform(
      		coordinate, 'EPSG:3857', 'EPSG:4326')));*./

	});*/

        /*$(map.getViewport()).on('mousemove', function(evt) {
		clearInterval(interval);
		interval = setTimeout(function() {
			hideInfo();
			info.cX = evt.clientX;
			info.cY = evt.clientY;
			$("#info").html('<div id="inner">' + ol.proj.transform(map.getEventCoordinate(evt), 'EPSG:3857', 'EPSG:4326')[0] + '</div>');
			showInfo("info");
			// $("#info").text(ol.proj.transform(map.getEventCoordinate(evt), 'EPSG:3857', 'EPSG:4326'));
		}, 1000);
	});*/


        var opacity = new ol.dom.Input(document.getElementById('opacity'));
        opacity.bindTo('value', obcine, 'opacity')
            .transform(parseFloat, String);

        $("#update").click(function () {
            // layer.getSource().updateParams({layers: 'obcina'});
            
            $.ajax({
	      		url: 'data/random.php',
	      		type: 'post',
	      		data: { action: 'getValues' },
	      		success: function(data) {
	      			data = JSON.parse(data);
	      			var arr = $.map(data, function (value, key) { return value; });
	      			
	      			var ids = [];
	      			var vals = [];
	      			
	      			for (item in arr) {
	      				ids.push(arr[item].id);
	      				vals.push(arr[item].value);
	      			}
	      			
	      			geojson.forEachFeature(function (feature) {
		                // feature.set('ob_mid', getRandomNum());
		                var i = ids.indexOf(feature.get('ob_mid')+"");
		                feature.set('value', vals[i]);
		            });
	      		}
	      	});
        });

        $("#inner").click(function () {
            hideInfo();
        });

        $("#obmocja").change(function (value) {
            var valueSelected = this.value;

            var center = [14.88, 46.10];

            switch (valueSelected) {
            case 'obala':
                center = [13.8, 45.65];
                break;
            case 'goriska':
                center = [13.71, 46.1];
                break;
            case 'notranjska':
                center = [14.3, 45.7];
                break;
            case 'gorenjska':
                center = [14.36, 45.98];
                break;
            case 'osrednjeslovenska':
                center = [14.08, 46.33];
                break;
            case 'jugovzhod':
                center = [15.03, 45.77];
                break;
            case 'zasavska':
                center = [14.95, 46.15];
                break;
            case 'spodnjeposavska':
                center = [15.13, 46.33];
                break;
            case 'savinjska':
                center = [15.38, 45.98];
                break;
            case 'koroska':
                center = [15.13, 46.56];
                break;
            case 'podravska':
                center = [15.85, 46.52];
                break;
            case 'pomurska':
                center = [16.25, 46.68];
                break;
            default:
                break;
            }

            var duration = 2000;
            var start = +new Date();
            var pan = ol.animation.pan({
                duration: duration,
                source: /** @type {ol.Coordinate} */ (view.getCenter()),
                start: start
            });
            
            var val = (map.getView().getZoom() < 10) ? 2 : 1;
            
            var bounce = ol.animation.bounce({
                duration: duration,
                resolution: val * view.getResolution(),
                start: start
            });
            map.beforeRender(pan, bounce);
            view.setCenter(ol.proj.transform(center, 'EPSG:4326', 'EPSG:3857'));
            view.setZoom(10);
        });
    });

    function getUniqueParam() {
        return Math.random().toString(36).substring(5);
    };

    function clearInfo() {
        var dd = document.getElementById("info");
        dd.style.display = "none";
    };

    function showInfo(d) {
        if (d.length < 1) {
            return;
        }
        var dd = document.getElementById("info"); //problem, če element s tem imenom ne obstaja IE
        $("#info-text").text(d);
        assignPosition(dd);
        dd.style.display = "block";
    };

    function hideInfo() {
        var dd = document.getElementById("info");
        dd.style.display = "none";
    };

    function assignPosition(d) {

        if (self.pageYOffset) {
            rX = self.pageXOffset;
            rY = self.pageYOffset;
        } else if (document.documentElement && document.documentElement.scrollTop) {
            rX = document.documentElement.scrollLeft;
            rY = document.documentElement.scrollTop;
        } else if (document.body) {
            rX = document.body.scrollLeft;
            rY = document.body.scrollTop;
        }

        if (document.all) {
            info.cX += rX;
            info.cY += rY;
        }

        d.style.left = (info.cX + 10) + "px";
        d.style.top = (info.cY + 10) + "px";
    };

    function updateCursorPosition(e) {
        var ev = e || window.event;

        info.cX = ev.pageX ? ev.pageX : (ev.clientX + document.body.scrollLeft);
        info.cY = ev.pageY ? ev.pageY : (ev.clientY + document.body.scrollTop);

        if (info.cX < 0) Gis.info.cX = 0;
        if (info.cY < 0) Gis.info.cY = 0;
    };

    function getRandomNum() {
        return Math.floor((Math.random() * 10));
    };
    </script>
  </body>
</html>