# Major enhancements and additions

## Zoom Control

A simple control to add zoom in/out buttons on the map that can be entirely styled using CSS.
See it live in this [example](http://openlayers.org/dev/examples/zoom.html).

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/291
 * https://github.com/openlayers/openlayers/pull/292

## Builds

This version of OpenLayers ships with three builds:

 * `OpenLayers.js`
 * `OpenLayers.light.js`
 * `OpenLayers.mobile.js`

See the README.md file and the docs on docs.openlayers.org for more information.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/254
 * https://github.com/openlayers/openlayers/pull/261

## style.mobile.css

The theme/default directory now includes a mobile-specific CSS file, namely
style.mobile.css. The OpenLayers mobile examples use this file. To use it
in your mobile pages use tags like this:

<link rel="stylesheet" href="openlayers/theme/default/style.mobile.css" type="text/css">

(This file used to be in the examples/ directory).

## Sensible projection defaults

The geographic and web mercator projections define default values for the maxExtent, and units. This simplifies the map and layer configuration.

For example, a map that used to be created with this:

    map = new OpenLayers.Map({
        div: "map",
        projection: "EPSG:900913",
        units: "m",
        maxExtent: new OpenLayers.Bounds(
            -20037508.34, -20037508.34, 20037508.34, 20037508.34
        )
    });

can now be created with this:

    map = new OpenLayers.Map({
        div: "map",
        projection: "EPSG:900913"
    });

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/219

## Tile Offline Storage

With the new `OpenLayers.Control.CacheRead` and `OpenLayers.Control.CacheWrite` controls, applications can cache tiles for offline use or for use with slow connections.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/301

## Tile Animation

The displaying of tiles can now be animated, using CSS3 transitions. Transitions operate on the `opacity` property. Here's the CSS rule defined in OpenLayers' default theme:

    .olLayerGrid .olTileImage {
        -webkit-transition: opacity 0.2s linear;
        -moz-transition: opacity 0.2s linear;
        -o-transition: opacity 0.2s linear;
        transition: opacity 0.2s linear;
    }

People can override this rule to use other transition settings. To remove tile animation entirely use:

    .olLayerGridTile .olTileImage {
        -webkit-transition: none;
        -moz-transition: none;
        -o-transition: all 0 none;
        transition: none;
    }

Note that by default tile animation is not enabled for single tile layers.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/127

## Tile Queue

The tiling code has been overhauled so tile loading in grid layers is now done in a queue.
The tile queue gives more control on the tile requests sent to the server. Pending requests for tiles that are not needed any more (e.g. after zooming or panning) are avoided, which increases performance and reduces server load.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/179

## Tile Canvas

Image tiles expose a `getCanvasContext` function that can be used for various
things, like changing the image pixels, save the image using the File API, etc.

See the [osm-grayscale
example](http://openlayers.org/dev/examples/osm-grayscale.html).

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/160

## Tile Interaction Event Improvements

The layer's `tileloaded` event now returns a reference to the loaded tile. The new `tileloaderror` event does the same, and is fired when a tile could not be loaded.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/283

## Tile and Backbuffer Overhaul

The whole image tile and backbuffer code (behind `transitionEffect:resize`) has been redesigned and
rewritten. This overhaul yields better performance and code simplifications.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/16

## Continuous Zooming

Tile layers can now be displayed at resolutions not supported by their tiling
services. This works by requesting tiles at higher resolutions and stretching
the layer div as appropriate. With this change fractionalZoom:true will work
for single tile layers as well as for tiled layers.

See the [client zoom
example](http://openlayers.org/dev/examples/clientzoom.html).

Corresponding issues/pull requests:

 * http://trac.osgeo.org/openlayers/ticket/3531
 * https://github.com/openlayers/openlayers/pull/5

# Behavior Changes from Past Releases

## MultiMap Layer Removal

The `OpenLayers.Layer.MultiMap` class has been removed entirely, as the MultiMap service was discontinued.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/328

## GPX API change

The `gpxns` API property has been removed. The GPX namespace is now defined in the `namespaces` property but is not intended to be overriden.

GPX also now has a basic write function.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/221

## Function return values

Previously a few functions in the library displayed error messages and returned `undefined`, `null` or `false` if the parameters passed in were bad. In 2.12 these functions now just throw an error/exception. People relying on return values to know if a function call is successful may need to change their code. Here are the modified functions:

 * `OpenLayers.Bounds.add` throws a `TypeError` exception if `x` or `y` is null
 * `OpenLayers.LonLat.add` throws a `TypeError` exception if `lon` or `lat` is null
 * `OpenLayers.Pixel.add` throws a `TypeError` exception if `x` or `y` is null
 * `OpenLayers.Filter.Comparison.value2regex` throws an `Error` exception if `wildcard` equals to `"."`
 * `OpenLayers.Layer.PointTrack.addNodes` throws a `TypeError` exception if `endPoint` isn't actually a point
 * `OpenLayers.Layer.Vector.getFeatureFromEvent` throws an `Error` exception if the layer has no renderer

Corresponding issues/pull requests:

 * http://trac.osgeo.org/openlayers/ticket/3320

## Changes in formats WMTSCapabilities and SOSCapabilities

The structure of the object returned by `Format.WMTSCapabilities:read` and `Format.SOSCapabilities:read` has slightly changed.

For `WMTSCapabilities` the GET href used to be made available at `operationsMetadata.GetCapabilities.dcp.http.get`, the latter is now an array of objects with two properties: `url` and `constrains`. People using `operationsMetadata.GetCapabilities.dcp.http.get` in their applications should certainly use `operationsMetadata.GetCapabilities.dcp.http.get[0].url`.

Likewise for `SOSCapabilities`.

Looking at the tests is a good way to understand what the requires changes are. See [SOSCapabilities/v1_0_0.html](https://github.com/openlayers/openlayers/blob/master/tests/Format/SOSCapabilities/v1_0_0.html) and [WMTSCapabilities/v1_0_0.html](https://github.com/openlayers/openlayers/blob/master/tests/Format/WMTSCapabilities/v1_0_0.html).

Corresponding issues/pull requests:

 * http://trac.osgeo.org/openlayers/ticket/3568
 * https://github.com/openlayers/openlayers/pull/40


## Rico deprecation

We are deprecating the Rico classes/objects in OpenLayers. This has the following implications:

`Popup.AnchoredBubble` is deprecated. Its constructor now displays a deprecation message on the console. If you want popups with rounded corners either use `Popup.FramedClould`, or use `Popup.Anchored` and round corners using the [border-radius](https://developer.mozilla.org/en/CSS/border-radius) CSS property.

The `roundedCorner` option of `Control.LayerSwitcher` is deprecated, and it now defaults to `false`. Setting it to true results in deprecation messages being output on the console. If you still want to set `roundedCorner` to `true` (you should not!) you need to make sure that the Rico/Corner.js and Rico/Color.js scripts are loaded in the page. This can be ensured by adding Rico/Corner.js in the build profile. The controls.html example demonstrates how to use `border-radius` to round corners of a layer switcher:


    .olControlLayerSwitcher .layersDiv {
        border-radius: 10px 0 0 10px;
    }


In future releases we intend to move the Rico and `AnchoredBubble` code into deprecated.js. You really should consider stop using Rico-based functionalities in your applications.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/99

## Changes in Geometry

The base `OpenLayers.Geometry` class no longer depends on `OpenLayers.Format.WKT` or `OpenLayers.Feature.Vector`.  If you want to make use of the `OpenLayers.Geometry.fromWKT` method, you must explicitly include the OpenLayers/Format/WKT.js file in your build.  

Without the WKT format included (by default), the `OpenLayers.Geometry::toString` method now returns "[object Object]."  Previously, it returned the Well-Known Text representation of the geometry.  To maintain the previous behavior, include the OpenLayers/Format/WKT.js file in your build.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/101

## Google v3 Layer

This release fixes a problem with the clickable elements supplied by Google. `OpenLayers.Layer.Google.v3` is now compatible with the current frozen version of Google's API (3.7) and also with the current release and nightly versions (3.8 and 3.9), but be aware that Google may change these elements in their release and nightly versions at any time, and an interim fix OpenLayers release may be needed.

It's recommended that production servers always load the frozen version of Google's API, but it would help find potential problems if development pages used the latest nightly version.

See the class description in the API docs for `OpenLayers.Layer.Google.v3` for more details.

Good ideas on how to improve this unsatisfactory situation welcome!

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/472

## OSM and Bing Layers

`Layer.OSM` is now defined in its own script file, namely `OpenLayers/Layer/OSM.js`. So people using `Layer.OSM` should now include `OpenLayers/Layer/OSM.js`, as opposed to `OpenLayers/Layer/XYZ.js`, in their OpenLayers builds.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/issues/138
 * https://github.com/openlayers/openlayers/pull/144

The `OpenLayers.Tile.Image` class now has a method to get a canvas context for processing tiles. Since both OSM and Bing set Access-Control-Allow-Origin headers for their tiles, it is possible to manipulate a canvas that these tiles were rendered to even if the tiles come from a remote origin. Especially when working with custom OSM tilesets from servers that do not send Access-Control-Allow-Origin headers, it is now necessary to configure the layer with

    tileOptions: {crossOriginKeyword: null}

Both `OpenLayers.Layer.OSM` and `OpenLayers.Layer.Bing` do not have defaults for `maxExtent`, `maxResolutions` and `units` any more. This may break maps that are configured with a `maxResolution` of `156543.0339`, which was used in examples before 2.11, but is incorrect. The correct value is `156543.03390625`, but it is no longer necessary to specify a maxResolution, maxExtent and units if the correct resolution is set. See "Projection and Spherical Mercator" below.

## Projection & SphericalMercator

When working with Web Mercator layers (e.g. Google, Bing, OSM), it was previously necessary to configure the map or the base layer with the correct `projection`, `maxExtent`, `maxResolutions` and `units`. Now OpenLayers has defaults for WGS84 and Web Mercator in `OpenLayers.Projection.defaults`, so it is enough to provide the `projection`.

Old:

    new OpenLayers.Map({
        div: "map",
        projection: "EPSG:900913",
        maxResolution: 156543.03390625,
        maxExtent: new OpenLayers.Bounds(-20037508.34, -20037508.34, 20037508.34, 20037508.34),
        units: "m",
        layers: [
            new OpenLayers.Layer.Google("Google Streets"),
            new OpenLayers.Layer.OSM(null, null, {isBaseLayer: false, opacity: 0.7})
        ],
        zoom: 1
    });

New:

    new OpenLayers.Map({
        div: "map",
        projection: "EPSG:900913",
        layers: [
            new OpenLayers.Layer.Google("Google Streets"),
            new OpenLayers.Layer.OSM(null, null, {isBaseLayer: false, opacity: 0.7})
        ],
        zoom: 1
    });

In previous releases, coordinate transforms between EPSG:4326 and EPSG:900913 were defined in the SphericalMercator.js script.  In 2.12, these default transforms are included in the Projection.js script.  The Projection.js script is included as a dependency in builds with any layer types, so no special build configuration is necessary to get the web mercator transforms.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/219

If you were previously using the `OpenLayers.Layer.SphericalMercator.forwardMercator` or `inverseMercator` methods, you may have to explicitly include the SphericalMercator.js script in your build.  The Google layer is the only layer that depends on the SphericalMercator mixin.  If you are not using the Google layer but want to use the SphericalMercator methods listed above, you have to explicitly include the SphericalMercator.js script in your build.

Corresponding issues/pull requests:

* https://github.com/openlayers/openlayers/pull/153

## QueryStringFilter

`OpenLayers.Protocol.HTTP` no longer requires `OpenLayers.Format.QueryStringFilter`. It you need this, make sure it is included in your build config file.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/issues/147
 * https://github.com/openlayers/openlayers/pull/148

## Changes in getURLasync

The internal `OpenLayers.Layer.getURLasync` function now take a bound, a callback and a scope. The function no longer needs update the passed property but simply to return to url.

## Changes when base layer configured with wrapDateLine: true

Vector editing across the date line works reliably now. To make this work, OpenLayers won't zoom out to resolutions where more than one world is visible any more. For maps that have base layers with wrapDateLine set to false, no zoom restrictions apply.

## OpenLayers.Util.onImageLoadError no longer exists

To replace a tile that couldn't be loaded with a static image, create a css selector for the `.olImageLoadError` class (e.g. a `background-image`).

For more complex tile loading error handling, register a listener to the layer's `tileerror` event.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/283

## Deprecated Components

A number of properties, methods, and constructors have been marked as deprecated for multiple releases in the 2.x series.  For the 2.12 release this deprecated functionality has been moved to a separate deprecated.js file.  If you use any of the constructors or methods below, you will have to explicitly include the deprecated.js file in your build (or add it in a separate `<script>` tag after OpenLayers.js).

 * OpenLayers.Class.isPrototype
 * OpenLayers.Class.create
 * OpenLayers.Class.inherit
 * OpenLayers.Util.clearArray
 * OpenLayers.Util.setOpacity
 * OpenLayers.Util.safeStopPropagation
 * OpenLayers.Util.getArgs
 * OpenLayers.nullHandler
 * OpenLayers.loadURL
 * OpenLayers.parseXMLString
 * OpenLayers.Ajax.* (all methods)
 * OpenLayers.Element.hide
 * OpenLayers.Element.show
 * OpenLayers.Element.getDimensions
 * OpenLayers.Tile.prototype.getBoundsFromBaseLayer
 * OpenLayers.Control.MouseDefaults
 * OpenLayers.Control.MouseToolbar
 * OpenLayers.Layer.Grid.prototype.getGridBounds
 * OpenLayers.Format.XML.prototype.concatChildValues
 * OpenLayers.Layer.WMS.Post
 * OpenLayers.Layer.WMS.Untiled
 * OpenLayers.Layer.MapServer.Untiled
 * OpenLayers.Tile.WFS
 * OpenLayers.Feature.WFS
 * OpenLayers.Layer.WFS
 * OpenLayers.Layer.VirtualEarth
 * OpenLayers.Protocol.SQL
 * OpenLayers.Protocol.SQL.Gears
 * OpenLayers.Layer.Yahoo
 * OpenLayers.Layer.GML
 * OpenLayers.Geometry.Rectangle
 * OpenLayers.Renderer.NG
 * OpenLayers.Renderer.SVG2

In addition, OpenLayers no longer modifies any native prototypes or objects by default.  If you rely on any of the following, you'll need to include deprecated.js explicitly to get the same behavior.

 * String.prototype.startsWith
 * String.prototype.contains
 * String.prototype.trim
 * String.prototype.camelize
 * Function.prototype.bind
 * Function.prototype.bindAsEventListener
 * Event.stop

