<?php 

/**
 * class input parameters are $db class 
 * and table = _research or _projects 
 * and workTable = _research or _projects table name
 * and idResProj = ID of research or project 
 */
class Labels {
	
	protected $db;
	protected $table;
	protected $workTable;
	protected $idResProj;
	
	protected $properties; 
	
	public function __construct($db,$table,$workTable,$idResProj) {
		$this->db = $db;	
		$this->table = $table;
		$this->workTable = $workTable;
		$this->idResProj = $idResProj;
	}

	
	public function setQuestion($var) {
		$this->question = $var;  
		
		return true;
	}
	
	
	public function getParameters() {
		if (isset($this->properties)) return $this->properties;
		
		$sql = "SELECT `questionType`, `questionVars`, `questionSubType`, `id_tableTemplate`, `id_graphTemplate`, `missings`, `hideAnswers` 
				FROM ".$this->workTable."___calculated WHERE questionName='".$this->question."'";
		//echo $sql."<br>";
		$result = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		$this->properties['questionVars'] = explode(",",$row['questionVars']);
		$this->properties['missings'] = $row['missings'];
		$this->properties['hideAnswers'] =$row['hideAnswers'];
		$this->properties['questionType'] = $row['questionType'];
		$this->properties['questionSubType'] = $row['questionSubType'];
		$this->properties['id_tableTemplate'] = $row['id_tableTemplate'];
		$this->properties['id_graphTemplate'] = $row['id_graphTemplate'];
				
		return $this->properties;
	}
	
	
	public function getLabels() {
		$sql = "SELECT `instruction`, `question`, `answer`, `legend`, `category`, `title`, 
				`graph_instruction`, `graph_question`, `graph_answer`, `graph_legend`, `graph_category`, `graph_title` 
				FROM ".$this->workTable."___calculated WHERE questionName='".$this->question."'";
		//echo $sql."<br>";
		$result = $this->db->SQLexecute($sql);
		$row = $this->db->fetchAssoc($result);
		
		$answers = $this->getAnswers($row['answer']);
		$legend = $this->getLegend($row['legend']);
		$category = $this->getCategory($row['category']);
		$instruction = $this->getInstruction($row['instruction']);
		$question = $this->getQuestion($row['question']);
		$title = $this->getTitle($row['title']);

		$answersGraph = $this->getAnswers($row['graph_answer']);
		$legendGraph = $this->getLegend($row['graph_legend']);
		$categoryGraph = $this->getCategory($row['graph_category']);
		$instructionGraph = $this->getInstruction($row['graph_instruction']);
		$questionGraph = $this->getQuestion($row['graph_question']);
		$titleGraph = $this->getTitle($row['graph_title']);
		
		$arr['title'] = $title;
		$arr['instruction'] = $instruction;
		$arr['question'] = $question;
		$arr['answers'] = $answers;
		$arr['legend'] = $legend;
		$arr['category'] = $category;
		
		if (!$answersGraph) $answersGraph = $answers;
		if (!$legendGraph) $legendGraph = $legend;
		if (!$categoryGraph) $categoryGraph = $category;
		if (!$instructionGraph) $instructionGraph = $instruction;
		if (!$questionGraph) $questionGraph = $question;
		if (!$titleGraph) $titleGraph = $title;
		
		$arr['graph_title'] = $titleGraph;
		$arr['graph_instruction'] = $instructionGraph;
		$arr['graph_question'] = $questionGraph;
		$arr['graph_answers'] = $answersGraph;
		$arr['graph_legend'] = $legendGraph;
		$arr['graph_category'] = $categoryGraph;
		
		$labs[$this->question] = $arr;
		return $labs;
	}
	
	
	protected function getAnswers($str) {
		if (strlen($str) == 0) return null;
		$str = strip_tags($str);
		$arr = explode("/",$str);
		foreach($arr as $item) {
			$labarr = explode(" ",$item,2);
			$ans[$labarr[0]] = $labarr[1];
		}
		
		return $ans;
	}
	
	
	protected function getLegend($str) {
		if (strlen($str) == 0) return null;
		$ans = $this->getAnswers($str);
		
		return $ans;
	}
	
	
	protected function getCategory($str) {
		if (strlen($str) == 0) return null;
		$ans = $this->getAnswers($str);
		
		return $ans;
	}
	
	
	protected function getInstruction($str) {
		if (strlen($str) == 0) return null;
		
		return strip_tags($str);
	}
	
	
	protected function getQuestion($str) {
		if (strlen($str) == 0) return null;
		
		return strip_tags($str);
	}
	
		
	protected function getTitle($str) {
		if (strlen($str) == 0) return null;
		
		return strip_tags($str);
	}
	
		
	
}