<?php 

class ProjectGenerator 
{
	
	protected $db;
	protected $sel;
		
	public function __construct($db, $sel) {
		$this->db = $db;	
		$this->sel = $sel;	
	}
	
	public function resInProj($projId, $resId) {
		$sql = "SELECT * FROM _projects_by_research where id_project=".mysql_real_escape_string($projId)." AND id_research=".mysql_real_escape_string($resId);
		if($result=$this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			return false;
		}
	}
	
	public function projExist($projName) {	 
		$sql = "SHOW TABLES LIKE '".$projName."___calculated'"; 
		if($result=$this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			return false;
		}
	}
	
	public function isInProjCalc($projName, $qName) {
		$sql = "SELECT * FROM ".$projName."___calculated where questionName='".mysql_real_escape_string($qName)."'";
		if($result=$this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			return false;
		}
	}
	
	public function isInProjEvents($projName, $qName) {
		$sql = "SELECT * FROM ".$projName."___events where id_question='".mysql_real_escape_string($qName)."'";
		if($result = $this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			echo $this->db->JsonError();
		}
	}
	
	protected function checkIfField($table, $field) {
		$sql = "SHOW COLUMNS FROM ".$table." LIKE '".mysql_real_escape_string($field)."'";
		if($result = $this->db->SQLexecute($sql)){
			if ($this->db->NumRows($result) > 0) {
				return true;
			}
			else {
				return false;
			}
		} else {	
			echo $this->db->JsonError();
		}
	}
	
	protected function getOtherResInProj($projId, $resId) {
		$sql = "SELECT id_research FROM _projects_by_research WHERE id_project=".mysql_real_escape_string($projId)." AND id_research != ".mysql_real_escape_string($resId); 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[]=$row['id_research'];
			}	
			return $arr;
		} else {
			return false;
		}
	}
	
	protected function getResFileds($resName) {
		$sql = "SELECT questionName FROM ".$resName."___calculated"; 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$arr[]=$row['questionName'];
			}	
			return $arr;
		} else {
			return false;
		}
		
	}
	
	public function removeResFromProj($projId, $resId) {
		$projName = str_replace(" ", "_", $this->sel->getProjectName($projId));
		$resName = str_replace(" ", "_", $this->sel->getResearcheName($resId));
		
		$otherResInProj = $this->getOtherResInProj($projId, $resId);
		$allOtherFields = array();
		
		foreach($otherResInProj as $r) {
			$rName = str_replace(" ", "_", $this->sel->getResearcheName($r));
			$resFields = $this->getResFileds($rName);
			foreach($resFields as $f) {
				$allOtherFields[] = $f;
			}
		}
		
		$allOtherFields = array_unique($allOtherFields);
		$allFields = $this->getResFileds($resName);
		
		foreach($allFields as $f) {
			if(!in_array($f, $allOtherFields)) {
				$sqlCalc = "DELETE FROM ".$projName."___calculated WHERE questionName = '".mysql_real_escape_string($f)."'";
				$sqlEven = "DELETE FROM ".$projName."___events WHERE id_question = '".mysql_real_escape_string($f)."'";
				$this->db->SQLexecute($sqlCalc);
				$this->db->SQLexecute($sqlEven);
			}
		}
		
		$sqlData = "DELETE FROM ".$projName."___data WHERE research_id = ".mysql_real_escape_string($resId);
		$this->db->SQLexecute($sqlData);	
	}	
	
	public function createNewProj($projId, $resId) {
		$projName = str_replace(" ", "_", $this->sel->getProjectName($projId));
		$resName = str_replace(" ", "_", $this->sel->getResearcheName($resId));
		
		//Naredimo osnovna ogrodja tabel
		$this->createBasicStructure($projName);
		
		// Kopiramo podatke tabel za raziskave v projekt
		$this->copyResIntoProj($projName, $resName, $resId);
	}
	
	public function addResToProj($projId, $resId) {
		$projName = str_replace(" ", "_", $this->sel->getProjectName($projId));
		$resName = str_replace(" ", "_", $this->sel->getResearcheName($resId));
		$firstFieldName = '';

		//echo $projName.$resName;
		
		
		$sql = "SELECT * FROM ".$resName."___calculated "; 
		if($result=$this->db->SQLexecute($sql)){
			$first = true;
			while($row = $this->db->fetchAssoc($result)) {
				if($first) {
					if($row['questionVars']) {
						$vars = explode(",",$row['questionVars']);
					}
					$firstFieldName = ($row['questionVars'])?$vars[0]:$row['questionName'];
					$first = false;
				}
				if(!$this->isInProjCalc($projName, $row['questionName'])) {			
					$sqlCalc = "INSERT INTO ".$projName."___calculated ";
					$sqlCalc .= " SET id_question='".mysql_real_escape_string($row['id_question'])."'";
					$sqlCalc .= ", questionName='".mysql_real_escape_string($row['questionName'])."'";
					$sqlCalc .= ", questionVars='".mysql_real_escape_string($row['questionVars'])."'";				
					$sqlCalc .= ($row['questionType'])?", questionType=".mysql_real_escape_string($row['questionType']):'';
					$sqlCalc .= ($row['questionSubType'])?", questionSubType=".mysql_real_escape_string($row['questionSubType']):'';
					$sqlCalc .= ($row['questionOpenCount'])?", questionOpenCount=".mysql_real_escape_string($row['questionOpenCount']):'';				
					$sqlCalc .= ", instruction='".mysql_real_escape_string($row['instruction'])."'";
					$sqlCalc .= ", question='".mysql_real_escape_string($row['question'])."'";
					$sqlCalc .= ", answer='".mysql_real_escape_string($row['answer'])."'";
					$sqlCalc .= ", legend='".mysql_real_escape_string($row['legend'])."'";			
					$sqlCalc .= ", category='".mysql_real_escape_string($row['category'])."'";			
					$sqlCalc .= ", title='".mysql_real_escape_string($row['title'])."'";
					$sqlCalc .= ", graph_instruction='".mysql_real_escape_string($row['graph_instruction'])."'";			
					$sqlCalc .= ", graph_question='".mysql_real_escape_string($row['graph_question'])."'";			
					$sqlCalc .= ", graph_answer='".mysql_real_escape_string($row['graph_answer'])."'";			
					$sqlCalc .= ", graph_legend='".mysql_real_escape_string($row['graph_legend'])."'";				
					$sqlCalc .= ", graph_category='".mysql_real_escape_string($row['graph_category'])."'";
					$sqlCalc .= ", graph_title='".mysql_real_escape_string($row['graph_title'])."'";			
					$sqlCalc .= ", data='".mysql_real_escape_string($row['data'])."'";			
					$sqlCalc .= ($row['id_tableTemplate'])?", id_tableTemplate=".mysql_real_escape_string($row['id_tableTemplate']):'';			
					$sqlCalc .= ($row['id_graphTemplate'])?", id_graphTemplate=".mysql_real_escape_string($row['id_graphTemplate']):'';			
					$sqlCalc .= ", missings='".mysql_real_escape_string($row['missings'])."'";
					$sqlCalc .= ", hideAnswers='".mysql_real_escape_string($row['hideAnswers'])."'";				
					$sqlCalc .= ($row['hideQuestion'])?", hideQuestion=".mysql_real_escape_string($row['hideQuestion']):'';
					$sqlCalc .= ", comment='".mysql_real_escape_string($row['comment'])."'";			
					$sqlCalc .= ", crosstabVariables='".mysql_real_escape_string($row['crosstabVariables'])."'";
					//echo $sqlCalc;
					if(!$resultCalc=$this->db->SQLexecute($sqlCalc)){
						return $this->db->JsonError();
					}				
				}
			}
		}
		
		$sql = "SELECT * FROM ".$resName."___events "; 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				//echo $row['id_question'];
				if(!$this->isInProjEvents($projName, $row['id_question'])) {
					$sqlEvents = "INSERT INTO ".$projName."___events ";
					$sqlEvents .= " SET id_question='".mysql_real_escape_string($row['id_question'])."'";
					$sqlEvents .= ", eventName='".mysql_real_escape_string($row['eventName'])."'";
					$sqlEvents .= ", event='".mysql_real_escape_string($row['event'])."'";
					$sqlEvents .= ($row['eventTime'])?", eventTime=".mysql_real_escape_string($row['eventTime']):'';
					
					if(!$resultEvents=$this->db->SQLexecute($sqlEvents)){
						return $this->db->JsonError();
					}
				}
			}
		}
		
		
		$sql = "DESCRIBE ".$resName."___data ";
		if($result=$this->db->SQLexecute($sql)){
			$quest = false;
			$questFields = array();
			while($row = $this->db->fetchAssoc($result)) {
				if($row['Field'] == $firstFieldName) $quest = true;
				if($quest) { 
					$questFields[] = $row['Field'];
					if(!$this->checkIfField($projName."___data", $row['Field'])) {
						$altSql = "ALTER TABLE ".$projName."___data ADD ".mysql_real_escape_string($row['Field'])." ".mysql_real_escape_string($row['Type']).";";
						if(!$resultData=$this->db->SQLexecute($altSql)){
							return $this->db->JsonError();
						}
					}
				}							
			}
		}
		
		$sql = "SELECT * FROM ".$resName."___data "; 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$sqlData = "INSERT INTO ".$projName."___data SET ";
				$sqlData .= " research_id=".mysql_real_escape_string($resId);
				$sqlData .= (isset($row['unweight']))?", unweight=".mysql_real_escape_string($row['unweight']):'';
				$sqlData .= (isset($row['weight']))?", weight=".mysql_real_escape_string($row['weight']):'';
				$sqlData .= (isset($row['user_id']))?", user_id=".mysql_real_escape_string($row['user_id']):'';
				$sqlData .= (isset($row['user_type']))?", user_type=".mysql_real_escape_string($row['user_type']):'';
				$sqlData .= (isset($row['id_device']))?", id_device=".mysql_real_escape_string($row['id_device']):'';
				$sqlData .= (isset($row['id_language']))?", id_language=".mysql_real_escape_string($row['id_language']):'';
				$sqlData .= (isset($row['id_site']))?", id_site='".mysql_real_escape_string($row['id_site'])."'":'';
				$sqlData .= (isset($row['status']))?", status=".mysql_real_escape_string($row['status']):'';
				$sqlData .= (isset($row['status_rec']))?", status_rec=".mysql_real_escape_string($row['status_rec']):'';
				$sqlData .= (isset($row['flag_bad']))?", flag_bad=".mysql_real_escape_string($row['flag_bad']):'';
				$sqlData .= (isset($row['t_start']))?", t_start=".mysql_real_escape_string($row['t_start']):'';
				$sqlData .= (isset($row['t_stop']))?", t_stop=".mysql_real_escape_string($row['t_stop']):'';
				foreach($questFields as $q) {
					if($row[$q]) {
						$sqlData .= (is_numeric($row[$q]))?", ".mysql_real_escape_string($q)."=".mysql_real_escape_string($row[$q]) : ", ".mysql_real_escape_string($q)."='".mysql_real_escape_string($row[$q])."'";
					}
				}
				//echo $sqlData;
				if(!$resultData=$this->db->SQLexecute($sqlData)){
					return $this->db->JsonError();
				}	
			}
		}
		
		
	}
	
	private function copyResIntoProj($projName, $resName, $resId) {
		$sql = "SELECT * FROM ".$resName."___calculated "; 
		$firstFieldName = '';
		if($result=$this->db->SQLexecute($sql)){
			$first = true;
			while($row = $this->db->fetchAssoc($result)) {
				if($first) {
					if($row['questionVars']) {
						$vars = explode(",",$row['questionVars']);
					}
					$firstFieldName = ($row['questionVars'])?$vars[0]:$row['questionName'];
					$first = false;
				}
				$sqlCalc = "INSERT INTO ".$projName."___calculated ";
				$sqlCalc .= " SET id_question='".mysql_real_escape_string($row['id_question'])."'";
				$sqlCalc .= ", questionName='".mysql_real_escape_string($row['questionName'])."'";
				$sqlCalc .= ", questionVars='".mysql_real_escape_string($row['questionVars'])."'";				
				$sqlCalc .= ($row['questionType'])?", questionType=".mysql_real_escape_string($row['questionType']):'';
				$sqlCalc .= ($row['questionSubType'])?", questionSubType=".mysql_real_escape_string($row['questionSubType']):'';
				$sqlCalc .= ($row['questionOpenCount'])?", questionOpenCount=".mysql_real_escape_string($row['questionOpenCount']):'';				
				$sqlCalc .= ", instruction='".mysql_real_escape_string($row['instruction'])."'";
				$sqlCalc .= ", question='".mysql_real_escape_string($row['question'])."'";
				$sqlCalc .= ", answer='".mysql_real_escape_string($row['answer'])."'";
				$sqlCalc .= ", legend='".mysql_real_escape_string($row['legend'])."'";			
				$sqlCalc .= ", category='".mysql_real_escape_string($row['category'])."'";			
				$sqlCalc .= ", title='".mysql_real_escape_string($row['title'])."'";
				$sqlCalc .= ", graph_instruction='".mysql_real_escape_string($row['graph_instruction'])."'";			
				$sqlCalc .= ", graph_question='".mysql_real_escape_string($row['graph_question'])."'";			
				$sqlCalc .= ", graph_answer='".mysql_real_escape_string($row['graph_answer'])."'";			
				$sqlCalc .= ", graph_legend='".mysql_real_escape_string($row['graph_legend'])."'";				
				$sqlCalc .= ", graph_category='".mysql_real_escape_string($row['graph_category'])."'";
				$sqlCalc .= ", graph_title='".mysql_real_escape_string($row['graph_title'])."'";			
				$sqlCalc .= ", data='".mysql_real_escape_string($row['data'])."'";			
				$sqlCalc .= ($row['id_tableTemplate'])?", id_tableTemplate=".mysql_real_escape_string($row['id_tableTemplate']):'';			
				$sqlCalc .= ($row['id_graphTemplate'])?", id_graphTemplate=".mysql_real_escape_string($row['id_graphTemplate']):'';			
				$sqlCalc .= ", missings='".mysql_real_escape_string($row['missings'])."'";
				$sqlCalc .= ", hideAnswers='".mysql_real_escape_string($row['hideAnswers'])."'";				
				$sqlCalc .= ($row['hideQuestion'])?", hideQuestion=".mysql_real_escape_string($row['hideQuestion']):'';
				$sqlCalc .= ", comment='".mysql_real_escape_string($row['comment'])."'";			
				$sqlCalc .= ", crosstabVariables='".mysql_real_escape_string($row['crosstabVariables'])."'";
				if(!$resultCalc=$this->db->SQLexecute($sqlCalc)){
					return $this->db->JsonError();
				}	
			}
		}
		
		
		
		$sql = "SELECT * FROM ".$resName."___events "; 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$sqlEvents = "INSERT INTO ".$projName."___events ";
				$sqlEvents .= " SET id_question='".mysql_real_escape_string($row['id_question'])."'";
				$sqlEvents .= ", eventName='".mysql_real_escape_string($row['eventName'])."'";
				$sqlEvents .= ", event='".mysql_real_escape_string($row['event'])."'";
				$sqlEvents .= ($row['eventTime'])?", eventTime=".mysql_real_escape_string($row['eventTime']):'';
				
				if(!$resultEvents=$this->db->SQLexecute($sqlEvents)){
					return $this->db->JsonError();
				}	
			}
		}
		
		
		//echo "----->".$firstFieldName."<-------";
		
		$sql = "DESCRIBE ".$resName."___data ";
		if($result=$this->db->SQLexecute($sql)){
			$quest = false;
			$questFields = array();
			while($row = $this->db->fetchAssoc($result)) {
				if($row['Field'] == $firstFieldName) $quest = true;
				if($quest) {
					$altSql = "ALTER TABLE ".$projName."___data ADD ".mysql_real_escape_string($row['Field'])." ".mysql_real_escape_string($row['Type']).";";
					$questFields[] = $row['Field'];
					$this->db->SQLexecute($altSql);
				}					
			}
		}
		
		//echo "----->".$firstFieldName."<-------";
		
		$sql = "SELECT * FROM ".$resName."___data "; 
		if($result=$this->db->SQLexecute($sql)){
			while($row = $this->db->fetchAssoc($result)) {
				$sqlData = "INSERT INTO ".$projName."___data SET ";
				$sqlData .= " research_id=".$resId;
				$sqlData .= ($row['unweight'])?", unweight=".mysql_real_escape_string($row['unweight']):'';
				$sqlData .= ($row['weight'])?", weight=".mysql_real_escape_string($row['weight']):'';
				$sqlData .= (isset($row['user_id']))?", user_id=".mysql_real_escape_string($row['user_id']):'';
				$sqlData .= (isset($row['user_type']))?", user_type=".mysql_real_escape_string($row['user_type']):'';
				$sqlData .= (isset($row['id_device']))?", id_device=".mysql_real_escape_string($row['id_device']):'';
				$sqlData .= (isset($row['id_language']))?", id_language=".mysql_real_escape_string($row['id_language']):'';
				$sqlData .= (isset($row['id_site']))?", id_site='".mysql_real_escape_string($row['id_site'])."'":'';
				$sqlData .= (isset($row['status']))?", status=".mysql_real_escape_string($row['status']):'';
				$sqlData .= (isset($row['status_rec']))?", status_rec=".mysql_real_escape_string($row['status_rec']):'';
				$sqlData .= (isset($row['flag_bad']))?", flag_bad=".mysql_real_escape_string($row['flag_bad']):'';
				$sqlData .= (isset($row['t_start']))?", t_start=".mysql_real_escape_string($row['t_start']):'';
				$sqlData .= (isset($row['t_stop']))?", t_stop=".mysql_real_escape_string($row['t_stop']):'';
				foreach($questFields as $q) {
					if($row[$q]) {
						$sqlData .= (is_numeric($row[$q]))?", ".mysql_real_escape_string($q)."=".mysql_real_escape_string($row[$q]):", ".mysql_real_escape_string($q)."='".mysql_real_escape_string($row[$q])."'";
					}
				}
				
				//echo $sqlData."<br><br>";
				
				if(!$resultData=$this->db->SQLexecute($sqlData)){
					return $this->db->JsonError();
				}	
			}
		}
		

		
	}
	
	protected function createBasicStructure($projName) {
		$sql = "CREATE TABLE IF NOT EXISTS `".$projName."___calculated` (
			  `id` int(5) NOT NULL AUTO_INCREMENT,
			  `id_question` int(5) NOT NULL,
			  `questionName` varchar(30) NOT NULL,
			  `questionVars` text,
			  `questionType` tinyint(1) NOT NULL,
			  `questionSubType` tinyint(1) NOT NULL,
			  `questionOpenCount` tinyint(1) NOT NULL,
			  `instruction` text NOT NULL,
			  `question` text NOT NULL,
			  `answer` text NOT NULL,
			  `legend` text NOT NULL,
			  `category` text NOT NULL,
			  `title` text NOT NULL,
			  `graph_instruction` text NOT NULL,
			  `graph_question` text NOT NULL,
			  `graph_answer` text NOT NULL,
			  `graph_legend` text NOT NULL,
			  `graph_category` text NOT NULL,
			  `graph_title` text NOT NULL,
			  `data` text NOT NULL,
			  `id_tableTemplate` int(5) NOT NULL,
			  `id_graphTemplate` int(5) NOT NULL,
			  `missings` varchar(255) DEFAULT NULL,
			  `missings_mean` varchar(255) DEFAULT '0',
			  `hideAnswers` varchar(255) DEFAULT NULL,
			  `hideQuestion` tinyint(1) NOT NULL,
			  `comment` text NOT NULL,
			  `crosstabVariables` text NOT NULL,
			  PRIMARY KEY (`id`),
			  KEY `hideQuestion` (`hideQuestion`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
		
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}

		$sql = "CREATE TABLE IF NOT EXISTS `".$projName."___events` (
			  `id` int(5) NOT NULL AUTO_INCREMENT,
			  `id_question` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
			  `eventName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
			  `event` text COLLATE utf8_unicode_ci,
			  `eventTime` int(11) unsigned DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  KEY `id_question` (`id_question`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;";
		
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}
		
		$sql = "CREATE TABLE IF NOT EXISTS `".$projName."___data` (
			  `id` int(7) NOT NULL AUTO_INCREMENT,
			  `weight` double DEFAULT NULL,
			  `unweight` tinyint(1) NOT NULL,
			  `research_id` int(5) DEFAULT NULL,
			  `user_id` int(5) DEFAULT NULL,
			  `user_type` tinyint(4) DEFAULT NULL,
			  `id_device` tinyint(4) DEFAULT NULL,
			  `id_language` tinyint(4) DEFAULT NULL,
			  `id_site` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
			  `status` int(3) DEFAULT NULL,
			  `status_rec` int(3) DEFAULT NULL,
			  `flag_bad` int(3) unsigned DEFAULT NULL,
			  `t_start` int(11) unsigned DEFAULT NULL,
			  `t_stop` int(11) unsigned DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  INDEX `research_id` (`research_id`),
			  INDEX `weight` (`weight`),
			  INDEX `user_id` (`user_id`),
			  INDEX `user_type` (`user_type`),
			  INDEX `id_device` (`id_device`),
			  INDEX `id_language` (`id_language`),
			  INDEX `status` (`status`),
			  INDEX `status_rec` (`status_rec`),
			  INDEX `t_start` (`t_start`),
			  INDEX `t_stop` (`t_stop`),
			  INDEX `flag_bad` (`flag_bad`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;";
		
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}
		
		$sql = "INSERT INTO `".$projName."___calculated` (
			`id` ,
			`id_question` ,
			`questionName` ,
			`questionVars` ,
			`questionType` ,
			`questionSubType` ,
			`questionOpenCount` ,
			`instruction` ,
			`question` ,
			`answer` ,
			`legend` ,
			`category` ,
			`title` ,
			`graph_instruction` ,
			`graph_question` ,
			`graph_answer` ,
			`graph_legend` ,
			`graph_category` ,
			`graph_title` ,
			`data` ,
			`id_tableTemplate` ,
			`id_graphTemplate` ,
			`missings` ,
			`hideAnswers` ,
			`hideQuestion` ,
			`comment` ,
			`crosstabVariables`
			)
			VALUES (
			NULL , '-999', 'research_id', 'research_id', '1', '1', '0', '', 'Čas raziskave', '', '', '', '', '', '', '', '', '', '', '', '0', '0', '0', '', '0', '', 'rde1'
			);";
		if(!$result=$this->db->SQLexecute($sql)){
			return $this->db->JsonError();
		}
	}

}

?>