<?php
include_once ("_dirinfo.php");
include_once(PATH_TO_ROOT.'statview/_class/class_calculate.php');
include_once(PATH_TO_ROOT.'statview/_class/class_labels.php');
include_once(PATH_TO_ROOT.'statview/_class/class.selector.php');
include_once(PATH_TO_ROOT.'statview/_class/class.crossing.php');

date_default_timezone_set('Europe/Ljubljana');

include_once(PATH_TO_ROOT.'statview/firephp/fb.php');
include_once(PATH_TO_ROOT.'statview/firephp/FirePHP.class.php');

include_once(PATH_TO_ROOT.'statview/_class/class.MapServer.php');

class Maps
{

	protected $db;

	public function __construct($db) {
		$this->db = $db;
	}
	
	//total za mape
	
	public function getTotal($idP, $idQ, $idQCross, $idA, $sliderPar1=null, $sliderPar2=null) {
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$projName = str_replace(" ", "_", $projName);
		$calc = new Calculate($this -> db, '_projects', $projName, $idP);
		$calc -> setQuestion($idQ);
		$data = $calc->getCrosstabs($idQCross, $sliderPar1, $sliderPar2);
		return round($data['freq'][$idQ]['total']);
	}

	//podatki za mape
	protected function getCrossData($projName, $idP, $idQ, $idQCross, $idA, $sliderPar1=null, $sliderPar2=null){
		$calc = new Calculate($this -> db, '_projects', $projName, $idP);	
		$calc -> setQuestion($idQ);
		$sel = new Selector($this -> db);
		$data = $calc->getCrosstabs($idQCross, $sliderPar1, $sliderPar2);
		//print_r($data);
	
		$returnArray['labs'] = $data['labels'][$idQ]['answers'];
		$returnArray['legend'] = $data['labels'][$idQCross]['answers'];
		$returnArray['freqs'] = array();
		$returnArray['total'] = $data['freq'][$idQ]['total'];
	
		foreach($returnArray['labs'] as $questionNumber => $questionLabel)
		{
			if($questionNumber == $idA) {
				foreach($returnArray['legend'] as $legendQNumber => $legenQLabel)
				{
					if(isset($data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber]))
						$returnArray['freqs'][$questionNumber][$legendQNumber] = $data['cross'][$idQ][$questionNumber][$idQCross][$legendQNumber];
					else
						$returnArray['freqs'][$questionNumber][$legendQNumber] = 0;	
				}
			}	
		}
		//print_r($returnArray['freqs'][$idA]);
		return $returnArray['freqs'][$idA];
		//return $data['freq'][$idQCross]['data'][$idA];
		//return array(0=>$idQCross);
	}
	
	protected function getCrossColTotal($projName, $idP, $idQ, $idQCross, $idA, $sliderPar1=null, $sliderPar2=null){
		$calc = new Calculate($this -> db, '_projects', $projName, $idP);	
		$calc -> setQuestion($idQ);
		$data = $calc->getCrosstabs($idQCross, $sliderPar1, $sliderPar2);
		return $data['freq'][$idQCross]['data'][$idA];
		//return $data['freq'][$idQ]['total'];
	}	
	
	public function getColors($project, $size) {
		$sql = "SELECT c.usedColors FROM _colorShema c INNER JOIN _projects p ON c.id = p.colorShema WHERE p.projectName='$project';";
		$res = mysql_query($sql);
		$colors = array();
		
		if ($res) {
			$row = mysql_fetch_assoc($res);
			$colors = $row['usedColors'];
		}
	
		if ($colors != "") $colors = explode(",", $colors);
		$more = explode(",", "#A75C56,#E89C84,#F5C972,#EAB06E,#C3B274,#354B5E,#D74B4B,#DCDDD8,#475F77,#2BBBD8,#102E37,#90CA77,#81C6DD,#993300,#99CC99,#003366,#2C6700,#692DAC,#9D538E,#34ACAF,#333333,#FFCC00,#669966,#993366");
	
		if (count($colors) < $size) {
			while (count($colors) < $size) {
				$colors[] = array_pop($more);
			}
		}
	
		return $colors;
	}
	
	protected function getDefAmounts() {
		$amounts = explode(",", "0-10,11-20,21-30");
		return $amounts;
	}
	
	protected function hex2rgb($hex) {
		$hex = str_replace("#", "", $hex);
	
		if(strlen($hex) == 3) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}
		$rgb = "(".$r.",".$g.",".$b.")";
		return $rgb;
	}
	
	protected function getMapOptions($idP, $idQ, $idQCross, $idA, $subId = false) {
		$optionsArray = array();
		$returnArray = array();
		
		switch ($idQCross) {
			case "reg":
				$idQCross = 1;
				break;
			case "obc":
				$idQCross = 2;
				break;
			case "ve":
				$idQCross = 3;
				break;
			case "vo":
				$idQCross = 4;
				break;
		}
		
		$subId = ($subId)?$subId:0;		
		$sql = "SELECT * FROM _map_options WHERE id_question = '". $idQ ."' AND id_project = '". $idP ."' AND type = ". $idQCross. " AND sub_type = ". $subId. " AND id_answer = ". $idA;
		//print_r($sql);
		//$res = mysql_query($sql);
		
		if($result=$this->db->SQLexecute($sql)){
			while($row = mysql_fetch_assoc($result)){
				$optionsArray[] = $row;
			}
		} else {
			return array();
		}
		
		if(count($optionsArray)){
			$options = json_decode($optionsArray[0]['options']);
			foreach($options as $o) {
				for($i=1;$i<11;$i++) {
					if($o->name == "lvl".$i."_color_picker") {						
						$returnArray['lvl'.$i.'_color_picker'] = $o->value;
					}
					if($o->name == "lvl".$i."_amount") {
						$returnArray['lvl'.$i.'_amount'] = $o->value;	
					}
				}				
				switch($o->name){						
					case "column_vrsta_podatka":
						$returnArray['column_vrsta_podatka'] = $o->value;
						break;
					case "show_terain":
						$returnArray['show_terain'] = "checked";
						break;
					case "sub_level":
						$returnArray['sub_level'] = "checked";
						break;
					case "odmik_levo":
						$returnArray['odmik_levo'] = $o->value;
						break;
					case "odmik_desno":
						$returnArray['odmik_desno'] = $o->value;
						break;
					case "odmik_spodaj":
						$returnArray['odmik_spodaj'] = $o->value;
						break;
					case "odmik_zgoraj":
						$returnArray['odmik_zgoraj'] = $o->value;
						break;
					case "answ_choose":
						$returnArray['answ_id'] = $o->value;
						break;
					case "trans_amount":
						$returnArray['trans_amount'] = $o->value;
						break;
				}
			}
		}
		return $returnArray;
		//return array();
	}
	
	//map data
	public function getMapData($idP, $idQ, $idQCross, $idA, $subId=false, $sliderPar1=null, $sliderPar2=null) {
		$valuesArray = array();
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$options = $this->getMapOptions($idP, $idQ, $idQCross, $idA, $subId);
		$defAmounts = $this->getDefAmounts();	
		$projName = str_replace(" ", "_", $projName);		
		$data = $this->getCrossData($projName, $idP, $idQ, $idQCross, $idA, $sliderPar1, $sliderPar2);
		//$testArr = array();
		/*
		$all = 0;
		foreach($data as $val) {
			$all +=$val;
		}*/
		
		switch ($idQCross) {
			case 'reg':
				$returnArray['data']['type'] = "reg";
				break;
			case 'obc':
				$returnArray['data']['type'] = "ob";
				break;
			case 've':
				$returnArray['data']['type'] = "ve";
				break;
			case 'vo':
				$returnArray['data']['type'] = "vo";
				break;
		}
		
		for($i=1; $i<11; $i++) {		
			if(isset($options['lvl'.$i.'_amount'])) {
				$value = $options['lvl'.$i.'_amount'];
				$splitedValue = explode("-",$value);
				if(isset($splitedValue[1])) {
					$valuesArray[] = array($splitedValue[0], $splitedValue[1]);
				} else {
					$valuesArray[] = array($splitedValue[0]);
				}
			} else if($defAmounts[$i-1] && $i < 4  && !isset($options['lvl2_color_picker'])){
				$value = $defAmounts[$i-1];
				$splitedValue = explode("-",$value);
				if(isset($splitedValue[1])) {
					$valuesArray[] = array($splitedValue[0], $splitedValue[1]);
				} else {
					$valuesArray[] = array($splitedValue[0]);
				}
			}
		}
		
		foreach($data as $key => $value) {
			if($options['column_vrsta_podatka'] == 'num') {
				$value = $value;
			} else {
				$colTotal = $this->getCrossColTotal($projName, $idP, $idQ, $idQCross, $key, $sliderPar1, $sliderPar2);
				//$testArr[] = $colTotal;
				$value = ($value/$colTotal)*100;
			}			
			
			
			for($i=0; $i<count($valuesArray); $i++) {
				if(isset($valuesArray[$i][1]) && $valuesArray[$i][0] <= floatval($value) && floatval($value) <= $valuesArray[$i][1]) {
					$returnArray['data']['values'][$i][] = $key;
				} else if (!isset($valuesArray[$i][1]) && $valuesArray[$i][0] <= floatval($value)) {
					$returnArray['data']['values'][$i][] = $key;
				}
			}
		}
		
		//return $all;
		return htmlspecialchars(json_encode($returnArray), ENT_QUOTES, 'UTF-8');
	}
	
	//specific area data
	public function getJsonAreaData($idP, $idQ, $idQCross, $idA, $areaId, $subId=false, $sliderPar1 = false, $sliderPar2 = false) {
		$valuesArray = array();
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$options = $this->getMapOptions($idP, $idQ, $idQCross, $idA, $subId);
		$defAmounts = $this->getDefAmounts();
		$projName = str_replace(" ", "_", $projName);
		$data = $this->getCrossData($projName, $idP, $idQ, $idQCross, $idA, $sliderPar1, $sliderPar2);
		$colTotal = $this->getCrossColTotal($projName, $idP, $idQ, $idQCross, $areaId, $sliderPar1, $sliderPar2);
		/*$all = 0;
		foreach($data as $val) {
			$all +=$val;
		}*/	
		$returnArray['data']['num'] = round($data[$areaId]);
		$returnArray['data']['proc'] =  number_format(($data[$areaId]/$colTotal)*100,1);
		
		return htmlspecialchars(json_encode($returnArray), ENT_QUOTES, 'UTF-8');
	}
	
	//html legenda
	public function getMapLegend($idP, $idQ, $idQCross, $idA, $subId=false) {
		$language = configLoader::loadLanguage(1,'language','default_admin','project',DB_WARPIT_STATVIEW);
		$returnArray = array();
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$options = $this->getMapOptions($idP, $idQ, $idQCross, $idA, $subId);
		$colors = $this->getColors($projName, 10);
		$defAmounts = $this->getDefAmounts();
		
		for($i=1; $i<11; $i++) {
			if($options['lvl'.$i.'_color_picker']) {
				$returnArray[$i]['color'] = "rgb".$this->hex2rgb($options['lvl'.$i.'_color_picker']);
			} else if($colors[$i-1] && $i < 4 && !isset($options['lvl2_color_picker'])){
				$returnArray[$i]['color'] = "rgb".$this->hex2rgb($colors[$i-1]);
			}
			
			if($options['lvl'.$i.'_amount']) {
				$returnArray[$i]['value'] = $options['lvl'.$i.'_amount'];
			} else if($defAmounts[$i-1] && $i < 4 && isset($returnArray[$i]['color']) && !isset($options['lvl2_color_picker'])){
				$returnArray[$i]['value'] = $defAmounts[$i-1];
			}
		}
		
		$legend = '';
		
		foreach ($returnArray as $value) {
			$splitedValue = explode("-",$value['value']);
			$operator = ($options['column_vrsta_podatka'] == 'num')?'(N)':'%';
			if(isset($splitedValue[1])) {
				//$trimedVal = trim($splitedValue[0]).$operator." do ".trim($splitedValue[1]).$operator;
				$trimedVal = trim($splitedValue[0]).$operator." ".$language['proj_map_legend_to']." ".trim($splitedValue[1]).$operator;
			} else {
				//$trimedVal = "več kot ".$splitedValue[0].$operator;
				$trimedVal = $language['proj_map_legend_more']." ".$splitedValue[0].$operator;
			}
			$legend .= "<div class='color-box left' style='background-color:".$value['color'].";'></div><div class='left'>".$trimedVal."</div><div class='clear'></div>";
		}
		return $legend;
	}
	
	public function getJsonMapLegend($idP, $idQ, $idQCross, $idA, $subId=false) {
		$returnArray = array();
		$jsonArray = array();
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$options = $this->getMapOptions($idP, $idQ, $idQCross, $idA, $subId);
		$colors = $this->getColors($projName, 10);
		$defAmounts = $this->getDefAmounts();
		
		for($i=1; $i<11; $i++) {
			if($options['lvl'.$i.'_color_picker']) {
				$returnArray[$i]['color'] = "rgba".$this->hex2rgb($options['lvl'.$i.'_color_picker']);
			} else if($colors[$i-1] && $i < 4){
				$returnArray[$i]['color'] = "rgba".$this->hex2rgb($colors[$i-1]);
			}
				
			if($options['lvl'.$i.'_amount']) {
				$returnArray[$i]['value'] = $options['lvl'.$i.'_amount'];
			} else if($defAmounts[$i-1] && $i < 4 && isset($returnArray[$i]['color'])){
				$returnArray[$i]['value'] = $defAmounts[$i-1];
			}
		}
		$counter = 0;
		foreach ($returnArray as $value) {
			$splitedValue = explode("-",$value['value']);
			if(isset($splitedValue[1])) {
				$trimedVal = $splitedValue[0]." do ".$splitedValue[1];
			} else {
				$trimedVal = "več kot ".$splitedValue[0];
			}
			$jsonArray['data'][] = array('name'=>$trimedVal, 'value'=>$counter, 'stroke' => array('width'=> 1, 'color'=> 'black'), 'fill'=>array('color'=> $value['color']));			
			$counter++;
		}
		return htmlspecialchars(json_encode($jsonArray), ENT_QUOTES, 'UTF-8');
	}
	
	public function getJsonMapOptions($idP, $idQ, $idQCross, $idA, $subId=false) {
		$jsonArray = array();
		$sel = new Selector($this -> db);
		$projName = $sel -> getProjectName($idP);
		$options = $this->getMapOptions($idP, $idQ, $idQCross, $idA, $subId);
		
		foreach($options as $key => $value) {
			$jsonArray['data'][] = array($key=>$value);
		}		
		return htmlspecialchars(json_encode($jsonArray), ENT_QUOTES, 'UTF-8');
	}
	
	public function generateExtras($jsonMapData, $jsonMapLegend, $limit) {
		$mapdata = json_decode(htmlspecialchars_decode($jsonMapData));
		$layer = $mapdata->data->type;
		
		$legend = json_decode(htmlspecialchars_decode($jsonMapLegend), true);
		$data = $legend['data'];
		$colors = array();
		
		for ($i=0; $i < count($data); $i++) {
			$colors[] = str_replace(",", " ", str_replace(")", "", str_replace("rgba(", "", $data[$i]['fill']['color'])));
		}
		
		$def = file_get_contents("/var/www/data/templates/".$layer.".map");
		
		if (strpos($def, "#EXPRESSIONS#") != false) {
			$head = substr($def, 0, strpos($def, "#EXPRESSIONS#") + 13);
			$foot = substr($def, strpos($def, "#!EXPRESSIONS#"));
			$cls = "\r\n";
		}
		
		$toAdd = array();
		
		$i = 0;
		foreach ($mapdata->data->values as $key => $value) {
			// echo $key . "->" . json_encode($value) . "#";
			if (count($limit)) {
				$value = array_values(array_intersect($value, $limit));
			}
			// $toAdd[] = " CLASS\r\n  EXPRESSION {".implode(",", $value)."}\r\n  STYLE\r\n    WIDTH 1\r\n    OUTLINECOLOR 0 0 0\r\n    COLOR ".$colors[$i]."\r\n  END\r\nEND";
			$toAdd[] = " CLASS\r\n  EXPRESSION (\"[".$layer."_id]\" IN \"".implode(',', $value)."\")\r\n  STYLE\r\n    WIDTH 1\r\n    OUTLINECOLOR 0 0 0\r\n    COLOR ".$colors[$key]."\r\n  END\r\nEND";
			$i++;
		}
		
		return $head . $cls . implode(" ", $toAdd) . $foot;
	}
	
	// Funkcija za generiranje .map datoteke
	public function generateMap($jsonMapData, $jsonMapLegend, $limit = array()) {
		// $_SESSION['layers'] = "reg,ob,ve,vo";
		if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
		$ms = new MapServer($_SESSION['mapfile']);
		$ms->setLayers(explode(",", $_SESSION['layers']));
		
		$mapdata = json_decode(htmlspecialchars_decode($jsonMapData));
		$layer = $mapdata->data->type;

		// $_SESSION['extras'][$layer] = $this->generateExtras($jsonMapData, $jsonMapLegend);
		$extras[$layer] = $this->generateExtras($jsonMapData, $jsonMapLegend, $limit);
		
		$ms->setExtras($extras);
		$ms->generateMapFile();
		
		return $_SESSION['mapfile'];
	}
	
	function getMapTypes() {
		$jsonArray['data'] = array();
		$jsonArray['data'][] = array("id"=> 1, "name"=> "reg");
		$jsonArray['data'][] = array("id"=>2, "name"=> "ob");
		$jsonArray['data'][] = array("id"=>3, "name"=> "ve");
		$jsonArray['data'][] = array("id"=>4, "name"=> "vo");
		
		return $jsonArray;
	}
	
	function getMapTypeId($name) {
		$types = $this->getMapTypes();
		$id = false;
		
		foreach ($types['data'] as $value) {
			if ($value['name'] == $name) $id = $value['id'];
		}
		
		return $id;
	}
	
	function getEnabledMapTypes($idP, $idQ) {
		$sel = new Selector($this -> db);
		$jsonArray = array();
		$showTypes = $sel -> getProjShowTypes($idP, $idQ);
		
		$jsonArray['data'] = array();
		if ($showTypes['map1']) $jsonArray['data'][] = "reg";
		if ($showTypes['map2']) $jsonArray['data'][] = "ob";
		if ($showTypes['map3']) $jsonArray['data'][] = "ve";
		if ($showTypes['map4']) $jsonArray['data'][] = "vo";
		
		return $jsonArray;
	}

	function getFooterText($idP, $idQ, $idQCross, $idA, $sliderPar1=null, $sliderPar2=null) {
		$sel = new Selector($this -> db);
		
		$total = $this->getTotal($idP, $idQ, $idQCross, $idA, $sliderPar1, $sliderPar2);

		$proj = $sel->getProject($idP);
		
		$str = $proj['footerText'];
		
		if(strstr($str, '$N')){
			$str = str_replace('$N', round($total), $str);
		}
		
		return $str;
	}
	/*function getMapCategories($idP, $idQ, $idQCross) {
		$sel = new Selector($this -> db);
		
		$jsonArray = array();
		$showTypes = $sel -> getProjShowTypes($idP, $idQ);
		
		$regShow = ($showTypes['map1']) ? '1' : '0';
		$obShow = ($showTypes['map2']) ? '1' : '0';
		$veShow = ($showTypes['map3']) ? '1' : '0';
		$voShow = ($showTypes['map4']) ? '1' : '0';
		
		if ($idQCross == "obc") $regShow = '0'; 
		else if ($idQCross == "vo") $veShow = '0'; 
		
		// $jsonArray['categories'] = array("1"=> array(array("id"=> "reg", "name"=> "Statistične regije", "visible"=> $regShow), array("id"=> "ob", "name"=> "Občine", "visible"=> $obShow)), "2"=> array(array("id"=> "ve", "name"=> "Volilne enote", "visible"=> $veShow), array("id"=> "vo", "name"=> "Volilni okraji", "visible" => $voShow)));
		
		$jsonArray = "[";
		
			$jsonArray .= "[";
			
				if ($regShow) $jsonArray .= "'reg'";
				if ($regShow and $obShow) $jsonArray .= ",";
				if ($obShow) $jsonArray .= "'ob'";
			
			$jsonArray .= "], ";
				
			$jsonArray .= "[";
			
				if ($veShow) $jsonArray .= "'ve'";
				if ($veShow and $voShow) $jsonArray .= ",";
				if ($voShow) $jsonArray .= "'vo'";
			
			$jsonArray .= "]";
		
		$jsonArray .= "]";
		
		return $jsonArray;
	}*/

	function getMapCategories($idP, $idQ, $idQCross) {
		$sel = new Selector($this -> db);
		
		$jsonArray = array();
		$showTypes = $sel -> getProjShowTypes($idP, $idQ);
		
		$regShow = ($showTypes['map1']) ? '1' : '0';
		$obShow = ($showTypes['map2']) ? '1' : '0';
		$veShow = ($showTypes['map3']) ? '1' : '0';
		$voShow = ($showTypes['map4']) ? '1' : '0';
		
		// if ($idQCross == "obc") $regShow = '0'; 
		// else if ($idQCross == "vo") $veShow = '0'; 
		
		$test = array();
		
		$test1 = array();
		if ($regShow) $test1[] = 'reg';
		if ($obShow) $test1[] = 'ob';
		
		$test[] = $test1;
		
		$test2 = array();
		if ($veShow) $test2[] = 've';
		if ($voShow) $test2[] = 'vo';
		
		$test[] = $test2;
		
		return $test;
	}

	function getLayersIntersection($category, $subId) {
		$ids = array();
		
		$sql = "SELECT child_id FROM _layer_interconnection WHERE parent_id='$subId' and category='$category';";
		$res = mysql_query($sql);
		
		if ($res) {
			if (mysql_num_rows($res)) {
				while ($row = mysql_fetch_assoc($res)) {
					$ids[] = $row['child_id'];
				}
			}
		}
		
		return $ids;
	}
}	