<?php
include_once "_dirinfo.php";
include_once PATH_TO_ROOT . "_config/dbConfig.php";
include_once PATH_TO_ROOT . "statview/init.php";
include_once PATH_TO_ROOT . "statview/_class/class.selector.php";
include_once PATH_TO_ROOT . "statview/_class/class.projectgenerator.php";
include_once PATH_TO_ROOT . "statview/_class/class.forms.php";

class Importer extends FormsEvents
{
    public $id_project;
    public $name_project;
    public $tree_node;
    public $server;
    public $tree_load;

    protected $alterTableData = array();
    protected $warptiVars = array();

    protected $dbWarpit;
    protected $warpitMainDatabase;

    protected function dbWarpitConnect()
    {
        $this->dbWarpit = new db;

        //server 1: podatke prebere z warpit dbConfig.php
        if ($this->server == "1") {
            $this->warpitMainDatabase = DB_WARPIT_MAIN;
            $this->dbWarpit->SetDatabaseConnection(MYSQL_USER, MYSQL_PASS, WARPIT_HOST);
        }
        //server 2: podatke prebere z _WarpitConfig tabele
        else if ($this->server == "2") {
            $connectionWarpit = configLoader::loadConfig('statview_warpitServer' . $this->server);
            $this->warpitMainDatabase = $connectionWarpit['database'];
            $this->dbWarpit->SetDatabaseConnection($connectionWarpit['username'], $connectionWarpit['password'], $connectionWarpit['host']);
        }
    }

    protected function getWarpitProjects($node = 0)
    {
        if ($warpitDatabase = $this->getWarpitProjectDatabase()) {
            $this->dbWarpit->ChangeDatabase($warpitDatabase);

            return $this->listProjects($node);
        } else {
            return false;
        }
    }

    protected function listProjects($id_sup = 0)
    {
        $sql = "SELECT a.id_project,a.idLab,a.is_leaf,b.naziv_proj,a.id AS id_folder FROM _ProjectsTree a
                    LEFT JOIN _Projects b
                    ON a.id_project=b.id
                    WHERE id_sup=" . mysql_real_escape_string($id_sup) . "
                    ORDER BY a.is_leaf ASC,a.idLab ASC";

        if (!$result = $this->dbWarpit->SQLexecute($sql)) {
            return false;
        }
        while ($row = $this->dbWarpit->fetchAssoc($result)) {
            $arr[] = $row;
        }

        return $arr;
    }

    protected function getWarpitProjectDatabase()
    {
        $sql = "SELECT cValue FROM " . $this->warpitMainDatabase . "._WarpitConfig WHERE prefix='database' AND cName='table_warpit_webcati_base'";
        if (!$result = $this->dbWarpit->SQLexecute($sql)) {
            //echo $this->dbWarpit->JsonError();
            return false;
        }
        $row = $this->dbWarpit->fetchAssoc($result);

        return $row['cValue'];
    }

    protected function getWarpitQuestDatabase()
    {
        $sql = "SELECT cValue FROM " . $this->warpitMainDatabase . "._WarpitConfig WHERE prefix='database' AND cName='table_warpit_webcati'";
        if (!$result = $this->dbWarpit->SQLexecute($sql)) {
            return false;
        }
        $row = $this->dbWarpit->fetchAssoc($result);

        return $row['cValue'];
    }

    public function loadTreeAction()
    {
        $this->dbWarpitConnect();

        $projects = $this->getWarpitProjects($this->tree_node);
        //$this->debug_view($projects);

        // nastavim root top folder
        if ($this->tree_load == 'init') {
            $arr = array('title' => "Warpit Projects", 'isFolder' => true, 'key' => "0", 'expand' => true);

            foreach ($projects as $project) {
                // navadn file
                if ($project['is_leaf'] == 1) {
                    $arr['children'][] = array('title' => $project['idLab'], 'key' => $project['id_project']);
                    // folder
                } else {
                    $arr['children'][] = array('title' => $project['idLab'], 'isFolder' => true, 'isLazy' => true, 'key' => $project['id_folder']);
                }
            }
        } else {
            foreach ($projects as $project) {
                // navadn file
                if ($project['is_leaf'] == 1) {
                    $arr[] = array('title' => $project['idLab'], 'key' => $project['id_project']);
                    // folder
                } else {
                    $arr[] = array('title' => $project['idLab'], 'isFolder' => true, 'isLazy' => true, 'key' => $project['id_folder']);
                }
            }
        }

        $arr_json = json_encode($arr);
        return $arr_json;

    }

    public function importProjectAction()
    {
        $this->dbWarpitConnect();

        // get all parameters and call main function
        $calcArray = $this->getWarpitQuestionnaire();
        $mainData = $this->getWarpitProjectData();

        //print_r($mainData);

        $importRes = $this->importProject($this->name_project, $calcArray, $mainData);
        return $importRes;
    }

    protected function getWarpitQuestionnaire()
    {
        if ($warpitDatabase = $this->getWarpitQuestDatabase()) {
            $this->dbWarpit->ChangeDatabase($warpitDatabase);

            // get questionnaire data
            $sql = "SELECT id,q_pos,q_name,tip_sql,les_sql,open_answers FROM " . mysql_real_escape_string($this->name_project) . "
                    WHERE q_pos>0 AND tip_sql IN (1,2,3)
                    ORDER BY q_pos";
            //echo $sql."<br>";
            if ($res = $this->dbWarpit->SQLexecute($sql)) {
                while ($zad = $this->dbWarpit->fetchAssoc($res)) {
                    $allQuest[$zad['id']]['prop'] = $zad;
                }
            } else {
                echo $this->dbWarpit->JsonError();
            }

            // get labs
            $sql = "SELECT id_language,id_question,id_text_type,lngText FROM " . mysql_real_escape_string($this->name_project) . "_language";
            //echo $sql."<br>";
            if ($res = $this->dbWarpit->SQLexecute($sql)) {
                while ($zad = $this->dbWarpit->fetchAssoc($res)) {
                    if (isset($allQuest[$zad['id_question']])) {
                        $allQuest[$zad['id_question']]['labs'][$zad['id_text_type']] = $zad['lngText'];
                    }

                }
            } else {
                echo $this->dbWarpit->JsonError();
            }

            return $allQuest;
        } else {
            return $this->dbWarpit->JsonError();
        }
    }

    protected function getWarpitProjectData()
    {
        if ($warpitDatabase = $this->getWarpitProjectDatabase()) {
            $this->dbWarpit->ChangeDatabase($warpitDatabase);

            // get projects properties data
            $sql = "SELECT naziv_proj, proj_name FROM _Projects WHERE id=" . mysql_real_escape_string($this->id_project);
            //echo $sql."<br>";
            $res = $this->dbWarpit->SQLexecute($sql);
            $zad = $this->dbWarpit->fetchAssoc($res);

            $arr['long_name'] = $zad['proj_name'];
            if (strlen($zad['naziv_proj']) > 1) {
                $arr['long_name'] = $zad['naziv_proj'];
            }

            return $arr;

        } else {
            return $this->dbWarpit->JsonError();
        }

    }

    protected function projectExist($resName)
    {
        $sql = "SELECT id FROM " . DB_WARPIT_STATVIEW . "._research WHERE project LIKE '" . mysql_real_escape_string($resName) . "'";
        //echo "$sql";
        if ($result = $this->db->SQLexecute($sql)) {
            if ($this->db->NumRows($result) > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            echo $this->db->JsonError();
        }

    }

    /**
     * main function for import project
     *
     * @param unknown_type $resName - project name
     * @param unknown_type $calcArray - row data for *___calculated table
     * @param unknown_type $mainData - labels and properties of research
     * @return unknown
     */
    protected function importProject($resName, $calcArray, $mainData)
    {
        if (!$this->projectExist($resName)) {
            //echo "going to create structure...";
            $this->createBasicStructure($resName);
            $this->insertResCalc($resName, $calcArray);
            $this->insertRes($resName, $mainData);
            $this->insertResData($resName);
//            return true;

            return '{"error":false,"script":false,"returnval":true,"response":true}';
        } else {
            return '{"error":false,"script":false,"returnval":true,"response":false}';
            //return json_encode("Projekt s tem imenom obstaja!");
        }
    }

    protected function getStructure($name, $type, $subType, $labAns, $labLeg, $labAtt)
    {
        // singleresponse
        if ($type == 1) {
            $this->alterTableData[] = " ADD `" . $name . "` INT( 3 ) NULL";
            $this->warptiVars[] = $name;
            return $name;
        }

        // scale in scale dropdown
        if (($type == 2 and ($subType == 1 or $subType == 2)) or ($type == 3 and $subType == 1)) {
            $i = 1;
            foreach ($labAns as $item) {
                $tmp[] = $name . "_" . $i;
                $this->alterTableData[] = " ADD `" . $name . "_" . $i . "` INT( 3 ) NULL";
                $this->warptiVars[] = $name . "_" . $i;
                $i++;
            }
            return implode(",", $tmp);
        }

        // scale with attributes
        if ($type == 2 and $subType == 3) {
            $i = 1;
            foreach ($labLeg as $item) {
                $n = 1;
                foreach ($labAtt as $att) {
                    $tmp[] = $name . "_" . $i . "_" . $n;
                    $this->alterTableData[] = " ADD `" . $name . "_" . $i . "_" . $n . "` INT( 3 ) NULL";
                    $this->warptiVars[] = $name . "_" . $i . "_" . $n;
                    $n++;
                }
                $i++;
            }
            return implode(",", $tmp);
        }

        // scale invert
        if ($type == 2 and $subType == 5) {
            $i = 1;
            foreach ($labLeg as $item) {
                $tmp[] = $name . "_" . $i;
                $this->alterTableData[] = " ADD `" . $name . "_" . $i . "` INT( 3 ) NULL";
                $this->warptiVars[] = $name . "_" . $i;
                $i++;
            }
            return implode(",", $tmp);
        }

        // multi with legend
        if ($type == 3 and $subType == 2) {
            $i = 1;
            foreach ($labLeg as $item) {
                $n = 1;
                foreach ($labLeg as $leg) {
                    $tmp[] = $name . "_" . $i . "_" . $n;
                    $this->alterTableData[] = " ADD `" . $name . "_" . $i . "_" . $n . "` INT( 3 ) NULL";
                    $this->warptiVars[] = $name . "_" . $i . "_" . $n;
                    $n++;
                }
                $i++;
            }
            return implode(",", $tmp);
        }

    }

    protected function insertResCalc($resName, $calcArray)
    {
        if (!empty($calcArray)) {
            foreach ($calcArray as $calc) {

                $labAns = array();
                $labLeg = array();
                $labAtt = array();

                $varType = $calc['prop']['tip_sql'];
                $varSubType = 1;

                if ($varType == 2 and $calc['prop']['les_sql'] == 2) {
                    $varSubType = 2;
                }

                if ($varType == 2 and $calc['prop']['les_sql'] == 2 and isset($calc['labs'][5])) {
                    $varSubType = 3;
                }

                if ($varType == 2 and $calc['prop']['les_sql'] == 5) {
                    $varSubType = 5;
                }

                if ($varType == 3 and isset($calc['labs'][4])) {
                    $varSubType = 2;
                }

                if (isset($calc['labs'][3])) {
                    $labAns = explode("/", $calc['labs'][3]);
                }

                if (isset($calc['labs'][4])) {
                    $labLeg = explode("/", $calc['labs'][4]);
                }

                if (isset($calc['labs'][5])) {
                    $labAtt = explode("/", $calc['labs'][5]);
                }

                $questionVars = $this->getStructure($calc['prop']['q_name'], $varType, $varSubType, $labAns, $labLeg, $labAtt);

                $strIns = "";
                $strQue = "";
                $strAns = "";
                $strLeg = "";
                $strCat = "";
                if (isset($calc['labs'][1])) {
                    $strIns = $calc['labs'][1];
                }

                if (isset($calc['labs'][2])) {
                    $strQue = $calc['labs'][2];
                }

                if (isset($calc['labs'][3])) {
                    $strAns = $calc['labs'][3];
                }

                if (isset($calc['labs'][4])) {
                    $strLeg = $calc['labs'][4];
                }

                if (isset($calc['labs'][5])) {
                    $strCat = $calc['labs'][5];
                }

                $sqlCalc = "INSERT INTO " . DB_WARPIT_STATVIEW . "." . $resName . "___calculated ";
                $sqlCalc .= " SET id_question='" . mysql_real_escape_string($calc['prop']['id']) . "'";
                $sqlCalc .= ", questionName='" . mysql_real_escape_string($calc['prop']['q_name']) . "'";
                $sqlCalc .= ", questionVars='" . mysql_real_escape_string($questionVars) . "'";
                $sqlCalc .= ", questionType=" . mysql_real_escape_string($varType);
                $sqlCalc .= ", questionSubType=" . mysql_real_escape_string($varSubType);
                $sqlCalc .= ", questionOpenCount=0";
                $sqlCalc .= ", instruction='" . mysql_real_escape_string($strIns) . "'";
                $sqlCalc .= ", question='" . mysql_real_escape_string($strQue) . "'";
                $sqlCalc .= ", answer='" . mysql_real_escape_string($strAns) . "'";
                $sqlCalc .= ", legend='" . mysql_real_escape_string($strLeg) . "'";
                $sqlCalc .= ", category='" . mysql_real_escape_string($strCat) . "'";
                $sqlCalc .= ", title=''";
                $sqlCalc .= ", graph_instruction=''";
                $sqlCalc .= ", graph_question=''";
                $sqlCalc .= ", graph_answer=''";
                $sqlCalc .= ", graph_legend=''";
                $sqlCalc .= ", graph_category=''";
                $sqlCalc .= ", graph_title=''";
                $sqlCalc .= ", data=''";
                $sqlCalc .= ", id_tableTemplate=0";
                $sqlCalc .= ", id_graphTemplate=0";
                $sqlCalc .= ", missings='0'";
                $sqlCalc .= ", hideAnswers=''";
                $sqlCalc .= ", hideQuestion=0";
                $sqlCalc .= ", comment=''";
                $sqlCalc .= ", crosstabVariables=''";

                //echo "$sqlCalc";
                if (!$resultCalc = $this->db->SQLexecute($sqlCalc)) {
                    return $this->db->JsonError();
                }
            }
        }
    }

    protected function insertResData($resName)
    {
        $altSql = "ALTER TABLE " . DB_WARPIT_STATVIEW . "." . $resName . "___data " . implode(",", $this->alterTableData);
        if (!$result = $this->db->SQLexecute($altSql)) {
            return $this->db->JsonError();
        }

        //$this -> dbWarpitConnect();
        if ($warpitDatabase = $this->getWarpitProjectDatabase()) {
            $this->dbWarpit->ChangeDatabase($warpitDatabase);

            if (isset($this->warptiVars)) {
                $warpitVars = "," . implode(",", $this->warptiVars);
            }

            //Spremenil Boštjan Janžovnik 12.01.2017 - ni importalo podatkov z warpita med uvozom.
            $sql = "SELECT id,status $warpitVars FROM " . mysql_real_escape_string($this->name_project) . "_structure WHERE status=1 AND status_rec=1";
            //$sql = "SELECT id,status $warpitVars FROM " . DB_WARPIT_STATVIEW . "." . $resName . "___data WHERE status=1 AND status_rec=1";

            //echo $sql."<br>";
            if (!$res = $this->dbWarpit->SQLexecute($sql)) {
                return $this->dbWarpit->JsonError();
            };

            while ($zad = $this->dbWarpit->fetchAssoc($res)) {
                $sqlIns = "INSERT INTO " . DB_WARPIT_STATVIEW . "." . $resName . "___data (`id`, `status` $warpitVars) VALUES ('" . implode("','", $zad) . "')";
                //echo "$sqlIns";
                if (!$result = $this->db->SQLexecute($sqlIns)) {
                    return $this->db->JsonError();
                }
            }
        }
    }

    protected function insertRes($resName, $mainData)
    {
        if (isset($mainData)) {
            $sqlMain = "INSERT INTO " . DB_WARPIT_STATVIEW . "._research SET ";
            $sqlMain .= "project='" . mysql_real_escape_string($resName) . "'";
            $sqlMain .= ($mainData['long_name']) ? ", long_name='" . mysql_real_escape_string($mainData['long_name']) . "'" : '';
            $sqlMain .= ", weighted=0";
            $sqlMain .= ", created_ux=" . time();
            $sqlMain .= ", modified_ux=" . time();
            $sqlMain .= ", showWidth=2";
            $sqlMain .= ", colorShema=1";
            $sqlMain .= ", weight_factors='weight,unweight'";
            $sqlMain .= ", weightVar='unweight'";
            $sqlMain .= ", deleted=0";
            $sqlMain .= ", created_idUser=" . mysql_real_escape_string($_SESSION['UserInfo']['id']);
            $sqlMain .= ", modified_idUser=" . mysql_real_escape_string($_SESSION['UserInfo']['id']);

            if (!$result = $this->db->SQLexecute($sqlMain)) {
                return $this->db->JsonError();
            }
        }
    }

    protected function createBasicStructure($resName)
    {
        $sql = "CREATE TABLE IF NOT EXISTS `" . DB_WARPIT_STATVIEW . "`.`" . $resName . "___calculated` (
              `id` int(5) NOT NULL AUTO_INCREMENT,
              `id_question` int(5) NOT NULL,
              `questionName` varchar(30) NOT NULL,
              `questionVars` text,
              `questionType` tinyint(1) NOT NULL,
              `questionSubType` tinyint(1) NOT NULL,
              `questionOpenCount` tinyint(1) NOT NULL,
              `instruction` text NOT NULL,
              `question` text NOT NULL,
              `answer` text NOT NULL,
              `legend` text NOT NULL,
              `category` text NOT NULL,
              `title` text NOT NULL,
              `graph_instruction` text NOT NULL,
              `graph_question` text NOT NULL,
              `graph_answer` text NOT NULL,
              `graph_legend` text NOT NULL,
              `graph_category` text NOT NULL,
              `graph_title` text NOT NULL,
              `data` text NOT NULL,
              `id_tableTemplate` int(5) NOT NULL,
              `id_graphTemplate` int(5) NOT NULL,
              `missings` varchar(255) DEFAULT NULL,
              `missings_mean` varchar(255) DEFAULT '0',
              `hideAnswers` varchar(255) DEFAULT NULL,
              `hideQuestion` tinyint(1) NOT NULL,
              `comment` text NOT NULL,
              `crosstabVariables` text NOT NULL,
              PRIMARY KEY (`id`),
              KEY `hideQuestion` (`hideQuestion`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";

        if (!$result = $this->db->SQLexecute($sql)) {
            return $this->db->JsonError();
        }

        $sql = "CREATE TABLE IF NOT EXISTS `" . DB_WARPIT_STATVIEW . "`.`" . $resName . "___events` (
              `id` int(5) NOT NULL AUTO_INCREMENT,
              `id_question` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
              `eventName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
              `event` text COLLATE utf8_unicode_ci,
              `eventTime` int(11) unsigned DEFAULT NULL,
              PRIMARY KEY (`id`),
              KEY `id_question` (`id_question`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;";

        if (!$result = $this->db->SQLexecute($sql)) {
            return $this->db->JsonError();
        }

        $sql = "CREATE TABLE IF NOT EXISTS `" . DB_WARPIT_STATVIEW . "`.`" . $resName . "___data` (
              `id` int(7) NOT NULL AUTO_INCREMENT,
              `weight` double DEFAULT '1',
              `unweight` int(1) DEFAULT '1',
              `research_id` int(5) DEFAULT NULL,
              `user_id` int(5) DEFAULT NULL,
              `user_type` tinyint(4) DEFAULT NULL,
              `id_device` tinyint(4) DEFAULT NULL,
              `id_language` tinyint(4) DEFAULT NULL,
              `id_site` char(250) COLLATE utf8_unicode_ci DEFAULT NULL,
              `status` int(3) DEFAULT NULL,
              `status_rec` int(3) DEFAULT NULL,
              `flag_bad` int(3) unsigned DEFAULT NULL,
              `t_start` int(11) unsigned DEFAULT NULL,
              `t_stop` int(11) unsigned DEFAULT NULL,
              PRIMARY KEY (`id`),
              INDEX `research_id` (`research_id`),
              INDEX `weight` (`weight`),
              INDEX `user_id` (`user_id`),
              INDEX `user_type` (`user_type`),
              INDEX `id_device` (`id_device`),
              INDEX `id_language` (`id_language`),
              INDEX `status` (`status`),
              INDEX `status_rec` (`status_rec`),
              INDEX `t_start` (`t_start`),
              INDEX `t_stop` (`t_stop`),
              INDEX `flag_bad` (`flag_bad`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;";

        if (!$result = $this->db->SQLexecute($sql)) {
            return $this->db->JsonError();
        }
    }
}
