<?php
//ini_set("display_errors", 1);
include_once("_dirinfo.php");
include_once(PATH_TO_ROOT.'statview/init.php');
include_once(PATH_TO_ROOT.'statview/_class/class_calculate.php');
include_once(PATH_TO_ROOT.'statview/_class/class_labels.php');
include_once(PATH_TO_ROOT.'statview/_class/class.selector.php');
include_once(PATH_TO_ROOT.'statview/_class/class.crossing.php');
include_once(PATH_TO_ROOT.'statview/_class/class.graphOptions.php');

class ChartData {
	private $db;
	private $chartType;
	private $subType;
	private $idQuestion;
	private $idCross;
	private $idProject;
	private $selector;
	private $calculate;
	private $lables;
	private $projectName;
	private $params;
	private $chartOptions;
	private $decimalNum;
	
	public function __construct($db, $chartType, $subType, $idQuestion, $idCross, $idProject) {
		$this->db = $db;
		$this->chartType = $chartType;
		$this->subType = $subType;
		$this->idQuestion = $idQuestion;
		$this->idCross = $idCross;
		$this->idProject = $idProject;
		$this->selector = new Selector($db);
		$this->projectName = str_replace(" ", "_", $this->selector->getProjectName($idProject));
		$this->calculate = new Calculate($db, '_projects', $this->projectName, $idProject);
		$this->labels = new Labels($db, '_projects', $this->projectName, $idProject);
		$this->labels->setQuestion($idQuestion);
		$this->calculate->setQuestion($idQuestion);
		$this->params = $this->calculate->getParameters();
		$options = new options();
		$this->chartOptions = $options->graphOptions($idQuestion, $idCross, $idProject, $subType, $chartType);
		$this->decimalNum = (isset($this->chartOptions["proc_decimal"][0]) ? $this->chartOptions["proc_decimal"][0] : 1);
	}

	public function getQuestionType() {
		return $this->params["questionType"];
	}
	
	public function getXAxisLabels() {
		if (empty($this->idCross)) {
			$xLabels = $this->labels->getLabels();
			return array_values($xLabels[$this->idQuestion]["answers"]);		
		}
		else {
			$crossTabs = $this->calculate->getCrosstabs($this->idCross);
			return array_values($crossTabs["labels"][$this->idQuestion]["answers"]);
		}
	}
	
	public function getYAxisLabels() {
		if (!empty($this->idCross)) {
			$crossTabs = $this->calculate->getCrosstabs($this->idCross);
			return array_values($crossTabs["labels"][$this->idCross]["answers"]);		
		}
		
		return null;
	}
	
	public function getColumnLineChartSeries() {
		if (empty($this->idCross)) {
			$frequencies = $this->calculate->getFrequencies();
			$xLabels = $this->labels->getLabels();
			
			$series[0]["id"] = 1;
			$series[0]["showInLegend"] = false;
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = addslashes($xLabels[$this->idQuestion]["question"]);
			
			if (isset($this->chartOptions["pointWidth"][0])) {
				$series[0]["pointWidth"] = $this->chartOptions["pointWidth"][0];
			}
			
			if ($this->setDataColor(0)) {
				$series[0]["color"] = $this->setDataColor(0);
			}
			
			foreach ($frequencies[$this->idQuestion] as $key => $value) {
				if (isset($this->chartOptions["percentData"][0])) {
					$series[0]["data"][] = round(($value / $this->getTotal()) * 100, $this->decimalNum);
				} else {
					$series[0]["data"][] = floatval($value);				
				}
			}
		}
		else {
			$crossTabs = $this->calculate->getCrosstabs($this->idCross);
			
			$i = 0;
			foreach ($crossTabs["labels"][$this->idCross]["answers"] as $crossKey => $crossVal) {
				$series[$i]["id"] = $i + 1;
				$series[$i]["type"] = $this->chartType;
				
				if (isset($this->chartOptions["legendLabelLenght"][0])) {
					$shortName = explode(" ", $crossVal);
					array_splice($shortName, $this->chartOptions['legendLabelLenght'][0]);
					$series[$i]["name"] = addslashes(implode(" ", $shortName)); 
				} else {
					$series[$i]["name"] = addslashes($crossVal);				
				}
				
				$series[$i]["data"] = array();
				
				if ($this->setDataColor($i)) {
					$series[$i]["color"] = $this->setDataColor($i);
				}
				
				$j = 0;
				foreach ($crossTabs["cross"][$this->idQuestion] as $key => $value) {
					if ($this->chartOptions["percentData"][0] == "on") {
						if ($this->chartOptions["percentType"][0] == "row") {
							$rowTotal = $this->getTotal("row_sum");
							$series[$i]["data"][$j] = round(($value[$this->idCross][$crossKey] / $rowTotal[$i]) * 100, $this->decimalNum);
						} else {
							$colTotal = $this->getTotal("col_sum");
							$series[$i]["data"][$j] = round(($value[$this->idCross][$crossKey] / $colTotal[$j]) * 100, $this->decimalNum);
						}
					} else {
						$series[$i]["data"][$j] = floatval($value[$this->idCross][$crossKey]);				
					}
					
					$j++;	
				}
				
				$i++;
			}
		}
		
		return $series;
	}

	public function getPieChartSeries() {
		if (empty($this->idCross)) {
			$frequencies = $this->calculate->getFrequencies();			
			$xLabels = $this->labels->getLabels();
			
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = "Value";
			$series[0]["showInLegend"] = (isset($this->chartOptions["pieLegendEnable"][0]) ? true : false);
			
			$i = 0;
			foreach ($frequencies[$this->idQuestion] as $key => $value) {
				if (isset($this->chartOptions['stBesedLegPie'][0])) {
					$shortLabel = explode(" ", $xLabels[$this->idQuestion]["answers"][$key]);
					array_splice($shortLabel, $this->chartOptions['stBesedLegPie'][0]);
					$series[0]["data"][$i]["name"] = addslashes(implode(" ", $shortLabel));
				} else {
					$series[0]["data"][$i]["name"] = addslashes($xLabels[$this->idQuestion]["answers"][$key]);
				}
				
				$series[0]["data"][$i]["x"] = floatval($value);
				$series[0]["data"][$i]["y"] = round(($value / $this->getTotal()) * 100, $this->decimalNum);
				
				if ($this->setDataColor($i)) {
					$series[0]["data"][$i]["color"] = $this->setDataColor($i);
				}
				
				$i++;
			}
		}
		else {
			//TODO: tu naprej
			$crossTabs = $this->calculate->getCrosstabs($this->idCross);
			
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = addslashes($crossTabs["labels"][$this->idCross]["question"]);
			$series[0]["id"] = 1;
			$series[0]["size"] = "60%";
			$series[0]["dataLabels"] = "formatter: function() {
				return this.y > 1 ? this.point.name : null;
			},
			distance: -30";
			$series[0]["data"] = array();
			
			$series[1]["type"] = $this->chartType;
			$series[1]["name"] = addslashes($crossTabs["labels"][$this->idQuestion]["question"]);
			$series[1]["id"] = 2;
			$series[1]["size"] = "80%";
			$series[1]["innerSize"] = "60%";
			$series[1]["dataLabels"] = "formatter: function() {
				return this.y > 1 ? this.point.name : null;
			}";
			$series[1]["data"] = array();
			
			$i = 0;
			$tmpArray = array();
			//$sumArray = array();
			
			foreach ($crossTabs["cross"][$this->idQuestion] as $key => $value) {
				$j = 0;
								
				foreach ($value[$this->idCross] as $crossKey => $crossVal) {
					$series[0]["data"][$j]["y"] += $crossVal;
					$series[0]["data"][$j]["name"] = addslashes($crossTabs["labels"][$this->idCross]["answers"][$crossKey]);
					
					$tmpArray[$crossKey][$i]["y"] = $crossVal;
					$tmpArray[$crossKey][$i]["name"] = addslashes($crossTabs["labels"][$this->idQuestion]["answers"][$key]);
					//$sumArray[$crossKey] += $crossVal;
					
					if ($this->setDataColor($j)) {
						$series[0]["data"][$j]["color"] = $this->setDataColor($j);
						$tmpArray[$crossKey][$i]["color"] = $this->setDataColor($j);
					}
					
					$j++;
				}
				
				$i++;
			}
			
			foreach ($tmpArray as $key => $value) {
				foreach ($value as $subKey => $subVal) {
					$series[1]["data"][] = $subVal;
				}
			}
		}
		
		return $series;
	}

	public function getScaleColumnLineChartSeries() {
		$xLabels = $this->labels->getLabels();
		
		if ($this->subType == 1) {
			$descriptives = $this->calculate->getDescriptives();
			
			$series[0]["id"] = 1;
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = addslashes($xLabels[$this->idQuestion]["question"]);
			
			if ($this->setDataColor(0)) {
				$series[0]["color"] = $this->setDataColor(0);
			}
			
			foreach ($descriptives[$this->idQuestion] as $key => $value) {
				$series[0]["data"][] = floatval($value["sv"]);
			}
		} 
		else {
			$frequencies = $this->calculate->getFrequencies();
			$legendLabels = array_values($xLabels[$this->idQuestion]["legend"]);
			
			$i = 0;
			foreach ($frequencies[$this->idQuestion] as $key => $value) {
				$series[$i]["id"] = $i + 1;
				$series[$i]["type"] = $this->chartType;
				$series[$i]["name"] = addslashes($legendLabels[$i]);
				$series[$i]["data"] = array();
				
				if ($this->setDataColor($i)) {
					$series[$i]["color"] = $this->setDataColor($i);
				}
				
				$j = 0;
				foreach ($value as $subKey => $subVal) {
					$series[$i]["data"][$j] = floatval($subVal);
					$j++;
				}
				
				$i++;
			}
		}
		
		return $series;
	}
	
	public function getScalePieChartSeries() {
		$xLabels = $this->labels->getLabels();
		$answers = array_values($xLabels[$this->idQuestion]["answers"]);
		
		if ($this->subType == 1 || $this->subType == 2) {
			$descriptives = $this->calculate->getDescriptives();
			
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = "Value";
			
			$i = 0;
			foreach ($descriptives[$this->idQuestion] as $key => $value) {
				$series[0]["data"][$i]["name"] = addslashes($answers[$i]);
				$series[0]["data"][$i]["y"] = floatval($value["sv"]);
				
				if ($this->setDataColor($i)) {
					$series[0]["data"][$i]["color"] = $this->setDataColor($i);
				}
				
				$i++;
			}
		}
		else {
			$frequencies = $this->calculate->getFrequencies();
			$legendLabels = array_values($xLabels[$this->idQuestion]["legend"]);
			
			$series[0]["type"] = $this->chartType;
			$series[0]["name"] = "Value";
			$series[0]["id"] = 1;
			$series[0]["size"] = "60%";
			$series[0]["dataLabels"] = "formatter: function() {
				return this.y > 1 ? this.point.name : null;
			},
			distance: -30";
			$series[0]["data"] = array();
			
			$series[1]["type"] = $this->chartType;
			$series[1]["name"] = "Value";
			$series[1]["id"] = 2;
			$series[1]["size"] = "80%";
			$series[1]["innerSize"] = "60%";
			$series[1]["dataLabels"] = "formatter: function() {
				return this.y > 1 ? this.point.name : null;
			}";
			$series[1]["data"] = array();
			
			$i = 0;
			$k = 0;
			foreach ($frequencies[$this->idQuestion] as $key => $value) {
				$series[0]["data"][$i]["y"] = array_sum($value);
				$series[0]["data"][$i]["name"] = addslashes($answers[$i]);
				
				if ($this->setDataColor($i)) {
					$series[0]["data"][$i]["color"] = $this->setDataColor($i);
				}
				
				$j = 0;
				foreach ($value as $subKey => $subVal) {
					$series[1]["data"][$k]["y"] = floatval($subVal);
					$series[1]["data"][$k]["name"] = addslashes($legendLabels[$j]);
					
					if ($this->setDataColor($i)) {
						$series[1]["data"][$k]["color"] = $this->setDataColor($i);
					}
						
					$j++;
					$k++;
				}
				
				$i++;
			}
		}
		
		return $series;
	}
	
	private function getTotal($totalType = null) {
		if ($this->getQuestionType() != 2) {
			if (empty($this->idCross)) {
				$frequencies = $this->calculate->getFrequencies();
				return array_sum($frequencies[$this->idQuestion]);
			}
			else {
				$crossTabs = $this->calculate->getCrosstabs($this->idCross);
				$rowSum = array();
				$colSum = array();
				
				$tmpArray = array();
				$i = 0;
				foreach ($crossTabs["cross"][$this->idQuestion] as $key => $value) {
					$colSum[$i] = array_sum($value[$this->idCross]);
					
					$j = 0;
					foreach ($value[$this->idCross] as $subKey => $subVal) {
						$tmpArray[$j][$i] = $subVal; 
						$j++;
					}
					$i++;
				}
				
				foreach ($tmpArray as $key => $value) {
					$rowSum[$key] = array_sum($value);
				}
				
				return ($totalType == "col_sum" ? $colSum : $rowSum);	
			}
		} else {
			//TODO: pridobi total za scale vprašanje
		}
	}
	
	private function getColors() {
		$colorShema = $this->selector->getProjectColorOptions($this->projectName);
		$colors = array();
		
		if (!empty($colorShema["colors"])) {
			$colorShema["colors"] = $colorShema["colors"].",".$colorShema["colors"];
			$colors = explode(",", $colorShema["colors"]);
		}
		
		return $colors;
	}
	
	private function setDataColor($index) {
		$colors = $this->getColors();
		
		if (!empty($colors)) {
			if (array_key_exists($index, $colors)) {
				return $colors[$index];
			}
		}
		
		return false;
	}
}
?>

