<?php
	include_once ("_dirinfo.php");
	include_once (PATH_TO_ROOT . "_config/dbConfig.php");
	require_once (PATH_TO_ROOT . "statview/_class/system/postgis.php");
	require_once (PATH_TO_ROOT . "statview/_class/class.MapServer.php");
	include_once (PATH_TO_ROOT . "statview/_class/class.selector.php");
	include_once (PATH_TO_ROOT . "statview/_class/class.maps.php");
	include_once (PATH_TO_ROOT . "statview/_class/class.projectgenerator.php");
	include_once (PATH_TO_ROOT . 'statview/_class/class_calculate.php');
	include_once (PATH_TO_ROOT . 'statview/_class/class_labels.php');
	include_once (PATH_TO_ROOT . 'statview/_class/class.crossing.php');
	
	// if (!isset($_SESSION['mapfile']))  $_SESSION['mapfile'] = "/var/www/tmp/" . md5(rand()) . ".map";
	
	if (isset($_POST['action'])) {
			
		if ($_POST['action'] == 'updateLayer') {
			$type = $_POST['type'];
			$subId = isset($_POST['sub_id']) ? $_POST['sub_id'] : false;
			
			$idP = $_POST['idP'];
			$idQ = $_POST['idQ'];
			$idA = $_POST['aId'];
			
			$ids = array();
			
			// Time dimension
			$sel = new Selector($db);
			$maps = new Maps($db);
			
			$sliderPar1 = false;
			$sliderPar2 = false;
			
			if($_POST['time_dimension']['type'] == 'range') {
				$vals = explode(",", $_POST['time_dimension']['values']);
				$sliderPar1 = $vals[0];
				$sliderPar2 = $vals[1];

			}
			
			else if($_POST['time_dimension']['type'] == 'months') {
				$sliderPar1 =  explode(",", $_POST['time_dimension']['values']);
			}

			$category = (in_array($type, array('reg', 'ob'))) ? 1 : 2;
			$ids = $maps -> getLayersIntersection($category, $subId);
			
			$jsonMapData = $maps->getMapData($idP, $idQ, str_replace("ob", "obc", $type), $idA, $subId, $sliderPar1, $sliderPar2);
			$jsonMapLegend = $maps->getJsonMapLegend($idP, $idQ, str_replace("ob", "obc", $type), $idA, $subId);
			$mapfile = $maps -> generateMap($jsonMapData, $jsonMapLegend, $ids);
			
			echo json_encode(array("success"=> true));
		}
		
		else if ($_POST['action'] == 'getNextFeature') {
			
			$type = $_POST['type'];
			$subId = isset($_POST['sub_id']) ? $_POST['sub_id'] : false;
			$zoomable = ($_POST['zoom'] == "false" or $_POST['zoom'] == false) ? false : true;
			$coord = explode(", ", $_POST['coord']);
			
			$newType = ($_POST['newType'] == "false" or $_POST['newType'] == false) ? false : $_POST['newType'];
			
			$idP = $_POST['idP'];
			$idQ = $_POST['idQ'];
			$idA = $_POST['aId'];

			$geom = 'POINT('.$coord[0].' '.$coord[1].')';
			$proj = '3857';

			$maps = new Maps($db);
			$types = $maps -> getEnabledMapTypes($idP, $idQ);

			$categories = $maps -> getMapCategories($idP, $idQ, $type);
			$selCat = array();
			$catIndex = 0;
			
			foreach ($categories as $value) {
				foreach ($value as $key=> $item) {
					if ($type == $item) {
						$selCat = $value;
						$catIndex = $key;
					}
				}
			}
			
			if ($type == 'reg' || $type == 've') {
				
				$ime = ($type == 'reg' or $type == 'ob') ? "Prikaz regije: " : "Prikaz volilne enote: ";
				
				$sql = "SELECT ".$type."_id,".$type."_uime,ST_Extent(ST_Transform(the_geom, 3857)) as extent FROM layers.".$type;
				$sql .= ($entire) ? "" : " WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom)";
				$sql .= " GROUP BY ".$type."_id,".$type."_uime;";
				$res = pg_query($sql);
				
				$geom = false;
				
				if ($res) {
					if (pg_num_rows($res) > 0) {
						$row = pg_fetch_row($res);
						
						if ($index < count($category) - 1) $subId = $row[0];
						$ime .= $row[1];
						$geom = $row[2];
						$geom = str_replace("BOX(", "", $geom);
						$geom = str_replace(")", "", $geom);
						$geom = str_replace(",", " ", $geom);
						$geom = explode(" ", $geom);
					}
				}
			} else {
				$geom = false;
			}
			
			// Time dimension
			$sel = new Selector($db);
			
			$sliderPar1 = false;
			$sliderPar2 = false;
			
			if($_POST['time_dimension']['type'] == 'range') {
				$vals = explode(",", $_POST['time_dimension']['values']);
				$sliderPar1 = $vals[0];
				$sliderPar2 = $vals[1];

			}
			
			else if($_POST['time_dimension']['type'] == 'months') {
				$sliderPar1 =  explode(",", $_POST['time_dimension']['values']);
			}
			
			// response
			$zoomIn = false;
			$maxExtent = false;
			$sub = false;
			$maplegend = false;
			
			// Ročna selekcija
			if ($newType != false) {
				$sub = $_POST['newType'];
				$subId = false;
				
				$jsonMapData = $maps->getMapData($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId, $sliderPar1, $sliderPar2);
				$jsonMapLegend = $maps->getJsonMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
				
				$maplegend = $maps -> getMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
				$mapfile = $maps -> generateMap($jsonMapData, $jsonMapLegend, $ids);
				
				$view = array_search($sub, $types['data']);
				
				$ime = "";
				if ($sub == "reg") $ime = "Prikaz regij v Sloveniji";
				if ($sub == "ob") $ime = "Prikaz občin v Sloveniji";
				if ($sub == "ve") $ime = "Prikaz volilnih enot v Sloveniji";
				if ($sub == "vo") $ime = "Prikaz volilnih območij v Sloveniji";
				
				echo json_encode(array("success"=> true, "manual"=> true, "mapType"=> $sub, "view"=> $view, "ime"=> $ime, "legend"=> $maplegend, "subId"=> $subId));
			}
			
			// Zadnji element v kategoriji
			else if ($catIndex == count($selCat)-1) {
				if ($zoomable) {
					$zoomIn = TRUE;
					$sub = false;
					
					echo json_encode(array("success"=> true, "sub"=> false, "zoomIn"=> $zoomIn, "maxExtent"=> $maxExtent, "mapType"=> $sub));
				} else {
					$sub = $selCat[0];
					
					$tt = array_search($sub, $types['data']);
					if ($tt < $_POST['startType']) {
						$sub = $types['data'][$_POST['startType']];
					}
					
					$view = array_search($sub, $types['data']);
					$subId = false;
					
					$jsonMapData = $maps->getMapData($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId, $sliderPar1, $sliderPar2);
					$jsonMapLegend = $maps->getJsonMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
					
					$maplegend = $maps -> getMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
					$mapfile = $maps -> generateMap($jsonMapData, $jsonMapLegend, $ids);
					
					$ime = "";
					if ($sub == "reg") $ime = "Prikaz regij v Sloveniji";
					if ($sub == "ob") $ime = "Prikaz občin v Sloveniji";
					if ($sub == "ve") $ime = "Prikaz volilnih enot v Sloveniji";
					if ($sub == "vo") $ime = "Prikaz volilnih območij v Sloveniji";
					
					echo json_encode(array("success"=> true, "manual"=> true, "mapType"=> $sub, "view"=> $view, "ime"=> $ime, "legend"=> $maplegend, "subId"=> $subId));
				}
			}
			
			// Zunaj grafike
			else if ($geom == false or count($selCat) == 1) {
				if ($zoomable) $zoomIn = TRUE;
				else  $maxExtent = TRUE;
				
				$sub = false;
				echo json_encode(array("success"=> true, "zoomIn"=> $zoomIn, "sub"=> false, "maxExtent"=> $maxExtent, "mapType"=> $sub));
			}
			
			// Naslednji element (parent ID)
			else {
				$sub = $selCat[$catIndex+1];
				$view = array_search($sub, $types['data']);
				
				$category = (in_array($sub, array('reg', 'ob'))) ? 1 : 2;
				$ids = $maps -> getLayersIntersection($category, $subId);
				
				$jsonMapData = $maps->getMapData($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId, $sliderPar1, $sliderPar2);
				$jsonMapLegend = $maps->getJsonMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
				
				$maplegend = $maps -> getMapLegend($idP, $idQ, str_replace("ob", "obc", $sub), $idA, $subId);
				$mapfile = $maps -> generateMap($jsonMapData, $jsonMapLegend, $ids);
				
				echo json_encode(array("success"=> true, "mapType"=> $sub, "view"=> $view, "bounds"=> $geom, "ime"=> $ime, "legend"=> $maplegend, "subId"=> $subId));
			}
		}

		else if ($_POST['action'] == 'getLayerPositionData') {
			$type = $_POST['mapType'];
			$coord = explode(", ", $_POST['coord']);
			$subId = isset($_POST['sub_id']) ? $_POST['sub_id'] : false;
			
			$idP = $_POST['idP'];
			$idQ = $_POST['idQ'];
			$idA = $_POST['aId'];
			
			$geom = 'POINT('.$coord[0].' '.$coord[1].')';
			$proj = '3857';
			
			$row_id = $type . "_id";
			$row_name = $type . "_uime";
			
			$sql = "SELECT $row_id,$row_name FROM layers.".$type." WHERE ST_Within(ST_Transform(ST_GeomFromText('".$geom."', ".$proj."), 37870), the_geom);";
			$res = pg_query($sql);
			
			$id = false;
			$name = "";
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					$row = pg_fetch_row($res);
					
					$id = $row[0];
					$name = $row[1];
				}
			}
			
			if ($id !== false) {
				$maps = new Maps($db);
				$sel = new Selector($db);
			
				$sliderPar1 = false;
				$sliderPar2 = false;
				
				if($_POST['time_dimension']['type'] == 'range') {
					$vals = explode(",", $_POST['time_dimension']['values']);
					$sliderPar1 = $vals[0];
					$sliderPar2 = $vals[1];

				}
				
				else if($_POST['time_dimension']['type'] == 'months') {
					$sliderPar1 =  explode(",", $_POST['time_dimension']['values']);
				}

				$jsonAreaData = $maps->getJsonAreaData($idP, $idQ, str_replace("ob", "obc", $type), $idA, $id, $subId, $sliderPar1, $sliderPar2);
				$data = json_decode(htmlspecialchars_decode($jsonAreaData), true);
				$data = $data['data'];
			}
			
			echo json_encode(array("name"=> $name, "data"=> $data, "sub_id"=> $subId, "id"=> $id));
		}

		else if ($_POST['action'] == 'getFixLayerData') {
			$type = $_POST['mapType'];
			
			$idP = $_POST['idP'];
			$idQ = $_POST['idQ'];
			$idA = $_POST['aId'];
			
			$subId = isset($_POST['sub_id']) ? $_POST['sub_id'] : FALSE;
			
			$row_id = $type . "_id";
			$row_name = $type . "_uime";
			
			$where = "";
			
			if ($subId != false) {
				$category = (in_array($type, array('reg', 'ob'))) ? 1 : 2;
				
				$sql = "SELECT child_id FROM _layer_interconnection WHERE parent_id='$subId' and category='$category';";
				$res = mysql_query($sql);
				
				if ($res) {
					if (mysql_num_rows($res)) {
						while ($row = mysql_fetch_assoc($res)) {
							$ids[] = $row['child_id'];
						}
					}
				}
				
				if ($ids) $where = "WHERE $row_id IN (" . implode(",", $ids) . ")";
			}
			
			$sql = "SELECT $row_id,$row_name FROM ".DB_WARPIT_STATVIEW.".layers.".$type." $where;";
			$res = pg_query($sql);
			
			$items = array();
			$maps = new Maps($db);
			
			$sel = new Selector($db);
			
			$sliderPar1 = false;
			$sliderPar2 = false;
			
			if($_POST['time_dimension']['type'] == 'range') {
				$vals = explode(",", $_POST['time_dimension']['values']);
				$sliderPar1 = $vals[0];
				$sliderPar2 = $vals[1];

			}
			
			else if($_POST['time_dimension']['type'] == 'months') {
				$sliderPar1 =  explode(",", $_POST['time_dimension']['values']);
			}
			
			if ($res) {
				if (pg_num_rows($res) > 0) {
					while($row = pg_fetch_row($res)) {
						$id = $row[0];
						$name = $row[1];
						
						$jsonAreaData = $maps->getJsonAreaData($idP, $idQ, str_replace("ob", "obc", $type), $idA, $id, $subId, $sliderPar1, $sliderPar2);
						$data = json_decode(htmlspecialchars_decode($jsonAreaData), true);
						
						$items[$row[0]] = array("name"=> $name, "num"=> $data['data']['num'], "proc"=> $data['data']['proc']);
					}
				}
			}
			
			echo json_encode(array("items"=> $items, "sql"=> $sql));
		}

		else if ($_POST['action'] == 'generateExportImage') {
			$image = imagecreatefromjpeg(htmlspecialchars_decode($_POST['url']));
			
			if (!$image) {
				echo json_encode(array("success"=> false));
				exit();
			}
			
			$type = $_POST['type'];
			$layers = explode(",", $_SESSION['layers']);
			
			$idP = $_POST['idP'];
			$idQ = $_POST['idQ'];
			$idA = $_POST['aId'];
			
			$subId = isset($_POST['sub_id']) ? $_POST['sub_id'] : false;
			
			$maps = new Maps($db);
			
			$jsonMapLegend = $maps->getJsonMapLegend($idP, $idQ, str_replace("ob", "obc", $layers[$type]), $idA, $subId);
			$legend = json_decode(htmlspecialchars_decode($jsonMapLegend), true);
			
			$startX = 450;
			$startY = 280;
			$w = 120;
			$h = 100;
			
			$black = imagecolorallocate($image, 0, 0, 0);
			$white = imagecolorallocate($image, 255, 255, 255);
			$grey = imagecolorallocate($image, 128, 128, 128);
			$test = imagecolorallocate($image, 128, 40, 200);
			$fill = imagefilledrectangle ($image ,$startX ,$startY ,$startX + $w, $startY + $h, $white);
			
			imagesetthickness($image, 2);
			imagerectangle($image, $startX, $startY, $startX + $w, $startY + $h, $black);
			
			$count = count($legend['data']);
			$count = $count + (($count + 1) / 2);
			
			$hh = $h / $count;
			
			$sX = $startX + 10;
			$sY = $startY + ($hh / 2);
			
			foreach ($legend['data'] as $item) {
				$name = $item['name'];
				$color = str_replace("rgba(", "", $item['fill']['color']);
				$color = str_replace(")", "", $color);
				$color = explode(",", $color);
				
				$c = imagecolorallocate($image, $color[0], $color[1], $color[2]);
				$fill = imagefilledrectangle ($image, $sX ,$sY ,$sX+20 ,$sY+$hh, $c);
				
				imagesetthickness($image, 1);
				imagerectangle($image, $sX ,$sY ,$sX+20 ,$sY+$hh, $black);
				
				$font = '../_support/fonts/ARIALBD.TTF';
				
				imagettftext($image, 10, 0, $sX+32, $sY+$hh+1, $grey, $font, $name);
				imagettftext($image, 10, 0, $sX+30, $sY+$hh, $black, $font, $name);
				
				$sY += $hh * 1.5;
			}
			
			// echo json_encode(array("legend"=> $legend, "image"=> imagejpeg($image)));
			imagepng($image, '/var/www/statview/_gen/test.jpeg');
			
			echo json_encode(array("path"=> '_gen/test.jpeg', "sub_id"=> $subId)); 
		}
	}
?>