<?php
include_once("_dirinfo.php");
/** Include PHPExcel */
require_once (PATH_TO_ROOT.'_support/PHPExcel.php');
include_once(PATH_TO_ROOT."mystery/init.php");
include_once(PATH_TO_ROOT."/mystery/_class/ReportManager/class.ReportManager.php");
include_once(PATH_TO_ROOT."mystery/_class/class.Language-Pack.php");
$languagePack = new LanguagePack($db,"en");

$project = $_GET["projectName"];
$reportManager = new ReportManager($db, $project, $languagePack, $_GET["langId"], $groups, TRUE);

if($_GET['records'])
{
	$reportManager->LoadRecords($_GET['records']);
}
else
{
	$reportManager->LoadRecords("SELECT id FROM ".DB_WARPIT_WEBCATI_BASE.".".$project."_structure WHERE flag_bad = 101");
}
$reportGenerator = $reportManager->getReportGenerator();
$reportGenerator->getGenerateHtml();

$exportDataArray = $reportGenerator->getDataForExport();
$headerData[] = $reportGenerator->getColumnsHeaders();

$headerCount = count($headerData[0]);
$rowCount = count($exportDataArray);


function setHeaderStyles(&$objPHPExcel, $numOfColumns = 0)
{
	$headerFontStyle = [
		'font' => [
			'name'      => 'Arial',
			'bold'      => true,
			'italic'    => false,
			'strike'    => false,
			'color'     => ['rgb' => 'FFFFFF']
		]
	];
	$headerFillStyle = [
		'fill' 	=> [
			'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
			'color'		=> ['argb' => 'FF215968']
		]
	];

	$rangeStart = PHPExcel_Cell::stringFromColumnIndex(0);
	$rangeEnd = PHPExcel_Cell::stringFromColumnIndex($numOfColumns);
	$rangeString = $rangeStart . "1:" . $rangeEnd ."1";

	$objPHPExcel->getActiveSheet()->getStyle($rangeString)->applyFromArray($headerFontStyle);
	$objPHPExcel->getActiveSheet()->getStyle($rangeString)->applyFromArray($headerFillStyle);
}

function setRowDimensions(&$objPHPExcel, $rowCount = 0)
{
	$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(70);
	for($i = 1; $i <= $rowCount + 1; $i++)
	{
		$height = 20;
		if($i == 1 )
		{
			$height = 30;
		}
		$objPHPExcel->getActiveSheet()->getRowDimension($i)->setRowHeight($height);
	}
}

function setDataStyles(&$objPHPExcel, $numOfColumns = 0, $rowCount = 1)
{
	$oddRowFillStyle = [
		'fill' 	=> [
			'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
			'color'		=> ['argb' => 'FFFFFFFF']
		]
	];

	$evenRowFillStyle = [
		'fill' 	=> [
			'type'		=> PHPExcel_Style_Fill::FILL_SOLID,
			'color'		=> ['argb' => 'FFD2D2D2']
		]
	];

	$rangeStart = PHPExcel_Cell::stringFromColumnIndex(0);
	$rangeEnd = PHPExcel_Cell::stringFromColumnIndex($numOfColumns);

	for($i = 2; $i <= ($rowCount + 1); $i++)
	{
		$style = (($i + 1) % 2 == 0) ? $evenRowFillStyle : $oddRowFillStyle;
		$rangeString = $rangeStart . $i . ":" . $rangeEnd . $i;
		$objPHPExcel->getActiveSheet()->getStyle($rangeString)->applyFromArray($style);
	}
}




// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
// Set document properties
$objPHPExcel->getProperties()->setCreator("Masmi")
							 ->setLastModifiedBy("Masmi")
							 ->setTitle("Export")
							 ->setSubject("Export")
							 ->setDescription("Export Total");

$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setName('Verdana');
//add headers
$objPHPExcel->getActiveSheet()->fromArray($headerData, NULL, 'A1');
//add data
$objPHPExcel->getActiveSheet()->fromArray($exportDataArray, NULL, 'A2');


setRowDimensions($objPHPExcel, $rowCount);
setHeaderStyles($objPHPExcel, $headerCount);
setDataStyles($objPHPExcel, $headerCount, $rowCount);

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Export');
// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
header('Content-Disposition: attachment;filename="Export-Total.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit;

?>
